/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.sys.BFoxService;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.sysdef.BPersistTask;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.BResolveBits;
import com.tridium.nd.sysdef.ProviderSession;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.sys.Nre;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import com.tridium.util.ArrayUtil;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import javax.baja.firewall.BServerPort;
import javax.baja.naming.SlotPath;
import javax.baja.nd.BStationRole;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameList;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;
import javax.baja.util.QueueFullException;
import javax.baja.util.Worker;
import javax.baja.web.BWebService;

public class BLocalSysDefStation
extends BProviderStation
implements Runnable,
ICoalesceable,
ServiceListener {
    public static final Property persistTask = BLocalSysDefStation.newProperty((int)4, (BValue)new BPersistTask(), null);
    public static final Type TYPE = Sys.loadType(BLocalSysDefStation.class);
    private static final long WAIT_TIME = 10000L;
    private static final String FOX_PORT_LINK = "foxPortAutoLink";
    private static final String FOXS_PORT_LINK = "foxsPortAutoLink";
    private static final String HTTP_PORT_LINK = "httpPortAutoLink";
    private static final String HTTPS_PORT_LINK = "httpsPortAutoLink";
    private static final String DAEMON_PORT_LINK = "localDaemonPortAutoLink";
    private static final String DAEMON_SSL_PORT_LINK = "localDaemonSslPortAutoLink";
    private final LinkedBlockingQueue<BIService> stoppingServices = new LinkedBlockingQueue();
    private Worker worker;
    private CoalesceQueue workQueue;

    public BPersistTask getPersistTask() {
        return (BPersistTask)this.get(persistTask);
    }

    public void setPersistTask(BPersistTask v) {
        this.set(persistTask, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BLocalSysDefStation() {
    }

    public BLocalSysDefStation(String name) {
        super(name);
    }

    protected final BNiagaraNetwork getNetwork() {
        return (BNiagaraNetwork)this.getParent();
    }

    public void stationChanged() {
        this.updateStationVersion();
        try (ProviderSession session = null;){
            BNiagaraNetwork network = this.getNetwork();
            session = network.getSysDefProvider().createSession("stationChanged", null);
            session.update(this, BResolveBits.STATION);
            network.scheduleSync(BStationRole.supervisor);
            network.scheduleSync(BStationRole.subordinate);
        }
    }

    @Override
    public boolean addRef(String stationName, BStationRole role) {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        boolean didOp = super.addRef(stationName, role);
        if (didOp) {
            this.networkChanged();
        }
        return didOp;
    }

    @Override
    public boolean removeRef(String stationName, BStationRole role) {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        boolean didOp = super.removeRef(stationName, role);
        if (didOp) {
            this.networkChanged();
        }
        return didOp;
    }

    public void networkChanged() {
        this.updateNetworkVersion();
        try (ProviderSession session = null;){
            BNiagaraNetwork network = this.getNetwork();
            session = network.getSysDefProvider().createSession("networkChanged", null);
            session.update(this, BResolveBits.network);
            network.scheduleSync(BStationRole.supervisor);
        }
    }

    public void descendantsStarted() throws Exception {
        if (Sys.isStationStarted()) {
            this.stationStarted();
        }
    }

    public void stationStarted() throws Exception {
        this.update();
        AccessController.doPrivileged(() -> Nre.getServiceManager()).addServiceListener((ServiceListener)this);
    }

    public void stopped() {
        AccessController.doPrivileged(() -> Nre.getServiceManager()).removeServiceListener((ServiceListener)this);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property != subordinates && property != supervisors && property != stationVersion && property != networkVersion) {
            this.stationChanged();
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraNetwork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.update();
        }
        finally {
            LinkedBlockingQueue<BIService> linkedBlockingQueue = this.stoppingServices;
            synchronized (linkedBlockingQueue) {
                if (this.workQueue.isEmpty()) {
                    this.worker.stop();
                    this.worker = null;
                    this.workQueue = null;
                }
            }
        }
    }

    private void update() {
        ArrayList stoppingServicesList = new ArrayList();
        this.stoppingServices.drainTo(stoppingServicesList);
        BComponent[] services = AccessController.doPrivileged(() -> Nre.getServiceManager()).getAllServices();
        Array serviceTypes = new Array(String.class);
        for (BComponent service : services) {
            if (stoppingServicesList.contains(service)) {
                BLocalSysDefStation.waitUntilServiceUnregistered(service);
                continue;
            }
            serviceTypes.add((Object)SlotPath.escape((String)service.getType().getTypeSpec().toString()));
        }
        BNameList list = BNameList.make((String[])((String[])serviceTypes.trim()));
        if (!this.getServices().equals((Object)list)) {
            this.setServices(list);
        }
        try {
            BFoxService foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
            if (stoppingServicesList.contains(foxService)) {
                throw new ServiceNotFoundException();
            }
            if (this.getSlot(FOX_PORT_LINK) == null) {
                try {
                    BLocalSysDefStation.waitUntilComponentRunning((BComponent)foxService.getFoxPort());
                    BLink link = this.makeLink((BComponent)foxService.getFoxPort(), (Slot)BServerPort.publicServerPort, (Slot)foxPort, null);
                    this.add(FOX_PORT_LINK, (BValue)link, 6);
                }
                catch (Exception link) {
                    // empty catch block
                }
            }
            if (this.getSlot(FOXS_PORT_LINK) == null) {
                BLocalSysDefStation.waitUntilComponentRunning((BComponent)foxService.getFoxsPort());
                BLink link = this.makeLink((BComponent)foxService.getFoxsPort(), (Slot)BServerPort.publicServerPort, (Slot)foxsPort, null);
                this.add(FOXS_PORT_LINK, (BValue)link, 6);
            }
        }
        catch (ServiceNotFoundException snfe) {
            Property foxsPortLink;
            this.setFoxPort(-1);
            this.setFoxsPort(-1);
            Property foxPortLink = this.getProperty(FOX_PORT_LINK);
            if (foxPortLink != null) {
                try {
                    this.remove(foxPortLink);
                }
                catch (Exception service) {
                    // empty catch block
                }
            }
            if ((foxsPortLink = this.getProperty(FOXS_PORT_LINK)) != null) {
                try {
                    this.remove(foxsPortLink);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception snfe) {
            // empty catch block
        }
        try {
            BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
            if (stoppingServicesList.contains(webService)) {
                throw new ServiceNotFoundException();
            }
            if (this.getSlot(HTTP_PORT_LINK) == null) {
                try {
                    BLocalSysDefStation.waitUntilComponentRunning((BComponent)webService.getHttpPort());
                    BLink link = this.makeLink((BComponent)webService.getHttpPort(), (Slot)BServerPort.publicServerPort, (Slot)httpPort, null);
                    this.add(HTTP_PORT_LINK, (BValue)link, 6);
                }
                catch (Exception link) {
                    // empty catch block
                }
            }
            if (this.getSlot(HTTPS_PORT_LINK) == null) {
                BLocalSysDefStation.waitUntilComponentRunning((BComponent)webService.getHttpsPort());
                BLink link = this.makeLink((BComponent)webService.getHttpsPort(), (Slot)BServerPort.publicServerPort, (Slot)httpsPort, null);
                this.add(HTTPS_PORT_LINK, (BValue)link, 6);
            }
        }
        catch (ServiceNotFoundException snfe) {
            Property httpsPortLink;
            this.setHttpPort(-1);
            this.setHttpsPort(-1);
            Property httpPortLink = this.getProperty(HTTP_PORT_LINK);
            if (httpPortLink != null) {
                try {
                    this.remove(httpPortLink);
                }
                catch (Exception foxsPortLink) {
                    // empty catch block
                }
            }
            if ((httpsPortLink = this.getProperty(HTTPS_PORT_LINK)) != null) {
                try {
                    this.remove(httpsPortLink);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception snfe) {
            // empty catch block
        }
        try {
            BSystemPlatformService platService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            if (stoppingServicesList.contains(platService)) {
                throw new ServiceNotFoundException();
            }
            if (this.getSlot(DAEMON_PORT_LINK) == null) {
                try {
                    BLocalSysDefStation.waitUntilComponentRunning((BComponent)platService);
                    BLink link = this.makeLink((BComponent)platService, (Slot)BSystemPlatformService.localDaemonPort, (Slot)niagaraDaemonPort, null);
                    this.add(DAEMON_PORT_LINK, (BValue)link, 6);
                }
                catch (Exception link) {
                    // empty catch block
                }
            }
            if (this.getSlot(DAEMON_SSL_PORT_LINK) == null) {
                BLocalSysDefStation.waitUntilComponentRunning((BComponent)platService);
                BLink link = this.makeLink((BComponent)platService, (Slot)BSystemPlatformService.localDaemonSslPort, (Slot)niagaraDaemonSslPort, null);
                this.add(DAEMON_SSL_PORT_LINK, (BValue)link, 6);
            }
        }
        catch (ServiceNotFoundException snfe) {
            Property daemonSslPortLink;
            this.setNiagaraDaemonPort(-1);
            this.setNiagaraDaemonSslPort(-1);
            Property daemonPortLink = this.getProperty(DAEMON_PORT_LINK);
            if (daemonPortLink != null) {
                try {
                    this.remove(daemonPortLink);
                }
                catch (Exception httpsPortLink) {
                    // empty catch block
                }
            }
            if ((daemonSslPortLink = this.getProperty(DAEMON_SSL_PORT_LINK)) != null) {
                try {
                    this.remove(daemonSslPortLink);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void waitUntilComponentRunning(BComponent comp) {
        if (!comp.isRunning()) {
            try {
                long startTicks = Clock.ticks();
                while (!comp.isRunning() && Clock.ticks() - startTicks < 10000L) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void waitUntilServiceUnregistered(BComponent service) {
        if (service != null) {
            try {
                long startTicks = Clock.ticks();
                Object[] registeredServices = AccessController.doPrivileged(() -> Nre.getServiceManager()).getServices(service.getType().toString());
                while (ArrayUtil.indexOf((Object[])registeredServices, (Object)service) >= 0 && Clock.ticks() - startTicks < 10000L) {
                    Thread.sleep(100L);
                    registeredServices = AccessController.doPrivileged(() -> Nre.getServiceManager()).getServices(service.getType().toString());
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public Object getCoalesceKey() {
        return this;
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceEvent(BServiceEvent event) {
        if (event.getId() == 0) {
            this.stoppingServices.remove(event.getService());
        } else if (event.getId() == 1) {
            if (!this.stoppingServices.contains(event.getService())) {
                this.stoppingServices.add(event.getService());
            }
        } else {
            return;
        }
        LinkedBlockingQueue<BIService> linkedBlockingQueue = this.stoppingServices;
        synchronized (linkedBlockingQueue) {
            if (this.workQueue == null) {
                this.workQueue = new CoalesceQueue(1);
            }
            if (this.worker == null) {
                this.worker = new Worker((Worker.ITodo)this.workQueue);
                this.worker.start("LocalSysDefStation_Worker");
            }
            try {
                this.workQueue.enqueue((Object)this);
            }
            catch (QueueFullException queueFullException) {
                // empty catch block
            }
        }
    }
}

