/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.spy;

import com.tridium.nd.BCyclicThreadPoolWorker;
import com.tridium.nd.BNiagaraNetwork;
import javax.baja.spy.ISpyDir;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;

public final class SpyCyclicThreadPoolWorker
extends Spy
implements ISpyDir {
    public static final String spyName = "threadPoolWorker";
    public static final String workSpyName = "work";
    private SpyRegisteredOverview spyRegisteredOverview = new SpyRegisteredOverview();
    private SpyRegisteredObjects spyRegisteredWorkers = new SpyRegisteredObjects();
    private SpyWorker spyWorker = new SpyWorker();
    private SpyWork spyWork = new SpyWork();
    private ThreadPoolSpy[] threadPoolSpies = new ThreadPoolSpy[]{this.spyRegisteredOverview, this.spyRegisteredWorkers, this.spyWorker, this.spyWork};
    private static final String[] emptyArray = new String[0];
    private BCyclicThreadPoolWorker worker;

    public SpyCyclicThreadPoolWorker(BNiagaraNetwork network) {
        this.worker = network.getWorkers();
    }

    public void write(SpyWriter out) throws Exception {
        this.spyRegisteredOverview.write(out);
    }

    public String[] list() {
        return emptyArray;
    }

    public Spy find(String name) {
        for (int i = 0; i < this.threadPoolSpies.length; ++i) {
            if (!this.threadPoolSpies[i].getHeaderName().equals(name)) continue;
            return this.threadPoolSpies[i];
        }
        return null;
    }

    private void writeHeader(SpyWriter out, Spy spy) {
        out.w((Object)"<p><b>Cyclic Thread Pool Worker -</b> ");
        for (int i = 0; i < this.threadPoolSpies.length; ++i) {
            ThreadPoolSpy s = this.threadPoolSpies[i];
            out.w((Object)"[");
            this.writeSpyHeaderLink(out, s.getHeaderName(), s.getHeaderDisplayName(), s != spy);
            out.w((Object)"] ");
        }
        out.w((Object)"</p><hr>");
    }

    private String getSpyNav(String name) {
        StringBuffer buff = new StringBuffer();
        buff.append("spy:/niagaraNetwork/").append(spyName);
        if (name.length() > 0) {
            buff.append("/").append(name);
        }
        return buff.toString();
    }

    private void writeSpyHeaderLink(SpyWriter out, String name, String displayName, boolean anchor) {
        if (anchor) {
            out.a(this.getSpyNav(name), (Object)displayName);
        } else {
            out.safe((Object)displayName);
        }
    }

    private class SpyWorkStackTrace
    extends Spy {
        private String name;

        private SpyWorkStackTrace(String name) {
            this.name = name;
        }

        public void write(SpyWriter out) throws Exception {
            int index = Integer.parseInt(this.name.substring(5, this.name.length()));
            SpyCyclicThreadPoolWorker.this.worker.spyWorkStackTrace(index, out);
        }
    }

    private class SpyWork
    extends ThreadPoolSpy
    implements ISpyDir {
        private SpyWork() {
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            super.write(out);
            out.w((Object)"<p>Spying the Work that's processed will have an impact on performance. ").w((Object)"To enable or disable process spying, please set the 'niagara.network.spywork'").w((Object)" System Property to either true or false. To see individual work stack traces, ").w((Object)"please also set 'niagara.network.spywork.stacktrace' to true. Please note, this").w((Object)" will cause even more of a performance hit. <hr>");
            SpyCyclicThreadPoolWorker.this.worker.spyWorkInfo(out);
        }

        public String[] list() {
            return emptyArray;
        }

        public Spy find(String name) {
            if (name.startsWith("stack")) {
                return new SpyWorkStackTrace(name);
            }
            return null;
        }

        @Override
        protected String getHeaderName() {
            return SpyCyclicThreadPoolWorker.workSpyName;
        }

        @Override
        protected String getHeaderDisplayName() {
            return "Work";
        }
    }

    private class SpyRegisteredObjects
    extends ThreadPoolSpy {
        private SpyRegisteredObjects() {
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            if (!SpyCyclicThreadPoolWorker.this.worker.isRunning()) {
                SpyCyclicThreadPoolWorker.this.spyWorker.write(out);
                return;
            }
            super.write(out);
            SpyCyclicThreadPoolWorker.this.worker.spyRegisteredObjects(out);
        }

        @Override
        protected String getHeaderName() {
            return "registeredObjects";
        }

        @Override
        protected String getHeaderDisplayName() {
            return "Registered Objects";
        }
    }

    private class SpyWorker
    extends ThreadPoolSpy {
        private SpyWorker() {
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            super.write(out);
            SpyCyclicThreadPoolWorker.this.worker.spyWorker(out);
        }

        @Override
        protected String getHeaderName() {
            return "worker";
        }

        @Override
        protected String getHeaderDisplayName() {
            return "Worker";
        }
    }

    private class SpyRegisteredOverview
    extends ThreadPoolSpy {
        private SpyRegisteredOverview() {
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            super.write(out);
            SpyCyclicThreadPoolWorker.this.worker.spyRegisteredOverview(out);
        }

        @Override
        protected String getHeaderName() {
            return "";
        }

        @Override
        protected String getHeaderDisplayName() {
            return "Registered Overview";
        }
    }

    private abstract class ThreadPoolSpy
    extends Spy {
        private ThreadPoolSpy() {
        }

        public void write(SpyWriter out) throws Exception {
            SpyCyclicThreadPoolWorker.this.writeHeader(out, this);
        }

        protected abstract String getHeaderName();

        protected abstract String getHeaderDisplayName();
    }
}

