/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.schedule;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.IncompatibleVersionException;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.schedule.BNiagaraScheduleDeviceExt;
import java.util.logging.Level;
import javax.baja.driver.schedule.BScheduleImportExt;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;

public class BScheduleChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType(BScheduleChannel.class);

    public Type getType() {
        return TYPE;
    }

    public BScheduleChannel() {
        super("schedule");
    }

    public final BNiagaraScheduleDeviceExt getDeviceExt() {
        try {
            return ((BNiagaraStation)this.getConnection().getConnectionTarget(BNiagaraStation.class).orElseThrow(NullPointerException::new)).getSchedules();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public void checkProcess(FoxRequest req) throws Throwable {
        if (this.getConnection().session().isLegacyConnection() && req.command.equals("export")) {
            throw new IncompatibleVersionException("NiagaraAX station cannot export schedule to a Niagara4 station");
        }
    }

    public void checkSendRequest(FoxRequest req) throws Exception {
        if (this.getConnection().session().isLegacyConnection() && req.command.equals("import")) {
            throw new IncompatibleVersionException("Niagara4 station cannot import schedule from a NiagaraAX station");
        }
        super.checkSendRequest(req);
    }

    public FoxResponse process(FoxRequest req) throws Exception {
        try {
            BNiagaraScheduleDeviceExt dvt = this.getDeviceExt();
            FoxResponse res = new FoxResponse(req);
            String command = req.command;
            if (command.equals("export")) {
                String supId = BNiagaraScheduleDeviceExt.getSupervisorId((FoxMessage)req);
                BScheduleImportExt ext = dvt.getExtForSupervisorId(supId);
                BPermissions p = this.getPermissionsFor(ext);
                if (!p.hasAdminWrite()) {
                    throw new PermissionException("User does not have permission to export schedule");
                }
                BAbsTime ver = dvt.processExport(supId, BNiagaraScheduleDeviceExt.getSupervisor((FoxMessage)req));
                BNiagaraScheduleDeviceExt.setSubordinateVersion((FoxMessage)res, ver);
            } else if (command.equals("import")) {
                String id = BNiagaraScheduleDeviceExt.getSupervisorId((FoxMessage)req);
                BPermissions p = this.getPermissionsFor(BOrd.make((String)id).resolve((BObject)dvt).get());
                if (!p.hasAdminRead()) {
                    throw new PermissionException("User does not have permission to import schedule");
                }
                BAbstractSchedule sch = dvt.processImport(id, BNiagaraScheduleDeviceExt.getSubordinateVersion((FoxMessage)req));
                if (sch != null) {
                    Version bogVersion = this.getConnection().session().isLegacyConnection() ? ValueDocEncoder.BOG_VERSION_1 : null;
                    BNiagaraScheduleDeviceExt.setSupervisor((FoxMessage)res, sch, bogVersion);
                }
            } else if (command.equals("learn")) {
                BNiagaraScheduleDeviceExt.encode((FoxMessage)res, this.getDeviceExt().processLearn());
            } else {
                throw new InvalidCommandException(command);
            }
            return res;
        }
        catch (PermissionException pe) {
            throw pe;
        }
        catch (Exception x) {
            BNiagaraScheduleDeviceExt s = this.getDeviceExt();
            if (s != null) {
                BNiagaraScheduleDeviceExt.log.log(Level.SEVERE, "Error receiving msg: " + s.toPathString(), x);
            }
            throw x;
        }
    }
}

