/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.point;

import com.tridium.fox.message.FoxBoolean;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxString;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nv.BNiagaraVirtualComponent;
import com.tridium.nv.BNiagaraVirtualGateway;
import com.tridium.nv.point.BVirtualAction;
import com.tridium.nv.point.INiagaraProxyExt;
import com.tridium.sys.tag.ComponentTags;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BIStatus;
import javax.baja.status.BIStatusValue;
import javax.baja.status.BStatus;
import javax.baja.sync.Transaction;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;

public class ServerEntry
implements Comparable<ServerEntry> {
    public final int messageId;
    public final String type;
    public final String pointId;
    public int minSendTime;
    public int maxSendTime;
    public long subTime;
    public long lastSent;
    public BComponent component;
    public Property[] path;
    public BPermissions permissions;
    public boolean changed;
    public boolean sendActions;
    public String tagsToSend;
    private BPointChannel channel;

    public ServerEntry(FoxMessage in) throws Exception {
        this.messageId = in.getInt("mid");
        this.pointId = in.getString("pid");
        this.type = in.getString("t").intern();
        this.minSendTime = in.getInt("minSend");
        this.maxSendTime = in.getInt("maxSend");
        this.sendActions = in.getBoolean("fetchActions", false);
        this.tagsToSend = in.getString("fetchRemoteTags", null);
    }

    public FoxMessage init(BPointChannel channel) {
        boolean ok;
        this.channel = channel;
        FoxMessage err = new FoxMessage("pt");
        err.add("mid", this.messageId);
        try {
            try {
                OrdTarget t = BOrd.make((String)this.pointId).resolve((BObject)Sys.getStation());
                this.component = t.getComponent();
                this.path = t.getPropertyPathInComponent();
            }
            catch (NullOrdException e) {
                err.add("err", "Null ord: " + this.pointId);
                return err;
            }
            catch (UnresolvedException e) {
                err.add("err", "Unresolved ord: " + this.pointId);
                return err;
            }
            this.permissions = channel.getPermissionsFor(this.component);
            if (!this.permissions.hasOperatorRead()) {
                err.add("err", "Invalid permissions");
                return err;
            }
        }
        catch (Throwable e) {
            channel.log.error("Cannot init: " + this.pointId, e);
            err.add("err", e.toString());
            return err;
        }
        FoxMessage msg = this.update(channel.log);
        this.lastSent = this.subTime = Clock.ticks();
        boolean bl = ok = msg.getString("err", null) == null;
        if (ok) {
            channel.getServerWorker().sub(this);
        }
        return msg;
    }

    public boolean sendUpdate(long ticksNow) {
        long nextMax = this.lastSent + (long)this.maxSendTime;
        if (ticksNow > nextMax) {
            return true;
        }
        if (!this.component.isMounted()) {
            return true;
        }
        if (!this.changed) {
            return false;
        }
        long nextMin = this.lastSent + (long)this.minSendTime;
        return nextMin <= ticksNow;
    }

    public FoxMessage update(FoxLog log) {
        FoxMessage msg = new FoxMessage("pt");
        msg.add("mid", this.messageId);
        try {
            if (!this.component.isMounted()) {
                msg.add("err", "Component removed");
                return msg;
            }
            BComponent target = this.component;
            if (this.path != null) {
                for (int i = 0; i < this.path.length; ++i) {
                    if ((target = ((BComplex)target).get(this.path[i])) != null) continue;
                    msg.add("err", "Unresolved path");
                    return msg;
                }
            }
            ServerEntry.targetToMessage(this.channel, this.type, (BObject)target, msg);
            if (this.sendActions) {
                msg.add((FoxTuple)ServerEntry.actionsToMessage(this.component, this.permissions, log, false));
                this.sendActions = false;
            }
            if (this.tagsToSend != null) {
                msg.add((FoxTuple)ServerEntry.tagsToMessage(this.component, this.permissions, log, this.tagsToSend));
                this.tagsToSend = null;
            }
        }
        catch (Exception e) {
            log.error("update", (Throwable)e);
            msg.add("err", e.toString());
        }
        return msg;
    }

    public static FoxMessage targetToMessage(BPointChannel channel, String type, BObject target, FoxMessage msg) {
        try {
            try {
                switch (type.charAt(0)) {
                    case 'b': {
                        msg.add("v", ((BIBoolean)target).getBoolean());
                        break;
                    }
                    case 'n': {
                        msg.add("v", ((BINumeric)target).getNumeric());
                        break;
                    }
                    case 'e': {
                        msg.add("v", ((BIEnum)target).getEnum().getOrdinal());
                        break;
                    }
                    case 'v': {
                        if (target instanceof BComponent) {
                            System.out.println("Error: target to message is a component: " + target.getType());
                        }
                        msg.add("v", channel.encodeValueToString((BValue)target));
                        break;
                    }
                    default: {
                        String str = target instanceof BIStatusValue ? ((BIStatusValue)target).getStatusValue().getValueValue().toString(null) : target.toString(null);
                        msg.add("v", str);
                        break;
                    }
                }
            }
            catch (Exception e) {
                msg.add("err", "Type mismatch " + type + " != " + target.getType());
                return msg;
            }
            BStatus status = BStatus.ok;
            if (target instanceof BIStatus) {
                status = ((BIStatus)target).getStatus();
            }
            msg.add("s", status.encodeToString());
            return msg;
        }
        catch (Exception e) {
            msg.add("err", "Internal error " + e);
            return msg;
        }
    }

    public static BVirtualAction[] messageToActions(FoxMessage msgList, FoxLog log) {
        try {
            FoxTuple[] tuples = msgList.list("action");
            BVirtualAction[] actions = new BVirtualAction[tuples.length];
            for (int i = 0; i < actions.length; ++i) {
                FoxTuple frozenTup;
                FoxMessage msg = (FoxMessage)tuples[i];
                String name = msg.getString("name");
                String display = "";
                FoxTuple displayTup = msg.getOptional("display");
                if (displayTup != null) {
                    display = ((FoxString)displayTup).value;
                }
                String paramTypeStr = msg.getString("param", null);
                String returnTypeStr = msg.getString("return", null);
                String flagsStr = msg.getString("flags", null);
                String facetsStr = msg.getString("facets", null);
                Type paramType = null;
                if (paramTypeStr != null) {
                    paramType = Sys.getType((String)paramTypeStr);
                }
                Type returnType = null;
                if (returnTypeStr != null) {
                    returnType = Sys.getType((String)returnTypeStr);
                }
                int flags = 0;
                if (flagsStr != null) {
                    flags = Flags.decodeFromString((String)flagsStr);
                }
                BFacets facets = BFacets.NULL;
                if (facetsStr != null) {
                    facets = BFacets.make((String)facetsStr);
                }
                if ((frozenTup = msg.getOptional("frozen")) != null) {
                    facets = BFacets.make((BFacets)facets, (String)"nVirtualFroz", (BIDataValue)BBoolean.make((boolean)((FoxBoolean)frozenTup).value));
                }
                actions[i] = new BVirtualAction(name, display, returnType, paramType, flags, facets);
            }
            return actions;
        }
        catch (Exception e) {
            log.error("messageToActions", (Throwable)e);
            return new BVirtualAction[0];
        }
    }

    public static FoxMessage actionsToMessage(BComponent component, BPermissions permissions, FoxLog log, boolean virtual) {
        FoxMessage msgList = new FoxMessage("actions");
        try {
            if (component instanceof BNiagaraVirtualComponent) {
                ((BNiagaraVirtualComponent)component).niagaraVirtualCompCheckActions();
            }
            Action[] actions = component.getActionsArray();
            for (int i = 0; i < actions.length; ++i) {
                Action action = actions[i];
                if (Flags.isHidden((BComplex)component, (Slot)action) || (Flags.isOperator((BComplex)component, (Slot)action) ? !permissions.hasOperatorInvoke() : !permissions.hasAdminInvoke())) continue;
                Type param = action.getParameterType();
                Type ret = action.getReturnType();
                int flags = component.getFlags((Slot)action);
                BFacets facets = component.getSlotFacets((Slot)action);
                FoxMessage msg = new FoxMessage("action");
                msg.add("name", action.getName());
                msg.add("flags", Flags.encodeToString((int)flags));
                if (param != null) {
                    msg.add("param", param.toString());
                }
                if (ret != null) {
                    msg.add("return", ret.toString());
                }
                if (!facets.isNull()) {
                    msg.add("facets", facets.encodeToString());
                }
                if (virtual) {
                    BNameMap nameMap;
                    BFormat f;
                    msg.add("frozen", facets.getb("nVirtualFroz", action.isFrozen()));
                    Property nameMapProperty = component.getProperty("displayNames");
                    if (nameMapProperty != null && nameMapProperty.getType().is(BNameMap.TYPE) && (f = (nameMap = (BNameMap)component.get(nameMapProperty)).get(action.getName())) != null) {
                        msg.add("display", f.encodeToString());
                    }
                } else {
                    msg.add("display", component.getDisplayName((Slot)action, null));
                }
                msgList.add((FoxTuple)msg);
            }
        }
        catch (Exception e) {
            log.error("actionsToMessage", (Throwable)e);
        }
        return msgList;
    }

    public static void messageToTags(FoxMessage msgList, FoxLog log, String requestedTagsToFetch, INiagaraProxyExt ext, Map<String, BIDataValue> tagMap) {
        try {
            boolean persistFetchedTags = ext.persistFetchedTags();
            if (!persistFetchedTags && tagMap == null) {
                return;
            }
            BComponent target = ext.getProxyComponentToTag();
            if (target == null) {
                return;
            }
            FoxTuple[] tuples = msgList.list("tag");
            HashSet<String> tagIds = persistFetchedTags ? new HashSet<String>(tuples.length) : null;
            for (FoxTuple tuple : tuples) {
                FoxMessage msg = (FoxMessage)tuple;
                String name = msg.getString("name");
                String encodedValue = msg.getString("val");
                BTypeSpec typeSpec = BTypeSpec.make((String)msg.getString("type"));
                BValue val = typeSpec.getInstance().asSimple().decodeFromString(encodedValue).asValue();
                if (tagMap != null) {
                    tagMap.put(name, (BIDataValue)val);
                }
                if (!persistFetchedTags) continue;
                tagIds.add(name);
                String flagsStr = msg.getString("flags", null);
                String facetsStr = msg.getString("facets", null);
                int flags = 0;
                if (flagsStr != null) {
                    flags |= Flags.decodeFromString((String)flagsStr);
                }
                BFacets facets = BFacets.NULL;
                if (facetsStr != null) {
                    facets = BFacets.make((String)facetsStr);
                }
                BPointChannel.addProxyTag((Entity)target, name, (BIDataValue)val, flags, facets);
            }
            if (tagIds != null) {
                List<String> validTagNames = Arrays.asList(requestedTagsToFetch.split(";"));
                BComponentSpace space = target.getComponentSpace();
                Transaction transaction = space != null ? space.newTransaction() : null;
                for (Tag tag : new ComponentTags(target)) {
                    Property tagProp;
                    String tagId = tag.getId().getQName();
                    if (tagIds.contains(tagId) || !validTagNames.contains(tagId) || (tagProp = target.getProperty(SlotPath.escape((String)tagId))) == null || !Flags.isReadonly((BComplex)target, (Slot)tagProp)) continue;
                    target.remove(tagProp, (Context)transaction);
                }
                if (transaction != null) {
                    transaction.commit();
                }
            }
        }
        catch (Exception e) {
            log.error("messageToTags", (Throwable)e);
        }
    }

    public static FoxMessage tagsToMessage(BComponent component, BPermissions permissions, FoxLog log, String requestedTags) {
        FoxMessage msgList = new FoxMessage("tags");
        try {
            String[] tagIds = requestedTags.split(";");
            Map<Object, Object> remoteTags = Collections.emptyMap();
            if (component.getType().is(BControlPoint.TYPE)) {
                BControlPoint point = (BControlPoint)component;
                if (point.getProxyExt().getType().is(BNiagaraProxyExt.TYPE)) {
                    BNiagaraProxyExt nProxyExt = (BNiagaraProxyExt)point.getProxyExt();
                    remoteTags = BNiagaraProxyExt.doFetchRawRemoteTags(Arrays.asList(tagIds), nProxyExt, nProxyExt.getNiagaraStation());
                }
            } else if (component.getType().is(BNiagaraVirtualComponent.TYPE)) {
                BNiagaraVirtualComponent vComp = (BNiagaraVirtualComponent)component;
                BNiagaraVirtualGateway vGateway = vComp.getNiagaraVirtualGateway();
                INiagaraProxyExt ext = vComp.getNiagaraProxyExt();
                if (ext != null && vGateway != null && vGateway.getStationAdapter() != null) {
                    String stationName = vGateway.getStationAdapter().getStationName();
                    BComplex parent = vGateway.getParent();
                    if (parent != null && parent.getType().is(BNiagaraStation.TYPE) && ((BNiagaraStation)parent).getStationName().equals(stationName)) {
                        remoteTags = BNiagaraProxyExt.doFetchRawRemoteTags(Arrays.asList(tagIds), ext, (BNiagaraStation)parent);
                    }
                }
            }
            Tags tags = component.tags();
            for (String tagId : tagIds) {
                BIDataValue val;
                Optional tag;
                block14: {
                    try {
                        tag = tags.get(Id.newId((String)tagId));
                    }
                    catch (Exception e) {
                        tag = Optional.empty();
                        if (!log.isTraceOn()) break block14;
                        log.trace("Skipping fetch for invalid requested tag '" + tagId + '\'');
                    }
                }
                if (tag.isPresent()) {
                    val = (BIDataValue)tag.get();
                    Property prop = component.getProperty(SlotPath.escape((String)tagId));
                    if (prop != null) {
                        if (Flags.isOperator((BComplex)component, (Slot)prop) ? !permissions.hasOperatorRead() : !permissions.hasAdminRead()) continue;
                        int flags = component.getFlags((Slot)prop);
                        BFacets facets = component.getSlotFacets((Slot)prop);
                        FoxMessage msg = new FoxMessage("tag");
                        msg.add("name", tagId);
                        msg.add("type", val.getType().getTypeSpec().encodeToString());
                        msg.add("flags", Flags.encodeToString((int)flags));
                        if (!facets.isNull()) {
                            msg.add("facets", facets.encodeToString());
                        }
                        msg.add("val", val.encodeToString());
                        msg.add("display", component.getDisplayName((Slot)prop, null));
                        msgList.add((FoxTuple)msg);
                        continue;
                    }
                    FoxMessage msg = new FoxMessage("tag");
                    msg.add("name", tagId);
                    msg.add("type", val.getType().getTypeSpec().encodeToString());
                    msg.add("val", val.encodeToString());
                    msgList.add((FoxTuple)msg);
                    continue;
                }
                if (!remoteTags.containsKey(tagId)) continue;
                val = (BIDataValue)remoteTags.get(tagId);
                FoxMessage msg = new FoxMessage("tag");
                msg.add("name", tagId);
                msg.add("type", val.getType().getTypeSpec().encodeToString());
                msg.add("val", val.encodeToString());
                msgList.add((FoxTuple)msg);
            }
        }
        catch (Exception e) {
            log.error("tagsToMessage", (Throwable)e);
        }
        return msgList;
    }

    public String toString() {
        return "[" + this.messageId + "] " + this.pointId;
    }

    public String pathToString() {
        if (this.path == null) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.path.length; ++i) {
            if (i > 0) {
                s.append('/');
            }
            s.append(this.path[i].getName());
        }
        return s.toString();
    }

    public String lastSentToString() {
        if (this.lastSent == this.subTime) {
            return "onSub";
        }
        return BRelTime.toString((long)(Clock.ticks() - this.lastSent));
    }

    public String subscribeDurationToString() {
        return BRelTime.toString((long)(Clock.ticks() - this.subTime));
    }

    @Override
    public int compareTo(ServerEntry o) {
        int x = o.messageId;
        if (x == this.messageId) {
            return 0;
        }
        if (this.messageId < x) {
            return -1;
        }
        return 1;
    }
}

