/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.point;

import com.tridium.data.BToDataTable;
import com.tridium.data.DataTableDecoder;
import com.tridium.data.DataTableEncoder;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.IncompatibleVersionException;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.fox.sys.file.BFileChannel;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.file.BNiagaraDiscoveredFileInfo;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.nd.point.BNiagaraTuningPolicy;
import com.tridium.nd.point.ServerEntry;
import com.tridium.nd.point.ServerWorker;
import com.tridium.nd.virtual.BNiagaraVirtualChannel;
import com.tridium.nv.BNiagaraVirtualGateway;
import com.tridium.nv.BSlotInfo;
import com.tridium.nv.NiagaraVirtualUtil;
import com.tridium.nv.point.BSubscriptionState;
import com.tridium.nv.point.BVirtualAction;
import com.tridium.nv.point.INiagaraProxyExt;
import com.tridium.nv.point.IProxyActionParent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.baja.collection.BITable;
import javax.baja.control.util.BOverride;
import javax.baja.data.BIDataTable;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.IntHashMap;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Tags;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;

public class BPointChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType(BPointChannel.class);
    private final ValueDocDecoder.ITypeResolver skipLegacyTypeResolver = new BFoxChannel.LegacyTypeResolver((BFoxChannel)this, true);
    private final ValueDocDecoder.ITypeResolver failLegacyTypeResolver = new BFoxChannel.LegacyTypeResolver((BFoxChannel)this, false);
    private static final Version VER_3_7 = new Version("3.7");
    private static final Version VER_4_9U1 = new Version("4.9.1.29");
    private static final BOrd ROOT_SLOT_ORD = BOrd.make((String)"slot:/");

    public Type getType() {
        return TYPE;
    }

    public BPointChannel() {
        super("point");
    }

    public final BNiagaraPointDeviceExt getPoints() {
        try {
            return ((BNiagaraStation)this.getConnection().getConnectionTarget(BNiagaraStation.class).orElseThrow(NullPointerException::new)).getPoints();
        }
        catch (Exception e) {
            return null;
        }
    }

    public final ServerWorker getServerWorker() {
        return ((BNiagaraStation)this.getConnection().getConnectionTarget(BNiagaraStation.class).orElseThrow((Supplier<NullPointerException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/NullPointerException;)())).getPoints().serverWorker;
    }

    private BNiagaraNetwork getNiagaraNetwork() {
        return ((BNiagaraStation)this.getConnection().getConnectionTarget(BNiagaraStation.class).orElseThrow(NullPointerException::new)).getNiagaraNetwork();
    }

    protected final boolean useSharedKeyEncryption() {
        return true;
    }

    public void checkProcess(FoxRequest req) throws Throwable {
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (command.equals("sub")) {
            return this.subscribe(request);
        }
        if (command.equals("unsub")) {
            return this.unsubscribe(request);
        }
        if (command.equals("change")) {
            return this.change(request);
        }
        if (command.equals("getActionDefault")) {
            return this.getActionDefault(request);
        }
        if (command.equals("invoke")) {
            return this.invoke(request);
        }
        if (command.equals("getActions")) {
            return this.getActions(request);
        }
        if (command.equals("write")) {
            return this.write(request);
        }
        if (command.equals("fetchRemoteTags")) {
            return this.fetchRemoteTags(request);
        }
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        if (command == "discover") {
            this.discover(circuit);
            return;
        }
        if (command == "discoverSlots") {
            this.discoverSlots(circuit);
            return;
        }
        if (command == "discoverFiles") {
            this.discoverFiles(circuit);
            return;
        }
        if (command == "discoverPartialSlots") {
            this.discoverPartialSlots(circuit);
            return;
        }
        throw new InvalidCommandException(command);
    }

    public synchronized void subscribe(ArrayList<INiagaraProxyExt> exts) throws Exception {
        try {
            BNiagaraTuningPolicy defaultPolicy = (BNiagaraTuningPolicy)this.getNiagaraNetwork().getTuningPolicies().getDefaultPolicy();
            FoxRequest req = this.makeRequest("sub");
            for (INiagaraProxyExt ext : exts) {
                BNiagaraTuningPolicy policy = ext instanceof BNiagaraProxyExt ? ((BNiagaraProxyExt)ext).getNiagaraTuningPolicy() : defaultPolicy;
                FoxMessage msg = new FoxMessage("pt");
                msg.add("mid", ext.getMessageId());
                msg.add("pid", ext.getPointId());
                msg.add("t", ext.getPointType());
                msg.add("minSend", (int)policy.getMinUpdateTime().getMillis());
                msg.add("maxSend", (int)policy.getMaxUpdateTime().getMillis());
                if (ext.isActionFetchRequired()) {
                    msg.add("fetchActions", true);
                }
                if (ext.persistFetchedTags()) {
                    String tagsToFetch = ext.tagsToFetch();
                    msg.add("fetchRemoteTags", tagsToFetch);
                }
                req.add((FoxTuple)msg);
            }
            FoxResponse resp = this.sendSync(req);
            if (this.isTraceOn()) {
                this.trace("c:sub");
                resp.dump();
            }
            FoxTuple[] respExts = resp.list("pt");
            for (int i = 0; i < respExts.length; ++i) {
                INiagaraProxyExt ext = exts.get(i);
                FoxMessage respExt = (FoxMessage)respExts[i];
                try {
                    this.subscribed(ext, respExt);
                    continue;
                }
                catch (Throwable e) {
                    this.log.error("subscribe", e);
                }
            }
        }
        catch (Exception e) {
            try {
                this.unsubscribe(exts);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private void subscribed(INiagaraProxyExt ext, FoxMessage resp) throws Exception {
        FoxMessage tags;
        if (ext.getMessageId() != resp.getInt("mid")) {
            throw new IllegalStateException("messageId mismatch");
        }
        this.refreshValue(ext, resp);
        FoxMessage actions = (FoxMessage)resp.getOptional("actions");
        if (actions != null) {
            ext.updateActions(ServerEntry.messageToActions(actions, this.log));
        }
        if ((tags = (FoxMessage)resp.getOptional("tags")) != null) {
            ServerEntry.messageToTags(tags, this.log, ext.tagsToFetch(), ext, null);
        }
    }

    private FoxResponse subscribe(FoxRequest req) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:sub");
            req.dump();
        }
        FoxResponse resp = new FoxResponse(req);
        for (FoxTuple src : req.list("pt")) {
            FoxMessage in = (FoxMessage)src;
            ServerEntry entry = new ServerEntry(in);
            resp.add((FoxTuple)entry.init(this));
        }
        return resp;
    }

    public synchronized void unsubscribe(ArrayList<?> extsOrIds) throws Exception {
        FoxRequest req = this.makeRequest("unsub");
        for (Object extsOrId : extsOrIds) {
            FoxMessage msg = new FoxMessage("pt");
            if (extsOrId instanceof INiagaraProxyExt) {
                msg.add("mid", ((INiagaraProxyExt)extsOrId).getMessageId());
            } else {
                msg.add("mid", ((Integer)extsOrId).intValue());
            }
            req.add((FoxTuple)msg);
        }
        if (this.isTraceOn()) {
            this.trace("c:unsub");
            req.dump();
        }
        this.sendSync(req);
    }

    private FoxResponse unsubscribe(FoxRequest req) throws Exception {
        for (FoxTuple aSrc : req.list("pt")) {
            FoxMessage in = (FoxMessage)aSrc;
            this.unsubscribePoint(in);
        }
        return new FoxResponse(req);
    }

    private void unsubscribePoint(FoxMessage in) {
        try {
            int messageId = in.getInt("mid");
            if (this.isTraceOn()) {
                this.trace("s:unsub " + messageId);
            }
            this.getServerWorker().unsub(messageId);
        }
        catch (Exception e) {
            this.log.error("unsubscribePoint", (Throwable)e);
        }
    }

    public void sendChange(FoxRequest req) throws Exception {
        this.sendAsync(req);
    }

    public FoxResponse change(FoxRequest req) throws Exception {
        IntHashMap map = new IntHashMap();
        for (FoxTuple foxTuple : req.list("pt")) {
            FoxMessage pt = (FoxMessage)foxTuple;
            map.put(pt.getInt("mid"), (Object)pt);
        }
        for (FoxTuple foxTuple : this.getPoints().getProxyExtensions()) {
            FoxMessage msg;
            if (foxTuple.getSubscriptionState() != BSubscriptionState.subscribed || (msg = (FoxMessage)map.get(foxTuple.getMessageId())) == null) continue;
            try {
                this.refreshValue((INiagaraProxyExt)foxTuple, msg);
            }
            catch (Throwable e) {
                this.log.error("refreshValue", e);
            }
        }
        return null;
    }

    void refreshValue(INiagaraProxyExt ext, FoxMessage msg) throws Exception {
        BStatusBoolean readValue;
        String error = msg.getString("err", null);
        ext.setSubscriptionError(error);
        if (error != null) {
            return;
        }
        switch (ext.getPointType()) {
            case "b": {
                readValue = new BStatusBoolean(msg.getBoolean("v"));
                break;
            }
            case "n": {
                readValue = new BStatusNumeric(msg.getFloat("v"));
                break;
            }
            case "e": {
                readValue = new BStatusEnum((BEnum)BDynamicEnum.make((int)msg.getInt("v")));
                break;
            }
            case "v": {
                readValue = this.decodeValueFromString(msg.getString("v"), this.failLegacyTypeResolver);
                break;
            }
            default: {
                readValue = new BStatusString(msg.getString("v"));
            }
        }
        if (readValue instanceof BStatusValue) {
            BStatus status = (BStatus)BStatus.DEFAULT.decodeFromString(msg.getString("s", "0"));
            ((BStatusValue)readValue).setStatus(status);
        }
        ext.readValueOk((BValue)readValue);
    }

    public BValue getActionDefault(IProxyActionParent ext, BVirtualAction action) throws Exception {
        String maxDurStr;
        FoxRequest req = this.makeRequest("getActionDefault");
        req.add("pid", ext.getPointId());
        req.add("name", action.getProxyActionName());
        if (this.isTraceOn()) {
            this.trace("c:getActionDefault");
            req.dump();
        }
        FoxResponse resp = this.sendSync(req);
        BValue def = null;
        String defStr = resp.getString("default", null);
        if (defStr != null && (def = this.decodeValueFromString(defStr, this.failLegacyTypeResolver)) != null && def instanceof BOverride && (maxDurStr = resp.getString("maxOverrideDuration", null)) != null) {
            BOverride override = (BOverride)def;
            override.setMaxOverrideDuration((BRelTime)BRelTime.DEFAULT.decodeFromString(maxDurStr));
        }
        return def;
    }

    private FoxResponse getActionDefault(FoxRequest req) throws Exception {
        String pointId = req.getString("pid");
        String name = req.getString("name");
        OrdTarget t = BOrd.make((String)pointId).resolve((BObject)Sys.getStation());
        BComponent target = t.getComponent();
        if (target == null) {
            throw new UnresolvedException(pointId);
        }
        Action action = target.getAction(name);
        if (action == null) {
            throw new UnresolvedException("No action " + name);
        }
        BValue def = target.getActionParameterDefault(action);
        FoxResponse resp = new FoxResponse(req);
        if (def != null) {
            BOverride override;
            resp.add("default", this.encodeValueToString(def));
            if (def instanceof BOverride && !(override = (BOverride)def).getMaxOverrideDuration().equals((Object)BRelTime.DEFAULT)) {
                resp.add("maxOverrideDuration", override.getMaxOverrideDuration().encodeToString());
            }
        }
        if (this.isTraceOn()) {
            this.trace("s:getActionDefault");
            resp.dump();
        }
        return resp;
    }

    public BValue invoke(IProxyActionParent proxyActionParent, BVirtualAction action, BValue arg) throws Exception {
        return this.invoke(proxyActionParent.getPointId(), action.getProxyActionName(), arg);
    }

    public BValue invoke(String ord, String actionName, BValue arg) throws Exception {
        FoxRequest req = this.makeRequest("invoke");
        req.add("pid", ord);
        req.add("name", actionName);
        if (arg != null) {
            req.add("arg", this.encodeValueToString(arg));
        }
        if (this.isTraceOn()) {
            this.trace("c:invoke");
            req.dump();
        }
        FoxResponse resp = this.sendSync(req);
        BValue result = null;
        String resultStr = resp.getString("return", null);
        if (resultStr != null) {
            result = this.decodeValueFromString(resultStr, this.failLegacyTypeResolver);
        }
        return result;
    }

    private FoxResponse invoke(FoxRequest req) throws Exception {
        BValue result;
        String pointId = req.getString("pid");
        String name = req.getString("name");
        String argStr = req.getString("arg", null);
        OrdTarget t = BOrd.make((String)pointId).resolve((BObject)Sys.getStation());
        BComponent target = t.getComponent();
        if (target == null) {
            throw new UnresolvedException(pointId);
        }
        Action action = target.getAction(name);
        if (action == null) {
            throw new UnresolvedException("No action " + name);
        }
        BValue arg = null;
        if (argStr != null) {
            arg = this.decodeValueFromString(argStr, this.skipLegacyTypeResolver);
        }
        try {
            result = target.invoke(action, arg, this.getSessionContext());
        }
        catch (ActionInvokeException e) {
            throw (Exception)e.getCause();
        }
        FoxResponse resp = new FoxResponse(req);
        if (result != null) {
            resp.add("return", this.encodeValueToString(result));
        }
        if (this.isTraceOn()) {
            this.trace("s:invoke");
            resp.dump();
        }
        return resp;
    }

    String encodeValueToString(BValue value) throws Exception {
        Context cx = null;
        try {
            cx = this.getSessionContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ValueDocEncoder encoder = this.makeDefaultEncoder(out, cx);
        encoder.encode(value);
        encoder.close();
        return new String(out.toByteArray());
    }

    private BValue decodeValueFromString(String value, ValueDocDecoder.ITypeResolver typeResolver) throws Exception {
        Context cx = null;
        try {
            cx = this.getSessionContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ValueDocDecoder decoder = this.makeDefaultDecoder(new ByteArrayInputStream(value.getBytes()), cx);
        decoder.setTypeResolver(typeResolver);
        decoder.next();
        return decoder.decode();
    }

    public BVirtualAction[] getActions(IProxyActionParent proxyActionParent) throws Exception {
        FoxRequest req = this.makeRequest("getActions");
        req.add("pid", proxyActionParent.getPointId());
        req.add("virtual", true);
        if (this.isTraceOn()) {
            this.trace("c:getActions");
            req.dump();
        }
        FoxResponse resp = this.sendSync(req);
        return ServerEntry.messageToActions((FoxMessage)resp.get("actions"), this.log);
    }

    public FoxResponse getActions(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        BOrd ord = BOrd.make((String)req.getString("pid"));
        BComponent comp = (BComponent)ord.get((BObject)Sys.getStation());
        BPermissions permissions = this.getPermissionsFor(comp);
        if (!permissions.hasOperatorRead()) {
            throw new Exception("Invalid permissions to read Actions");
        }
        boolean virtual = req.getBoolean("virtual");
        resp.add((FoxTuple)ServerEntry.actionsToMessage(comp, permissions, this.log, virtual));
        return resp;
    }

    public void write(BOrd ord, String name, BValue val) throws Exception {
        FoxRequest req = this.makeRequest("write");
        req.add("pid", ord.toString());
        req.add("name", name);
        req.add("val", this.encodeValueToString(val));
        if (this.isTraceOn()) {
            this.trace("c:write");
            req.dump();
        }
        this.sendSync(req);
    }

    private FoxResponse write(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        BOrd ord = BOrd.make((String)req.getString("pid"));
        BComponent comp = (BComponent)ord.get((BObject)this);
        String name = req.getString("name");
        if (name == null) {
            throw new UnresolvedException("No Property name decoded");
        }
        Property p = comp.getProperty(name);
        if (p == null) {
            throw new UnresolvedException("Invalid Property name");
        }
        BValue val = this.decodeValueFromString(req.getString("val"), this.failLegacyTypeResolver);
        comp.set(p, val, this.getSessionContext());
        return resp;
    }

    public Map<String, BIDataValue> fetchRemoteTags(INiagaraProxyExt ext, String tagsToFetch) throws Exception {
        Version remoteVersion = new Version(this.getConnection().session().getRemoteHello().getString("app.version", ""));
        if (remoteVersion.compareTo(BNiagaraProxyExt.VER_4_2) < 0) {
            throw new UnsupportedOperationException("fetchRemoteTags requires Niagara 4.2 or later");
        }
        FoxRequest req = this.makeRequest("fetchRemoteTags");
        req.add("pid", ext.getComponentId());
        req.add("tagsToFetch", tagsToFetch);
        if (this.isTraceOn()) {
            this.trace("c:fetchRemoteTags");
            req.dump();
        }
        FoxResponse resp = this.sendSync(req);
        HashMap<String, BIDataValue> tagMap = new HashMap<String, BIDataValue>();
        ServerEntry.messageToTags((FoxMessage)resp.get("tags"), this.log, tagsToFetch, ext, tagMap);
        return tagMap;
    }

    private FoxResponse fetchRemoteTags(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        BOrd ord = BOrd.make((String)req.getString("pid"));
        BComponent comp = (BComponent)ord.get((BObject)Sys.getStation());
        BPermissions permissions = this.getPermissionsFor(comp);
        if (!permissions.hasOperatorRead()) {
            throw new Exception("Invalid permissions to read Tags");
        }
        String tagsToFetch = req.getString("tagsToFetch");
        resp.add((FoxTuple)ServerEntry.tagsToMessage(comp, permissions, this.log, tagsToFetch));
        return resp;
    }

    public BObject discover(BDeviceExt deviceExt, BOrd ord) throws Exception {
        FoxMessage req = new FoxMessage();
        req.add("deviceExt", deviceExt.getAbsoluteOrd().relativizeToSession().toString());
        req.add("ord", ord.toString());
        FoxCircuit circuit = this.openCircuit("discover");
        circuit.writeMessage(req);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException(resp);
        }
        boolean resolved = resp.getBoolean("resolved", false);
        if (!resolved) {
            throw new UnresolvedException(ord.toString());
        }
        String targetType = resp.getString("targetType");
        if (targetType.equals("table")) {
            BIDataTable result = DataTableDecoder.decode((DataInput)new DataInputStream(circuit.getInputStream()));
            circuit.close();
            return (BObject)result;
        }
        if (targetType.equals("value")) {
            String typeStr = resp.getString("valueType");
            Type valType = BTypeSpec.make((String)typeStr).getResolvedType();
            BObject decoder = valType.getInstance();
            BObject result = ((BIDataValue)decoder).decode((DataInput)new DataInputStream(circuit.getInputStream()));
            circuit.close();
            return result;
        }
        throw new UnresolvedException("Unsupported result type (" + targetType + ") for " + ord.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discover(FoxCircuit circuit) throws Exception {
        FoxMessage req = circuit.readMessage();
        String deviceExtText = req.getString("deviceExt", null);
        String ordText = req.getString("ord", null);
        if (deviceExtText == null || ordText == null) {
            circuit.writeMessage(BPointChannel.unresolved());
            circuit.flush();
            return;
        }
        BDeviceExt deviceExt = null;
        BNiagaraStation station = null;
        try {
            deviceExt = (BDeviceExt)BOrd.make((String)deviceExtText).get((BObject)BLocalHost.INSTANCE, this.getSessionContext());
            station = (BNiagaraStation)deviceExt.getDevice();
        }
        catch (Exception e) {
            circuit.writeMessage(BPointChannel.unresolved());
            circuit.flush();
            return;
        }
        if (!station.getPermissions(this.getSessionContext()).hasAdminWrite() || !deviceExt.getPermissions(this.getSessionContext()).hasAdminWrite()) {
            circuit.writeMessage(BPointChannel.unresolved());
            circuit.flush();
            return;
        }
        BFoxClientConnection connection = station.getClientConnection();
        if (connection == null) {
            circuit.writeMessage(BPointChannel.unresolved());
            circuit.flush();
            return;
        }
        BFoxClientConnection.StringInterest interest = new BFoxClientConnection.StringInterest("PointChannel - Discover at " + Clock.ticks());
        BObject o = null;
        try {
            connection.engageNoRetry((BFoxClientConnection.Interest)interest);
            if (deviceExt == station.getSchedules() && connection.session().isLegacyConnection()) {
                throw new IncompatibleVersionException("Niagara4 station cannot discover schedules on a NiagaraAX station");
            }
            o = ((BDataChannel)connection.getChannels().get("data", BDataChannel.TYPE)).resolve(BOrd.make((String)ordText));
        }
        catch (UnresolvedException e) {
            circuit.writeMessage(BPointChannel.unresolved());
            circuit.flush();
            return;
        }
        catch (Exception e) {
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
            circuit.flush();
            return;
        }
        finally {
            connection.disengage((BFoxClientConnection.Interest)interest);
        }
        FoxMessage resp = new FoxMessage();
        resp.add("resolved", true);
        BObject result = null;
        if (o instanceof BITable) {
            resp.add("targetType", "table");
            BITable table = (BITable)o;
            result = (BObject)BToDataTable.toDataTable((BITable)table);
        } else {
            resp.add("targetType", "value");
            result = (BObject)o.toDataValue();
            resp.add("valueType", result.getType().getTypeSpec().toString());
        }
        circuit.writeMessage(resp);
        circuit.flush();
        DataOutputStream out = new DataOutputStream(circuit.getOutputStream());
        if (result instanceof BIDataTable) {
            DataTableEncoder.encode((BIDataTable)((BIDataTable)result), (DataOutput)out, (Context)this.getSessionContext());
        } else {
            ((BIDataValue)result).encode((DataOutput)out);
        }
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BSlotInfo[] discoverPartialSlots(String stationName, BOrd[] ords) throws Exception {
        Version remoteVersion = new Version(this.getConnection().session().getRemoteHello().getString("app.version", ""));
        if (remoteVersion.compareTo(VER_4_9U1) < 0) {
            throw new UnsupportedOperationException("discoverPartialSlots requires Niagara 4.9u1 or later");
        }
        FoxMessage req = new FoxMessage();
        req.add("station", stationName);
        for (BOrd ord : ords) {
            req.add("o", ord.toString());
        }
        if (this.isTraceOn()) {
            this.trace("c:discoverPartialSlots");
            req.dump();
        }
        try (FoxCircuit circuit = this.openCircuit("discoverPartialSlots");){
            circuit.writeMessage(req);
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            if (!resp.getBoolean("resolved", false)) {
                throw new UnresolvedException();
            }
            int num = resp.getInt("size");
            BSlotInfo[] infos = new BSlotInfo[num];
            try (InputStream inputStream = circuit.getInputStream();
                 ValueDocDecoder decoder = new ValueDocDecoder(inputStream);){
                for (int i = 0; i < num; ++i) {
                    decoder.next();
                    infos[i] = (BSlotInfo)decoder.decode();
                }
            }
            BSlotInfo[] bSlotInfoArray = infos;
            return bSlotInfoArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverPartialSlots(FoxCircuit circuit) throws Exception {
        BNiagaraVirtualGateway.PartialSlotInfo[] infos;
        FoxMessage req = circuit.readMessage();
        String stationName = req.getString("station", null);
        String[] ordList = req.listStrings("o");
        if (stationName == null) {
            circuit.writeMessage(BPointChannel.unresolved());
            circuit.flush();
            return;
        }
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BNiagaraStation station = (BNiagaraStation)network.getStation(stationName);
        if (station == null || !station.getPermissions(this.getSessionContext()).hasAdminWrite() || !station.getPoints().getPermissions(this.getSessionContext()).hasAdminWrite()) {
            circuit.writeMessage(BPointChannel.unresolved());
            circuit.flush();
            return;
        }
        BFoxClientConnection connection = station.getClientConnection();
        if (connection == null) {
            circuit.writeMessage(BPointChannel.unresolved());
            circuit.flush();
            return;
        }
        BOrd[] ords = (BOrd[])Stream.of(ordList).map(ordStr -> BOrd.make((OrdQuery)NiagaraVirtualUtil.fromServerOrdToClientVirtual((BOrd)ROOT_SLOT_ORD, (BOrd)BOrd.make((String)ordStr)))).filter(ord -> !ord.isNull()).toArray(BOrd[]::new);
        if (ords.length == 0) {
            circuit.writeMessage(BPointChannel.unresolved());
            circuit.flush();
            return;
        }
        BFoxClientConnection.StringInterest interest = new BFoxClientConnection.StringInterest("PointChannel - DiscoverPartialSlots at " + Clock.ticks());
        try {
            connection.engageNoRetry((BFoxClientConnection.Interest)interest);
            Version subordinateStationVersion = new Version(connection.session().getRemoteHello().getString("app.version", ""));
            if (subordinateStationVersion.compareTo(VER_3_7) < 0) {
                throw new UnsupportedOperationException("discoverPartial requires Niagara 3.7 or later on remote station");
            }
            BNiagaraVirtualChannel virtualChannel = (BNiagaraVirtualChannel)connection.getChannels().get("niagaraVirtual", BNiagaraVirtualChannel.TYPE);
            infos = virtualChannel.discoverPartial(ROOT_SLOT_ORD, ords);
        }
        catch (Exception e) {
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
            circuit.flush();
            return;
        }
        finally {
            connection.disengage((BFoxClientConnection.Interest)interest);
        }
        FoxMessage resp = new FoxMessage();
        resp.add("resolved", true);
        resp.add("size", infos.length);
        circuit.writeMessage(resp);
        circuit.flush();
        try (OutputStream outputStream = circuit.getOutputStream();
             ValueDocEncoder enc = this.makeDefaultEncoder(outputStream, this.getSessionContext());){
            for (BNiagaraVirtualGateway.PartialSlotInfo info : infos) {
                enc.encode((BValue)info.getSlotInfo());
                enc.flush();
            }
        }
        circuit.flush();
    }

    public BSlotInfo[] discoverSlots(String stationName, BOrd ord) throws Exception {
        FoxMessage req = new FoxMessage();
        req.add("station", stationName);
        req.add("ord", ord.toString());
        FoxCircuit circuit = this.openCircuit("discoverSlots");
        circuit.writeMessage(req);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException(resp);
        }
        boolean resolved = resp.getBoolean("resolved", false);
        if (!resolved) {
            throw new UnresolvedException(ord.toString());
        }
        int num = resp.getInt("size");
        BSlotInfo[] infos = new BSlotInfo[num];
        ValueDocDecoder decoder = new ValueDocDecoder(circuit.getInputStream());
        for (int i = 0; i < num; ++i) {
            decoder.next();
            infos[i] = (BSlotInfo)decoder.decode();
        }
        circuit.close();
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverSlots(FoxCircuit circuit) throws Exception {
        BSlotInfo[] infos;
        BSlotInfo myInfo;
        String ordText;
        block15: {
            FoxMessage req = circuit.readMessage();
            String stationName = req.getString("station", null);
            ordText = req.getString("ord", null);
            if (stationName == null || ordText == null) {
                circuit.writeMessage(BPointChannel.unresolved());
                circuit.flush();
                return;
            }
            BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            BNiagaraStation station = (BNiagaraStation)network.getStation(stationName);
            if (!station.getPermissions(this.getSessionContext()).hasAdminWrite() || !station.getPoints().getPermissions(this.getSessionContext()).hasAdminWrite()) {
                circuit.writeMessage(BPointChannel.unresolved());
                circuit.flush();
                return;
            }
            BFoxClientConnection connection = station.getClientConnection();
            if (connection == null) {
                circuit.writeMessage(BPointChannel.unresolved());
                circuit.flush();
                return;
            }
            BFoxClientConnection.StringInterest interest = new BFoxClientConnection.StringInterest("PointChannel - DiscoverSlots at " + Clock.ticks());
            myInfo = null;
            infos = null;
            try {
                connection.engageNoRetry((BFoxClientConnection.Interest)interest);
                BOrd ord = BOrd.make((String)ordText).relativizeToSession();
                BOrd parentOrd = ord.getParent();
                BSlotInfo[] parentInfos = ((BNiagaraVirtualChannel)connection.getChannels().get("niagaraVirtual", BNiagaraVirtualChannel.TYPE)).discoverPoints(parentOrd);
                for (int i = 0; i < parentInfos.length; ++i) {
                    if (parentInfos[i].getSlotOrd().isNull()) {
                        parentInfos[i].setSlotOrd(BOrd.make((BOrd)parentOrd, (String)("slot:" + parentInfos[i].getSlotName())).normalize());
                    }
                    if (!parentInfos[i].getSlotOrd().relativizeToSession().equals((Object)ord)) continue;
                    myInfo = parentInfos[i];
                    break;
                }
                if (myInfo != null) {
                    infos = ((BNiagaraVirtualChannel)connection.getChannels().get("niagaraVirtual", BNiagaraVirtualChannel.TYPE)).discoverPoints(ord);
                    break block15;
                }
                throw new UnresolvedException();
            }
            catch (UnresolvedException e) {
                circuit.writeMessage(BPointChannel.unresolved());
                circuit.flush();
                return;
            }
            catch (Exception e) {
                circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
                circuit.flush();
                return;
            }
            finally {
                connection.disengage((BFoxClientConnection.Interest)interest);
            }
        }
        FoxMessage resp = new FoxMessage();
        resp.add("resolved", true);
        resp.add("size", infos.length + 1);
        circuit.writeMessage(resp);
        circuit.flush();
        ValueDocEncoder enc = this.makeDefaultEncoder(circuit.getOutputStream(), this.getSessionContext());
        enc.encode((BValue)myInfo);
        enc.flush();
        for (int i = 0; i < infos.length; ++i) {
            if (infos[i].getSlotOrd().isNull()) {
                infos[i].setSlotOrd(BOrd.make((String)(ordText + "|slot:" + infos[i].getSlotName())).normalize());
            }
            enc.encode((BValue)infos[i]);
            enc.flush();
        }
        enc.close();
        circuit.flush();
    }

    public BIFileStore[] discoverFiles(String stationName, FilePath path) throws Exception {
        FoxMessage req = new FoxMessage();
        req.add("station", stationName);
        req.add("path", path.getBody());
        FoxCircuit circuit = this.openCircuit("discoverFiles");
        circuit.writeMessage(req);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException(resp);
        }
        boolean resolved = resp.getBoolean("resolved", false);
        if (!resolved) {
            throw new UnresolvedException(path.toString());
        }
        int num = resp.getInt("size");
        BIFileStore[] infos = new BNiagaraDiscoveredFileInfo[num];
        ValueDocDecoder decoder = new ValueDocDecoder(circuit.getInputStream());
        for (int i = 0; i < num; ++i) {
            decoder.next();
            infos[i] = (BNiagaraDiscoveredFileInfo)decoder.decode();
        }
        circuit.close();
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverFiles(FoxCircuit circuit) throws Exception {
        FoxMessage req = circuit.readMessage();
        String stationName = req.getString("station", null);
        String pathText = req.getString("path", null);
        if (stationName == null || pathText == null) {
            circuit.writeMessage(BPointChannel.unresolved());
            circuit.flush();
            return;
        }
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BNiagaraStation station = (BNiagaraStation)network.getStation(stationName);
        if (!station.getPermissions(this.getSessionContext()).hasAdminWrite() || !station.getFiles().getPermissions(this.getSessionContext()).hasAdminWrite()) {
            circuit.writeMessage(BPointChannel.unresolved());
            circuit.flush();
            return;
        }
        BFoxClientConnection connection = station.getClientConnection();
        if (connection == null) {
            circuit.writeMessage(BPointChannel.unresolved());
            circuit.flush();
            return;
        }
        BFoxClientConnection.StringInterest interest = new BFoxClientConnection.StringInterest("PointChannel - DiscoverFiles at " + Clock.ticks());
        BNiagaraDiscoveredFileInfo[] infos = null;
        try {
            connection.engageNoRetry((BFoxClientConnection.Interest)interest);
            FoxRequest fileReq = new FoxRequest("file", "list");
            fileReq.add("path", pathText);
            BFileChannel fileChannel = (BFileChannel)connection.getChannels().get("file", BFileChannel.TYPE);
            FoxResponse resp = fileChannel.sendSync(fileReq);
            FoxTuple[] msgs = resp.list("file");
            infos = new BNiagaraDiscoveredFileInfo[msgs.length];
            FilePath path = new FilePath(pathText);
            for (int i = 0; i < infos.length; ++i) {
                FoxMessage msg = (FoxMessage)msgs[i];
                infos[i] = new BNiagaraDiscoveredFileInfo(path.merge(msg.getString("name")), msg.getBoolean("dir"), msg.getBoolean("readonly"), BAbsTime.make((long)msg.getTime("modified")), Long.parseLong(msg.getString("size")), BPermissions.make((String)msg.getString("permissions", "rw")));
            }
        }
        catch (UnresolvedException e) {
            circuit.writeMessage(BPointChannel.unresolved());
            circuit.flush();
            return;
        }
        catch (Exception e) {
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
            circuit.flush();
            return;
        }
        finally {
            connection.disengage((BFoxClientConnection.Interest)interest);
        }
        FoxMessage resp = new FoxMessage();
        resp.add("resolved", true);
        resp.add("size", infos.length);
        circuit.writeMessage(resp);
        circuit.flush();
        ValueDocEncoder enc = new ValueDocEncoder(circuit.getOutputStream());
        for (int i = 0; i < infos.length; ++i) {
            enc.encode((BValue)infos[i]);
            enc.flush();
        }
        enc.close();
        circuit.flush();
    }

    private static FoxMessage unresolved() {
        return BPointChannel.unresolved(null, null);
    }

    private static FoxMessage unresolved(String key, String msg) {
        FoxMessage m = new FoxMessage();
        m.add("resolved", false);
        if (msg != null) {
            m.add("msg", msg);
        }
        return m;
    }

    public static void addProxyTag(Entity entity, String tagId, BIDataValue value, int additionalFlags, BFacets additionalFacets) {
        try {
            if (tagId.equals("n:history") && !BNiagaraProxyExt.localHistoryExists(value.encodeToString())) {
                BComponent target;
                Property prop;
                if (entity instanceof BComponent && (prop = (target = (BComponent)entity).getProperty(BNiagaraProxyExt.ESCAPED_N_HISTORY_TAG)) != null && Flags.isReadonly((BComplex)target, (Slot)prop)) {
                    target.remove(prop);
                }
                return;
            }
        }
        catch (Exception target) {
            // empty catch block
        }
        if (entity instanceof BComponent) {
            BComponent target = (BComponent)entity;
            String propName = SlotPath.escape((String)tagId);
            Property prop = target.getProperty(propName);
            if (!(prop == null || Flags.isReadonly((BComplex)target, (Slot)prop) && Flags.isMetadata((BComplex)target, (Slot)prop))) {
                return;
            }
            if (prop != null) {
                target.set(prop, (BValue)value);
            } else {
                int flags = additionalFlags | 1 | 0x4000 | 0x10000;
                BFacets facets = additionalFacets != null ? additionalFacets : BFacets.NULL;
                target.add(propName, (BValue)value, flags, facets, null);
            }
        } else {
            Id id;
            Tags tags = entity.tags();
            if (!tags.contains(id = Id.newId((String)tagId))) {
                tags.set(id, value);
            }
        }
    }
}

