/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.history;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.IncompatibleVersionException;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.history.BNiagaraHistoryDeviceExt;
import com.tridium.nd.history.BNiagaraHistoryImport;
import java.util.Optional;
import javax.baja.driver.util.BDescriptor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.HistoryException;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BArchiveChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType(BArchiveChannel.class);

    public Type getType() {
        return TYPE;
    }

    public BArchiveChannel() {
        super("archive");
    }

    public void checkProcess(FoxRequest req) throws Throwable {
    }

    public void checkProcessCircuit(FoxCircuit circuit) throws Throwable {
    }

    public void checkSendRequest(FoxRequest req) throws Exception {
        if (this.getConnection().session().isLegacyConnection()) {
            throw new IncompatibleVersionException("Niagara4 station cannot export history to a NiagaraAX station");
        }
        super.checkSendRequest(req);
    }

    public void checkOpenCircuit(String command, FoxMessage metadata) throws Exception {
        if (this.getConnection().session().isLegacyConnection()) {
            throw new IncompatibleVersionException("Niagara4 station cannot export history to a NiagaraAX station");
        }
        super.checkOpenCircuit(command, metadata);
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (command == "createHistory") {
            return this.createHistory(request);
        }
        if (command == "updateConfig") {
            return this.updateConfig(request);
        }
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        throw new InvalidCommandException(command);
    }

    public void createHistory(BHistoryConfig config) throws Exception {
        FoxRequest req = this.makeRequest("createHistory");
        req.add("xml", ValueDocEncoder.marshal((BValue)config));
        FoxResponse resp = this.sendSync(req);
        if (!resp.getBoolean("success", false)) {
            if (resp.getBoolean("importAlreadyExists", false)) {
                throw new HistoryException("Active import already exists for history: " + config.getId());
            }
            throw new HistoryException("Cannot create history: " + config.getId());
        }
    }

    public FoxResponse createHistory(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        String xml = req.getString("xml", null);
        BHistoryConfig config = (BHistoryConfig)ValueDocDecoder.unmarshal((String)xml);
        config = network.getHistoryPolicies().makeConfig(config);
        FoxResponse resp = new FoxResponse(req);
        if (!this.getPermissionsFor(db).hasAdminWrite()) {
            resp.add("success", false);
        } else if (this.activeHistoryImportExists(config.getId())) {
            resp.add("success", false);
            resp.add("importAlreadyExists", true);
        } else {
            config = this.updateSource(network, config);
            try (HistorySpaceConnection conn = db.getConnection(null);){
                conn.createHistory(config);
                resp.add("success", conn.exists(config.getId()));
            }
            catch (Exception e) {
                e.printStackTrace();
                resp.add("success", false);
            }
        }
        return resp;
    }

    public void updateConfig(BHistoryConfig config) throws Exception {
        FoxRequest req = this.makeRequest("updateConfig");
        req.add("xml", ValueDocEncoder.marshal((BValue)config));
        FoxResponse resp = this.sendSync(req);
        if (!resp.getBoolean("success", false)) {
            if (resp.getBoolean("importAlreadyExists", false)) {
                throw new HistoryException("Active import already exists for history: " + config.getId());
            }
            throw new HistoryException("Cannot reconfigure history: " + config.getId());
        }
    }

    public FoxResponse updateConfig(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        String xml = req.getString("xml", null);
        BHistoryConfig config = (BHistoryConfig)ValueDocDecoder.unmarshal((String)xml);
        config = network.getHistoryPolicies().makeConfig(config);
        FoxResponse resp = new FoxResponse(req);
        if (!BLocalHistoryDatabase.getPermissionsForId((BHistoryDatabase)db, (BHistoryId)config.getId(), (Context)this.getSessionContext()).hasAdminWrite()) {
            resp.add("success", false);
        } else if (this.activeHistoryImportExists(config.getId())) {
            resp.add("success", false);
            resp.add("importAlreadyExists", true);
        } else {
            config = this.updateSource(network, config);
            try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                conn.reconfigureHistory(config);
                resp.add("success", conn.exists(config.getId()));
            }
            catch (Exception e) {
                e.printStackTrace();
                resp.add("success", false);
            }
        }
        return resp;
    }

    private BHistoryConfig updateSource(BNiagaraNetwork network, BHistoryConfig config) {
        try {
            BNiagaraStation station = null;
            for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BNiagaraStation)) continue;
                station = (BNiagaraStation)parent;
                break;
            }
            if (station != null) {
                BOrd ord = this.getSourceOrd(station);
                BOrdList src = config.getSource();
                if (src.size() < 1) {
                    config.setSource(BOrdList.make((BOrd)ord));
                } else if (!src.get(src.size() - 1).equals((Object)ord)) {
                    BOrdList newSrc = BOrdList.add((BOrdList)src, (BOrd)ord);
                    config.setSource(newSrc);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return config;
    }

    private BOrd getSourceOrd(BNiagaraStation station) {
        BComponentSpace cs = station.getComponentSpace();
        if (cs == null) {
            return station.getSlotPathOrd();
        }
        BOrd base = cs.getOrdInSession();
        if (base == null) {
            return station.getSlotPathOrd();
        }
        return BOrd.make((BOrd)base, (BOrd)station.getSlotPathOrd());
    }

    private boolean activeHistoryImportExists(BHistoryId id) {
        if (id == null || this.getConnection() == null) {
            return false;
        }
        Optional parent = this.getConnection().getConnectionTarget(NiagaraStation.class);
        if (!parent.isPresent() || !(parent.get() instanceof BNiagaraStation)) {
            return false;
        }
        String stationName = ((NiagaraStation)parent.get()).getStationName();
        BNiagaraHistoryDeviceExt histories = ((BNiagaraStation)parent.get()).getHistories();
        if (histories == null) {
            return false;
        }
        BDescriptor[] descriptors = histories.getDescriptors();
        if (descriptors == null) {
            return false;
        }
        for (int j = 0; j < descriptors.length; ++j) {
            if (!(descriptors[j] instanceof BNiagaraHistoryImport) || !descriptors[j].getEnabled() || descriptors[j].isDisabled() || !((BNiagaraHistoryImport)descriptors[j]).getHistoryId().fromShorthand(stationName).equals((Object)id)) continue;
            return true;
        }
        return false;
    }
}

