/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.alarm;

import com.tridium.alarm.BIUpdatableAlarmSource;
import com.tridium.alarm.BStationRecipient;
import com.tridium.alarm.BTextCustomizer;
import com.tridium.alarm.BTextOp;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.alarm.AlarmWorker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.alarm.BAlarmClassFolder;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;
import javax.baja.util.Queue;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alarmClass", type="String", defaultValue="defaultAlarmClass", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"alarm:DeviceExtAlarmClassFE\")")}, override=true), @NiagaraProperty(name="sourceName", type="BTextCustomizer", defaultValue="new BTextCustomizer(BTextOp.prepend, BFormat.make(\"%parent.parent.displayName%:\"))"), @NiagaraProperty(name="workerState", type="String", defaultValue="", flags=3), @NiagaraProperty(name="lastSendTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=9, facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="BBoolean.TRUE")}), @NiagaraProperty(name="lastSendFailureTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=9, facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="BBoolean.TRUE")}), @NiagaraProperty(name="lastSendFailureCause", type="String", defaultValue="", flags=1)})
@NiagaraAction(name="updateAlarm", parameterType="alarm:AlarmRecord", defaultValue="new BAlarmRecord()", flags=4)
public class BNiagaraAlarmDeviceExt
extends BAlarmDeviceExt
implements BINiagaraDeviceExt,
BFoxClientConnection.Interest,
BIUpdatableAlarmSource {
    public static final Property alarmClass = BNiagaraAlarmDeviceExt.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:DeviceExtAlarmClassFE")));
    public static final Property sourceName = BNiagaraAlarmDeviceExt.newProperty((int)0, (BValue)new BTextCustomizer(BTextOp.prepend, BFormat.make((String)"%parent.parent.displayName%:")), null);
    public static final Property workerState = BNiagaraAlarmDeviceExt.newProperty((int)3, (String)"", null);
    public static final Property lastSendTime = BNiagaraAlarmDeviceExt.newProperty((int)9, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property lastSendFailureTime = BNiagaraAlarmDeviceExt.newProperty((int)9, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property lastSendFailureCause = BNiagaraAlarmDeviceExt.newProperty((int)1, (String)"", null);
    public static final Action updateAlarm = BNiagaraAlarmDeviceExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BNiagaraAlarmDeviceExt.class);
    public static final Logger logger = Logger.getLogger("niagara.alarms");
    private final Queue workQueue = new CoalesceQueue();
    AlarmWorker worker;
    private BStatus oldStatus = BStatus.stale;

    public BTextCustomizer getSourceName() {
        return (BTextCustomizer)this.get(sourceName);
    }

    public void setSourceName(BTextCustomizer v) {
        this.set(sourceName, (BValue)v, null);
    }

    public String getWorkerState() {
        return this.getString(workerState);
    }

    public void setWorkerState(String v) {
        this.setString(workerState, v, null);
    }

    public BAbsTime getLastSendTime() {
        return (BAbsTime)this.get(lastSendTime);
    }

    public void setLastSendTime(BAbsTime v) {
        this.set(lastSendTime, (BValue)v, null);
    }

    public BAbsTime getLastSendFailureTime() {
        return (BAbsTime)this.get(lastSendFailureTime);
    }

    public void setLastSendFailureTime(BAbsTime v) {
        this.set(lastSendFailureTime, (BValue)v, null);
    }

    public String getLastSendFailureCause() {
        return this.getString(lastSendFailureCause);
    }

    public void setLastSendFailureCause(String v) {
        this.setString(lastSendFailureCause, v, null);
    }

    public void updateAlarm(BAlarmRecord parameter) {
        this.invoke(updateAlarm, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void updateStatus() {
        BDevice device = this.getDevice();
        BStatus status = device.getStatus();
        if ((this.oldStatus.isStale() || this.oldStatus.isDisabled()) && !status.isDisabled()) {
            this.initWorker(false);
        } else if (!this.oldStatus.isDisabled() && status.isDisabled()) {
            if (this.worker != null) {
                this.worker.kill("disabled");
            }
        } else if ((this.oldStatus.isStale() || this.oldStatus.isFault()) && !status.isFault()) {
            this.initWorker(false);
        } else if (!this.oldStatus.isFault() && status.isFault()) {
            if (this.worker != null) {
                this.worker.kill("fault");
            }
        } else if ((this.oldStatus.isStale() || this.oldStatus.isDown()) && !status.isDown()) {
            this.initWorker(true);
        } else if (this.oldStatus.isDown() || status.isDown()) {
            // empty if block
        }
        this.oldStatus = status;
    }

    public void started() throws Exception {
        if (Sys.isStationStarted()) {
            this.updateStatus();
        }
    }

    public void stationStarted() throws Exception {
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWorker(boolean enqueueMissedAlarms) {
        Queue queue = this.workQueue;
        synchronized (queue) {
            this.workQueue.clear();
            if (enqueueMissedAlarms) {
                this.workQueue.enqueue((Object)new InitNewAlarms(this.getLastSendTime()));
                this.workQueue.enqueue((Object)new InitAlarmUpdates(this.getLastSendTime()));
                this.workQueue.enqueue((Object)new InitAckPending());
            }
        }
        if (this.worker == null) {
            this.worker = new AlarmWorker(this, this.workQueue);
        }
        if (!this.worker.isRunning()) {
            this.worker.start();
        }
    }

    public void stopped() {
        if (this.worker != null) {
            this.worker.kill("ext stopped");
            this.worker = null;
        }
    }

    public void doUpdateAlarm(BAlarmRecord alarm) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BNiagaraAlarms.doUpdateAlarm: " + alarm.getTimestamp() + " " + alarm.getAlarmClass() + " " + alarm.getSource());
        }
        if (!this.oldStatus.isDisabled() && !this.oldStatus.isFault()) {
            if (this.oldStatus.isDown() || !((BNiagaraStation)this.getDevice()).getClientConnection().isConnected()) {
                this.initWorker(true);
            }
            this.workQueue.enqueue((Object)this.makeAlarmRecordQueueItem(alarm));
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord alarm) throws Exception {
        BAlarmRecord ackRequest = (BAlarmRecord)alarm.newCopy();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BNiagaraAlarms.doAckAlarm: " + ackRequest.getTimestamp() + " " + ackRequest.getAlarmClass() + " " + ackRequest.getSource());
        }
        BOrdList src = ackRequest.getSource();
        BOrdList newSrc = BOrdList.remove((BOrdList)src, (int)(src.size() - 1));
        ackRequest.setSource(newSrc);
        BObject hyperlink = ackRequest.getAlarmData().get("hyperlinkOrd");
        if (hyperlink != null) {
            BNiagaraStation station = (BNiagaraStation)this.getParent();
            String toRemove = AlarmWorker.makeStationSessionOrdSegment(station);
            if (hyperlink.toString().startsWith(toRemove)) {
                String newHyperlink = hyperlink.toString().substring(toRemove.length());
                ackRequest.setAlarmData(BFacets.make((BFacets)ackRequest.getAlarmData(), (String)"hyperlinkOrd", (BIDataValue)BString.make((String)newHyperlink)));
            }
        }
        if (!this.oldStatus.isDisabled() && !this.oldStatus.isFault()) {
            if (this.oldStatus.isDown() || !((BNiagaraStation)this.getDevice()).getClientConnection().isConnected()) {
                this.initWorker(true);
            }
            this.workQueue.enqueue((Object)this.makeAlarmRecordQueueItem(ackRequest));
        }
        return BBoolean.make((boolean)true);
    }

    public void doRouteAlarm(BAlarmRecord record) throws Exception {
        if (!this.oldStatus.isDisabled() && !this.oldStatus.isFault()) {
            if (this.oldStatus.isDown() || !((BNiagaraStation)this.getDevice()).getClientConnection().isConnected()) {
                this.initWorker(true);
            }
            this.workQueue.enqueue((Object)this.makeAlarmRecordQueueItem(record));
        }
    }

    public BStationRecipient[] getRegisteredStationRecipients() {
        try {
            Array recipients = new Array(BStationRecipient.class);
            this.doGetRegisteredRecipients(Sys.getService((Type)BAlarmService.TYPE), (Array<BStationRecipient>)recipients);
            return (BStationRecipient[])recipients.trim();
        }
        catch (Exception e) {
            return new BStationRecipient[0];
        }
    }

    private void doGetRegisteredRecipients(BComponent obj, Array<BStationRecipient> recipients) {
        BComponent[] children = obj.getChildComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof BAlarmClassFolder) {
                this.doGetRegisteredRecipients(children[i], recipients);
                continue;
            }
            if (!(children[i] instanceof BStationRecipient) || this.getDevice() == null || !((BStationRecipient)children[i]).getRemoteStation().equals(this.getDevice().getName())) continue;
            recipients.add((Object)((BStationRecipient)children[i]));
        }
    }

    @Override
    public void clientOpened() {
    }

    @Override
    public void clientClosed() {
    }

    @Override
    public void serverOpened() {
    }

    @Override
    public void serverClosed() {
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("NiagaraAlarmDeviceExt");
        out.prop((Object)"deviceStatus", (Object)("" + this.oldStatus));
        out.prop((Object)"queueSize", (Object)("" + this.workQueue.size()));
        int qSize = this.workQueue.size() > 3 ? 3 : this.workQueue.size();
        Object[] qArray = this.workQueue.toArray();
        for (int i = 0; i < qSize; ++i) {
            out.prop((Object)("queueElem" + i), (Object)("" + qArray[i].getClass()));
        }
        if (this.worker == null) {
            out.prop((Object)"worker", (Object)"null");
        } else {
            out.prop((Object)"worker", (Object)this.getWorkerState());
        }
        out.endProps();
        super.spy(out);
    }

    private AlarmRecordQueueItem makeAlarmRecordQueueItem(BAlarmRecord record) {
        Optional service = Sys.findService((Type)BAlarmService.TYPE);
        if (service.isPresent() && ((BAlarmService)service.get()).getCoalesceAlarms()) {
            return new CoalesceableAlarmRecordQueueItem(record);
        }
        return new AlarmRecordQueueItem(record);
    }

    class InitAlarmUpdates
    implements InitJob {
        BAbsTime startTime;

        public InitAlarmUpdates(BAbsTime startTime) {
            this.startTime = startTime;
        }

        @Override
        public void execute() {
            String str = "alarm:|bql:select * where lastUpdate > AbsTime '" + this.startTime.encodeToString() + "'";
            str = str + " AND source LIKE '%" + BNiagaraAlarmDeviceExt.this.getSlotPath() + "' AND alarmData LIKE '%notes=%' AND ackState != alarm:AckState.ackPending";
            BOrd ord = BOrd.make((String)str);
            BITable result = (BITable)ord.resolve().get();
            int c = 0;
            try (TableCursor cur = result.cursor();){
                while (cur.next()) {
                    BAlarmRecord alarm = (BAlarmRecord)cur.get();
                    BNiagaraAlarmDeviceExt.this.workQueue.enqueue((Object)BNiagaraAlarmDeviceExt.this.makeAlarmRecordQueueItem(alarm));
                    ++c;
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("enqueued " + c + " alarms");
            }
        }
    }

    class InitNewAlarms
    implements InitJob {
        BAbsTime startTime;

        public InitNewAlarms(BAbsTime startTime) {
            this.startTime = startTime;
        }

        @Override
        public void execute() {
            String str = "alarm:|bql:select * where lastUpdate > AbsTime '" + this.startTime.encodeToString() + "'";
            BStationRecipient[] recips = BNiagaraAlarmDeviceExt.this.getRegisteredStationRecipients();
            if (recips.length <= 0) {
                return;
            }
            BOrd ord = BOrd.make((String)str);
            BITable result = (BITable)ord.resolve().get();
            ArrayList<Array> alarmClasses = new ArrayList<Array>();
            Set allAlarmClassNames = Arrays.stream(((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).getAlarmClasses()).map(BComplex::getName).collect(Collectors.toSet());
            int c = 0;
            try (TableCursor cur = result.cursor();){
                while (cur.next()) {
                    BAlarmRecord alarm = (BAlarmRecord)cur.get();
                    String esc = alarm.getAlarmData().gets("escalated", null);
                    int escalationLevel = 0;
                    if (esc != null) {
                        if (esc.equals("level1")) {
                            escalationLevel = 1;
                        } else if (esc.equals("level2")) {
                            escalationLevel = 2;
                        } else if (esc.equals("level3")) {
                            escalationLevel = 3;
                        }
                    }
                    for (int i = 0; i < recips.length; ++i) {
                        alarmClasses.clear();
                        alarmClasses.add(new Array((Object[])recips[i].getSubscribedAlarmClasses()));
                        alarmClasses.add(new Array((Object[])recips[i].getSubscribedEscalatedAlarmClasses(1)));
                        alarmClasses.add(new Array((Object[])recips[i].getSubscribedEscalatedAlarmClasses(2)));
                        alarmClasses.add(new Array((Object[])recips[i].getSubscribedEscalatedAlarmClasses(3)));
                        for (int a = 0; a <= escalationLevel; ++a) {
                            if ((!((Array)alarmClasses.get(a)).contains((Object)alarm.getAlarmClass()) || !recips[i].accept(alarm)) && (allAlarmClassNames.contains(alarm.getAlarmClass()) || !((Array)alarmClasses.get(a)).contains((Object)"defaultAlarmClass"))) continue;
                            BNiagaraAlarmDeviceExt.this.workQueue.enqueue((Object)BNiagaraAlarmDeviceExt.this.makeAlarmRecordQueueItem(alarm));
                            ++c;
                        }
                    }
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("enqueued " + c + " alarms");
            }
        }
    }

    class InitAckPending
    implements InitJob {
        InitAckPending() {
        }

        @Override
        public void execute() {
            String str = "alarm:|bql:select * from ackPendingAlarms";
            BOrd ord = BOrd.make((String)str);
            BITable result = (BITable)ord.resolve().get();
            int c = 0;
            try (TableCursor cur = result.cursor();){
                while (cur.next()) {
                    BAlarmRecord alarm = (BAlarmRecord)cur.get();
                    BOrdList src = alarm.getSource();
                    if (src.size() == 0 || !src.get(src.size() - 1).toString().equals(BNiagaraAlarmDeviceExt.this.getSlotPath().toString())) continue;
                    BAlarmRecord ackRequest = (BAlarmRecord)alarm.newCopy();
                    BOrdList newSrc = BOrdList.remove((BOrdList)src, (int)(src.size() - 1));
                    ackRequest.setSource(newSrc);
                    BObject hyperlink = ackRequest.getAlarmData().get("hyperlinkOrd");
                    if (hyperlink != null) {
                        BNiagaraStation station = (BNiagaraStation)BNiagaraAlarmDeviceExt.this.getParent();
                        String toRemove = AlarmWorker.makeStationSessionOrdSegment(station);
                        if (hyperlink.toString().startsWith(toRemove)) {
                            String newHyperlink = hyperlink.toString().substring(toRemove.length());
                            ackRequest.setAlarmData(BFacets.make((BFacets)ackRequest.getAlarmData(), (String)"hyperlinkOrd", (BIDataValue)BString.make((String)newHyperlink)));
                        }
                    }
                    BNiagaraAlarmDeviceExt.this.workQueue.enqueue((Object)BNiagaraAlarmDeviceExt.this.makeAlarmRecordQueueItem(ackRequest));
                    ++c;
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("enqueued " + c + " alarm acks");
            }
        }
    }

    static interface InitJob {
        public void execute();
    }

    static class CoalesceableAlarmRecordQueueItem
    extends AlarmRecordQueueItem
    implements ICoalesceable {
        CoalesceableAlarmRecordQueueItem(BAlarmRecord record) {
            super(record);
        }

        @Override
        public ICoalesceable coalesce(ICoalesceable obj) {
            if (obj instanceof AlarmRecordQueueItem && ((AlarmRecordQueueItem)obj).record.getLastUpdate().isBefore(this.record.getLastUpdate())) {
                return this;
            }
            return obj;
        }

        @Override
        public Object getCoalesceKey() {
            return this.record.getUuid();
        }
    }

    static class AlarmRecordQueueItem
    implements ICoalesceable {
        BAlarmRecord record;

        AlarmRecordQueueItem(BAlarmRecord record) {
            this.record = (BAlarmRecord)record.newCopy();
        }

        public ICoalesceable coalesce(ICoalesceable obj) {
            if (obj instanceof AlarmRecordQueueItem && ((AlarmRecordQueueItem)obj).record.getLastUpdate().isBefore(this.record.getLastUpdate())) {
                return this;
            }
            return obj;
        }

        public Object getCoalesceKey() {
            return this.record.getUuid().toString() + this.record.getSourceState().toString();
        }
    }
}

