/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.NiagaraNetwork;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.history.fox.BHistoryChannel;
import com.tridium.nd.BCyclicThreadPoolWorker;
import com.tridium.nd.BNiagaraEdgeLiteStation;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.BNiagaraStationFolder;
import com.tridium.nd.BStationDiscoveryJob;
import com.tridium.nd.alarm.BAlarmChannel;
import com.tridium.nd.history.BArchiveChannel;
import com.tridium.nd.point.BForceUpdateNiagaraPointsJob;
import com.tridium.nd.point.BINiagaraPointContainer;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.nd.point.BNiagaraTuningPolicyMap;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.schedule.BScheduleChannel;
import com.tridium.nd.spy.SpyIndex;
import com.tridium.nd.sysdef.BBogProvider;
import com.tridium.nd.sysdef.BLocalSysDefStation;
import com.tridium.nd.sysdef.BSysDefChannel;
import com.tridium.nd.sysdef.BSysDefProvider;
import com.tridium.nd.user.BUserSyncChannel;
import com.tridium.nd.virtual.BNiagaraVirtualChannel;
import com.tridium.nd.virtual.BNiagaraVirtualNetworkExt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.history.BHistoryNetworkExt;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nd.BINiagaraNetwork;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nd.SysDefSession;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.spy.Spy;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="localStation", type="BLocalSysDefStation", defaultValue="new BLocalSysDefStation()"), @NiagaraProperty(name="sysDefProvider", type="BSysDefProvider", defaultValue="new BBogProvider()"), @NiagaraProperty(name="tuningPolicies", type="BNiagaraTuningPolicyMap", defaultValue="new BNiagaraTuningPolicyMap()"), @NiagaraProperty(name="historyPolicies", type="BHistoryNetworkExt", defaultValue="new BHistoryNetworkExt()"), @NiagaraProperty(name="workers", type="BCyclicThreadPoolWorker", defaultValue="new BCyclicThreadPoolWorker(\"NiagaraNetwork:SharedWorkers\", Integer.MAX_VALUE)"), @NiagaraProperty(name="virtualPolicies", type="BNiagaraVirtualNetworkExt", defaultValue="new BNiagaraVirtualNetworkExt()"), @NiagaraProperty(name="persistFetchedTags", type="boolean", defaultValue="false")})
@NiagaraActions(value={@NiagaraAction(name="resetAllConnections", flags=144), @NiagaraAction(name="submitStationDiscoveryJob", returnType="BOrd"), @NiagaraAction(name="rebuildStationMap", flags=20), @NiagaraAction(name="forceUpdateNiagaraProxyPoints", flags=128, returnType="BOrd")})
public final class BNiagaraNetwork
extends BDeviceNetwork
implements BIService,
NiagaraNetwork,
BINiagaraNetwork,
BFoxService.FoxServerConnectionListener,
BINiagaraPointContainer {
    public static final Property localStation = BNiagaraNetwork.newProperty((int)0, (BValue)new BLocalSysDefStation(), null);
    public static final Property sysDefProvider = BNiagaraNetwork.newProperty((int)0, (BValue)new BBogProvider(), null);
    public static final Property tuningPolicies = BNiagaraNetwork.newProperty((int)0, (BValue)new BNiagaraTuningPolicyMap(), null);
    public static final Property historyPolicies = BNiagaraNetwork.newProperty((int)0, (BValue)new BHistoryNetworkExt(), null);
    public static final Property workers = BNiagaraNetwork.newProperty((int)0, (BValue)new BCyclicThreadPoolWorker("NiagaraNetwork:SharedWorkers", Integer.MAX_VALUE), null);
    public static final Property virtualPolicies = BNiagaraNetwork.newProperty((int)0, (BValue)new BNiagaraVirtualNetworkExt(), null);
    public static final Property persistFetchedTags = BNiagaraNetwork.newProperty((int)0, (boolean)false, null);
    public static final Action resetAllConnections = BNiagaraNetwork.newAction((int)144, null);
    public static final Action submitStationDiscoveryJob = BNiagaraNetwork.newAction((int)0, null);
    public static final Action rebuildStationMap = BNiagaraNetwork.newAction((int)20, null);
    public static final Action forceUpdateNiagaraProxyPoints = BNiagaraNetwork.newAction((int)128, null);
    public static final Type TYPE = Sys.loadType(BNiagaraNetwork.class);
    private static Type[] serviceTypes = new Type[]{TYPE, BINiagaraNetwork.TYPE};
    public static final Logger LOG;
    private volatile Map<String, NiagaraStation> stations = null;
    private static final Lexicon LEX;

    public BLocalSysDefStation getLocalStation() {
        return (BLocalSysDefStation)this.get(localStation);
    }

    public void setLocalStation(BLocalSysDefStation v) {
        this.set(localStation, (BValue)v, null);
    }

    public BSysDefProvider getSysDefProvider() {
        return (BSysDefProvider)this.get(sysDefProvider);
    }

    public void setSysDefProvider(BSysDefProvider v) {
        this.set(sysDefProvider, (BValue)v, null);
    }

    public BNiagaraTuningPolicyMap getTuningPolicies() {
        return (BNiagaraTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BNiagaraTuningPolicyMap v) {
        this.set(tuningPolicies, (BValue)v, null);
    }

    public BHistoryNetworkExt getHistoryPolicies() {
        return (BHistoryNetworkExt)this.get(historyPolicies);
    }

    public void setHistoryPolicies(BHistoryNetworkExt v) {
        this.set(historyPolicies, (BValue)v, null);
    }

    public BCyclicThreadPoolWorker getWorkers() {
        return (BCyclicThreadPoolWorker)this.get(workers);
    }

    public void setWorkers(BCyclicThreadPoolWorker v) {
        this.set(workers, (BValue)v, null);
    }

    public BNiagaraVirtualNetworkExt getVirtualPolicies() {
        return (BNiagaraVirtualNetworkExt)this.get(virtualPolicies);
    }

    public void setVirtualPolicies(BNiagaraVirtualNetworkExt v) {
        this.set(virtualPolicies, (BValue)v, null);
    }

    public boolean getPersistFetchedTags() {
        return this.getBoolean(persistFetchedTags);
    }

    public void setPersistFetchedTags(boolean v) {
        this.setBoolean(persistFetchedTags, v, null);
    }

    public void resetAllConnections() {
        this.invoke(resetAllConnections, null, null);
    }

    public BOrd submitStationDiscoveryJob() {
        return (BOrd)this.invoke(submitStationDiscoveryJob, null, null);
    }

    public void rebuildStationMap() {
        this.invoke(rebuildStationMap, null, null);
    }

    public BOrd forceUpdateNiagaraProxyPoints() {
        return (BOrd)this.invoke(forceUpdateNiagaraProxyPoints, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BNiagaraStation.TYPE;
    }

    public Type getDeviceFolderType() {
        return BNiagaraStationFolder.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "niagaraDriver");
    }

    public final NiagaraStation getStation(String name) {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        if (this.stations == null) {
            this.doRebuildStationMap();
        }
        return this.stations.get(name);
    }

    @Override
    public final BINiagaraStation getNiagaraStation(String name) {
        if (!this.isRunning() || this.stations == null) {
            throw new NotRunningException();
        }
        return (BINiagaraStation)this.stations.get(name);
    }

    @Override
    public final SysDefSession createSysDefSession(Context context) {
        this.loadSlots();
        return this.getSysDefProvider().createSession(context);
    }

    public void scheduleSync(BStationRole role) {
        for (BDevice station1 : this.getDevices()) {
            BNiagaraStation station = (BNiagaraStation)station1;
            if (!station.getSysDef().getRole().equals((Object)role)) continue;
            station.getSysDef().getSyncTask().schedule();
        }
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() throws Exception {
        Spy.ROOT.add("niagaraNetwork", (Spy)new SpyIndex(this));
        this.updateLocalStation();
        BFoxService foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
        foxService.registerServerConnectionListener((BFoxService.FoxServerConnectionListener)this);
    }

    private void updateLocalStation() {
        BLocalSysDefStation localStation = this.getLocalStation();
        boolean anyChanged = false;
        String actualStationName = Sys.getStation().getStationName();
        if (!localStation.getStationName().equals(actualStationName)) {
            localStation.setStationName(actualStationName);
            localStation.resetVersions();
            anyChanged = true;
        }
        String address = Sys.getLocalHost(null).getHostAddress();
        if (!localStation.getAddress().equals(address)) {
            localStation.setAddress(address);
            anyChanged = true;
        }
        if (anyChanged) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Niagara Network detected changes to the local station while it was offline.");
            }
            localStation.updateStationVersion();
        }
    }

    public void serviceStopped() throws Exception {
        BFoxService foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
        foxService.unregisterServerConnectionListener((BFoxService.FoxServerConnectionListener)this);
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.rebuildStationMap();
        this.getWorkers().register(this, -1L);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.getWorkers().unregister(this);
    }

    public void doResetAllConnections() {
        if (this.stations == null) {
            return;
        }
        for (String aKeySet : this.stations.keySet()) {
            try {
                String name = aKeySet;
                BNiagaraStation station = (BNiagaraStation)this.getNiagaraStation(name);
                station.getClientConnection().manualDisconnect();
                if (station.getServerConnection() == null) continue;
                station.getServerConnection().forceDisconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public BOrd doSubmitStationDiscoveryJob(Context cx) {
        return new BStationDiscoveryJob(this).submit(cx);
    }

    public void doRebuildStationMap() {
        if (!this.isRunning()) {
            return;
        }
        String myStationName = Sys.getStation().getStationName();
        HashMap<String, NiagaraStation> map = new HashMap<String, NiagaraStation>();
        for (BDevice device : this.getDevices()) {
            BNiagaraStation station = (BNiagaraStation)device;
            String name = station.getName();
            if (name.equals(myStationName)) {
                station.configFail("Station name is same as this station");
                continue;
            }
            if (map.get(name) != null) {
                station.configFail("Duplicate station name under NiagaraNework");
                continue;
            }
            map.put(name, station);
            station.configOk();
        }
        this.stations = map;
        BStationRole[] roles = new BStationRole[]{BStationRole.subordinate, BStationRole.supervisor};
        boolean needPurge = false;
        for (BStationRole role : roles) {
            for (String name : this.getLocalStation().getStationRefs(role)) {
                if (this.getStation(name) != null) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Removing deleted station: " + name + " from " + (Object)((Object)role));
                }
                this.getLocalStation().removeRef(name, role);
                needPurge = true;
            }
        }
        if (needPurge) {
            this.getSysDefProvider().purge();
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(resetAllConnections) || action.equals(rebuildStationMap)) {
            try {
                Invocation i = new Invocation((BComponent)this, action, null, cx);
                try {
                    this.getWorkers().process(i);
                    return null;
                }
                catch (NotRunningException notRunningException) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.post(action, arg, cx);
    }

    public void renamed(Property prop, String old, Context context) {
        super.renamed(prop, old, context);
        this.rebuildStationMap();
    }

    public void childParented(Property prop, BValue v, Context context) {
        super.childParented(prop, v, context);
        if (v instanceof BNiagaraStation || v instanceof BNiagaraStationFolder) {
            this.rebuildStationMap();
        }
    }

    public void childUnparented(Property prop, BValue v, Context context) {
        super.childUnparented(prop, v, context);
        if (v instanceof BNiagaraStation || v instanceof BNiagaraStationFolder) {
            this.rebuildStationMap();
        }
    }

    public AgentList getAgents(Context cx) {
        return BNiagaraNetwork.filterProvAgentList((BComponent)this, super.getAgents(cx));
    }

    static AgentList filterProvAgentList(BComponent comp, AgentList result) {
        int ixProvisioningManager = result.indexOf("provisioningNiagara:ProvisioningManager");
        if (ixProvisioningManager >= 0) {
            BNiagaraNetwork niagaraNetwork = null;
            if (comp instanceof BNiagaraNetwork) {
                niagaraNetwork = (BNiagaraNetwork)comp;
            } else {
                for (BComplex p = comp.getParent(); p != null; p = p.getParent()) {
                    if (!(p instanceof BNiagaraNetwork)) continue;
                    niagaraNetwork = (BNiagaraNetwork)p;
                    break;
                }
            }
            boolean removeProvManager = true;
            if (niagaraNetwork != null && niagaraNetwork.isMounted()) {
                try {
                    Type provNetExtType = Sys.getType((String)"provisioningNiagara:ProvisioningNiagaraNetworkExt");
                    niagaraNetwork.lease();
                    SlotCursor cursor = niagaraNetwork.getProperties();
                    while (cursor.nextComponent()) {
                        if (!cursor.get().getType().is(provNetExtType)) continue;
                        removeProvManager = false;
                        break;
                    }
                }
                catch (Throwable provNetExtType) {
                    // empty catch block
                }
            }
            if (removeProvManager) {
                result.remove(ixProvisioningManager);
            } else {
                int ixStationManager = result.indexOf("niagaraDriver:StationManager");
                if (ixProvisioningManager < ixStationManager) {
                    result.swap(ixProvisioningManager, ixStationManager);
                }
            }
        }
        return result;
    }

    public BFoxServerConnection getPersistentConnection(FoxSession session, FoxMessage remoteHello) {
        String stationName = remoteHello.getString("station.name", null);
        if (stationName == null) {
            return null;
        }
        BNiagaraStation station = (BNiagaraStation)this.getStation(stationName);
        return station == null ? null : station.getServerConnection();
    }

    public void serverConnectionCreated(BFoxServerConnection connection, FoxSession session, FoxMessage remoteHello) {
        try {
            String stationName = remoteHello.getString("station.name", null);
            if (stationName == null) {
                return;
            }
            BNiagaraStation station = (BNiagaraStation)this.getStation(stationName);
            if (station == null) {
                LOG.info("Creating station for connection \"" + stationName + "\"");
                station = BNiagaraEdgeLiteStation.getSuitableNiagaraStationInstance(remoteHello);
                station.setEnabled(false);
                Property p = this.add(stationName, (BValue)station);
                station = (BNiagaraStation)this.get(p);
                if (station.isFatalFault() && station.getType().is(BNiagaraEdgeLiteStation.TYPE)) {
                    this.remove(p);
                    station = new BNiagaraStation();
                    station.setEnabled(false);
                    p = this.add(stationName, (BValue)station);
                    station = (BNiagaraStation)this.get(p);
                }
                this.initStationFromHello(station, remoteHello);
            }
            if (!connection.isPersistent()) {
                station.setServerConnection(connection);
                connection.setPersistent(true);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "NiagaraNetwork error handling new fox server connection", e);
        }
    }

    public void serverConnectionClosed(BFoxServerConnection connection, Throwable reason) {
        if (this.stations == null) {
            return;
        }
        if (connection.isPersistent()) {
            for (NiagaraStation stationPublic : this.stations.values()) {
                BNiagaraStation station = (BNiagaraStation)stationPublic;
                if (!station.getServerConnectionOrd().equals((Object)connection.getHandleOrd())) continue;
                station.serverClosed();
                return;
            }
        }
    }

    private void initStationFromHello(BNiagaraStation station, FoxMessage hello) {
        try {
            String host = hello.getString("hostName");
            int port = hello.getInt("foxServerPort", 1911);
            boolean useFoxs = hello.getBoolean("foxServerUseFoxs", false);
            station.setAddress(BOrd.make((String)("ip:" + host)));
            station.getClientConnection().setPort(port);
            station.getClientConnection().setUseFoxs(useFoxs);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, "initStationFromHello", e);
        }
    }

    @Override
    public List<BNiagaraProxyExt> getDescendantNiagaraProxyExts() {
        ArrayList<BNiagaraProxyExt> result = new ArrayList<BNiagaraProxyExt>();
        if (this.stations != null) {
            for (NiagaraStation station : this.stations.values()) {
                if (!(station instanceof BNiagaraStation)) continue;
                result.addAll(((BNiagaraStation)station).getDescendantNiagaraProxyExts());
            }
        }
        return result;
    }

    public BOrd doForceUpdateNiagaraProxyPoints(Context cx) {
        return new BForceUpdateNiagaraPointsJob(this).submit(cx);
    }

    public BFoxService getFoxService() {
        return (BFoxService)Sys.getService((Type)BFoxService.TYPE);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static final String getStationSpaceOrdByName(String stationName, Context cx) throws UnresolvedException {
        if (!Sys.getStation().getStationName().equals(stationName)) {
            BNiagaraNetwork network = (BNiagaraNetwork)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get(null, cx);
            BComponent station = (BComponent)network.getStation(stationName);
            if (station != null && station.getPermissions(cx).hasOperatorRead()) {
                return BOrd.make((BOrd)station.getAbsoluteOrd(), (String)"slot:virtual|virtual:").encodeToString();
            }
            throw new UnresolvedException(LEX.getHtmlSafeText("niagaraNetwork.rpc.stationLookup.error", new Object[]{stationName}));
        }
        return "local:|station:";
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static final String getStationSlotPathByName(String stationName, Context cx) throws UnresolvedException {
        BNiagaraNetwork network = (BNiagaraNetwork)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get(null, cx);
        BComponent station = (BComponent)network.getStation(stationName);
        if (station != null && station.getPermissions(cx).hasOperatorRead()) {
            return station.getSlotPathOrd().toString();
        }
        throw new UnresolvedException(LEX.getHtmlSafeText("niagaraNetwork.rpc.stationLookup.error", new Object[]{stationName}));
    }

    static {
        try {
            BFoxChannelRegistry.getPrototype().add("point", (BValue)new BPointChannel());
            BFoxChannelRegistry.getPrototype().add("schedule", (BValue)new BScheduleChannel());
            BFoxChannelRegistry.getPrototype().add("alarm", (BValue)new BAlarmChannel());
            BFoxChannelRegistry.getPrototype().add("history", (BValue)new BHistoryChannel());
            BFoxChannelRegistry.getPrototype().add("archive", (BValue)new BArchiveChannel());
            BFoxChannelRegistry.getPrototype().add("usersync", (BValue)new BUserSyncChannel());
            BFoxChannelRegistry.getPrototype().add("niagaraVirtual", (BValue)new BNiagaraVirtualChannel());
            BFoxChannelRegistry.getPrototype().add("sysdef", (BValue)new BSysDefChannel());
        }
        catch (DuplicateSlotException duplicateSlotException) {
            // empty catch block
        }
        LOG = Logger.getLogger("niagaraDriver");
        LEX = Lexicon.make((String)"niagaraDriver");
    }
}

