/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfSerial.comm;

import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddfSerial.comm.BDdfSerialCommunicator;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDdfSerialTransmitter
extends BDdfTransmitter {
    public static final Property maxRetryCount = BDdfSerialTransmitter.newProperty((int)0, (int)2, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Type TYPE = Sys.loadType(BDdfSerialTransmitter.class);

    public int getMaxRetryCount() {
        return this.getInt(maxRetryCount);
    }

    public void setMaxRetryCount(int v) {
        this.setInt(maxRetryCount, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void forceTransmit(BIDdfRequest ddfRequest) throws Exception {
        byte[] out = ddfRequest.toByteArray();
        if (this.getDdfCommunicator().getLog().isTraceOn()) {
            this.trace(out);
        }
        this.getSerialCommunicator().getSerialOutputStream().write(out);
    }

    public BDdfSerialCommunicator getSerialCommunicator() {
        return (BDdfSerialCommunicator)this.getDdfCommunicator();
    }

    private void trace(byte[] out) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("TX:");
        ByteArrayUtil.hexDump((PrintWriter)pw, (byte[])out, (int)0, (int)out.length);
        pw.flush();
        pw.close();
        this.getDdfCommunicator().getLog().trace(sw.toString());
    }
}

