/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platMstp;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platMstp.BBacnetMstpPlatformService;
import com.tridium.platMstp.MstpFrame;
import com.tridium.platMstp.MstpListener;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.logging.Level;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.serial.PortDeniedException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetMstpPlatformServiceQnx
extends BBacnetMstpPlatformService {
    public static final Type TYPE = Sys.loadType(BBacnetMstpPlatformServiceQnx.class);
    private static boolean nativesLoaded = false;
    private HashMap<Integer, Runnable> trunkListeners = new HashMap();
    private Process mstpd;

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx);
    }

    protected synchronized boolean loadLibraries() {
        if (nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                log.fine("Loading platmstp native library");
                System.loadLibrary("platmstp");
                nativesLoaded = true;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Cannot load platmstp native library", e);
            }
            return nativesLoaded;
        });
    }

    public void serviceStarted() throws Exception {
        if (!this.initMstp()) {
            throw new RuntimeException("failed to initialize mstp platform driver");
        }
        log.fine("mstp initialization complete");
        super.serviceStarted();
    }

    public void serviceStopped() throws Exception {
        this.cleanupMstp();
        log.fine("mstp cleanup complete");
        super.serviceStopped();
    }

    @Override
    protected boolean initMstp() {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        try {
            AccessController.doPrivileged(() -> {
                File f = new File("/dev/mstp1");
                if (f.exists()) {
                    log.info("MSTP daemon already running");
                } else {
                    int numTrunks = 6;
                    int usageTimeout = 20;
                    String extraOpts = "";
                    String optString = "-n " + numTrunks + " -u " + usageTimeout;
                    try {
                        optString = FileUtil.readString((File)new File("/var/cookies/mstp.opt"));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    String[] opts = optString.split("-");
                    for (int i = 0; i < opts.length; ++i) {
                        String arg = opts[i].trim();
                        if (arg.length() == 0) continue;
                        if (arg.startsWith("n")) {
                            try {
                                numTrunks = Integer.parseInt(arg.substring(1).trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                            continue;
                        }
                        if (arg.startsWith("u")) {
                            try {
                                usageTimeout = Integer.parseInt(arg.substring(1).trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                            continue;
                        }
                        if (arg.startsWith("?") || arg.startsWith("t")) continue;
                        extraOpts = " -" + arg;
                    }
                    try {
                        int numTrunksLicensed = 6;
                        Feature feat = Sys.getLicenseManager().checkFeature("tridium", this.getLicenseFeature());
                        String portLimit = feat.get("port.limit");
                        if (portLimit != null && !TextUtil.toLowerCase((String)portLimit).equals("none")) {
                            numTrunksLicensed = Integer.parseInt(portLimit);
                        }
                        if (numTrunksLicensed > 6) {
                            numTrunksLicensed = 6;
                        }
                        if (numTrunksLicensed < numTrunks) {
                            numTrunks = numTrunksLicensed;
                        }
                        this.mstpd = Runtime.getRuntime().exec("/proc/boot/mstp -n " + numTrunks + " -u " + usageTimeout + extraOpts);
                    }
                    catch (FeatureNotLicensedException | LicenseDatabaseException throwable) {
                        // empty catch block
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae.getException());
        }
        return true;
    }

    @Override
    protected void cleanupMstp() {
        if (this.mstpd != null) {
            this.mstpd.destroy();
            this.mstpd = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startDriver(String trunk, String osSerialPortName, int baudRate, int tsAddr, int maxMaster, int maxFrames, MstpListener linkListener) {
        log.fine("Starting mstp driver: " + osSerialPortName + " at " + baudRate + " baud, tsAddr=" + tsAddr + " maxMaster=" + maxMaster + " maxInfoFrames=" + maxFrames);
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        if (osSerialPortName == null) {
            throw new NullPointerException("Can start MSTP driver on null device");
        }
        try {
            this.lockSerial(osSerialPortName);
        }
        catch (PortDeniedException pde) {
            log.severe("Could not open mstp on serial port " + osSerialPortName + ", failed to obtain lock");
            throw new RuntimeException("Cannot open mstp");
        }
        boolean success = false;
        try {
            int handle = this.openDriver0(trunk, osSerialPortName, baudRate, tsAddr, maxMaster, maxFrames);
            if (handle == -1) {
                log.severe("Could not open mstp on serial port: " + osSerialPortName);
                throw new RuntimeException("Cannot open mstp");
            }
            this.handleToName.put(handle, osSerialPortName);
            MstpTrunkListener trunkListener = new MstpTrunkListener(handle, linkListener);
            Thread trunkListenerThread = new Thread((Runnable)trunkListener, "mstp" + handle);
            trunkListenerThread.start();
            trunkListener.myThread = trunkListenerThread;
            this.trunkListeners.put(handle, trunkListener);
            success = true;
            int n = handle;
            return n;
        }
        finally {
            if (!success) {
                try {
                    log.fine("Failed to open MSTP, unlocking serial device " + osSerialPortName);
                    this.unlockSerial(osSerialPortName);
                }
                catch (PortDeniedException pde) {
                    log.log(Level.WARNING, "Failed to unlock mstp serial device " + osSerialPortName, pde);
                }
            }
        }
    }

    @Override
    public void stopDriver(int handle) {
        log.fine("stopping mstp driver");
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        MstpTrunkListener ls = (MstpTrunkListener)this.trunkListeners.get(handle);
        if (ls == null) {
            throw new RuntimeException("Invalid handle " + handle);
        }
        ls.done = true;
        ls.myThread.interrupt();
        this.closeDriver0(handle);
        String osPortName = (String)this.handleToName.remove(handle);
        try {
            this.unlockSerial(osPortName);
        }
        catch (PortDeniedException pde) {
            log.log(Level.SEVERE, "Failed to unlock mstp serial device " + osPortName, pde);
        }
        log.fine("mstp driver stopped");
    }

    @Override
    public void sendFrame(int handle, byte destAddr, byte[] packet, boolean dataExpectingReply) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        if (packet.length > 1497) {
            throw new IllegalArgumentException("Invalid frame length " + packet.length);
        }
        this.sendFrame0(handle, (byte)(destAddr & 0xFF), packet, dataExpectingReply);
    }

    @Override
    public void setBaudRate(int handle, int baudRate) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.fine("setting baud rate to " + baudRate);
        this.setBaudRate0(handle, baudRate);
    }

    @Override
    public void setMaxMaster(int handle, int maxMaster) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.fine("setting max master to " + maxMaster);
        this.setMaxMaster0(handle, maxMaster);
    }

    @Override
    public void setMaxInfoFrames(int handle, int maxInfoFrames) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.fine("setting max info frames to " + maxInfoFrames);
        this.setMaxInfoFrames0(handle, maxInfoFrames);
    }

    @Override
    public void setAddress(int handle, int macAddress) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.fine("setting this station address to " + macAddress);
        this.setAddress0(handle, macAddress);
    }

    @Override
    public int getAddress(int handle) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        int addr = this.getAddress0(handle);
        log.fine("getAddress0 returned " + addr);
        return addr;
    }

    @Override
    public void setParameter(int handle, String name, String value) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        if (name == null || value == null) {
            throw new RuntimeException("Null mstp parameter");
        }
        log.fine("setting mstp parameter " + name + " to " + value);
        this.setParameter0(handle, name, value);
    }

    private native int openDriver0(String var1, String var2, int var3, int var4, int var5, int var6);

    private native void closeDriver0(int var1);

    private native void rcvFrame0(int var1, MstpFrame var2);

    private native void sendFrame0(int var1, byte var2, byte[] var3, boolean var4);

    private native void setBaudRate0(int var1, int var2);

    private native void setMaxMaster0(int var1, int var2);

    private native void setMaxInfoFrames0(int var1, int var2);

    private native void setAddress0(int var1, int var2);

    private native int getAddress0(int var1);

    private native void setParameter0(int var1, String var2, String var3);

    class MstpTrunkListener
    implements Runnable {
        int handle;
        MstpListener linkListener;
        Thread myThread;
        boolean done = false;

        public MstpTrunkListener(int handle, MstpListener linkListener) {
            this.handle = handle;
            this.linkListener = linkListener;
        }

        @Override
        public void run() {
            MstpFrame frame = new MstpFrame();
            BBacnetMstpPlatformService.log.fine("mstp trunk listener starting");
            while (!this.done) {
                try {
                    BBacnetMstpPlatformServiceQnx.this.rcvFrame0(this.handle, frame);
                    if (this.linkListener == null) continue;
                    this.linkListener.receiveFrame(frame.getSrcAddr(), frame.getData(), frame.getDataExpectingReply());
                }
                catch (Exception e) {
                    if (this.done) continue;
                    e.printStackTrace();
                }
            }
            BBacnetMstpPlatformService.log.fine("mstp trunk listener done");
        }
    }
}

