/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui.daemon;

import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platwifi.BSupplicantNetBlock;
import com.tridium.platwifi.BSupplicantNetBlockVector;
import com.tridium.platwifi.BWifiMonitorData;
import com.tridium.platwifi.BWifiSettings;
import com.tridium.platwifi.WifiUtil;
import com.tridium.platwifi.daemon.message.ChangeWiFiEnabledMessage;
import com.tridium.platwifi.ui.BWifiAccessPointManager;
import com.tridium.platwifi.ui.BWifiNetworksManager;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BWifiConfiguration
extends BDaemonSessionView {
    public static final Action wifiEnabledModified = BWifiConfiguration.newAction((int)4, null);
    public static final Action ccModified = BWifiConfiguration.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BWifiConfiguration.class);
    private static final Object settingsMonitor = new Object();
    private BFacets pollFacets = BFacets.make((String)"poll", (boolean)true);
    private BDaemonSession daemonSession = null;
    private BWifiNetworksManager networkManager = null;
    private BWifiAccessPointManager accessPointManager = null;
    private BWifiSettings wifiSettings = null;
    private BLabel wifiSwitchField = null;
    private BLabel wifiMonitorStateField = null;
    private BBooleanFE wifiEnabledField = null;
    private BListDropDown ccFE;
    BTabbedPane tabbedPane;
    private Lexicon lex;
    private String oldMonState = "unknown";
    private String newMonState = "";
    private String enetCfg = "";
    ArrayList<BString> countries = new ArrayList();
    String wifiSku;

    public void wifiEnabledModified() {
        this.invoke(wifiEnabledModified, null, null);
    }

    public void ccModified() {
        this.invoke(ccModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadSession(BDaemonSession session, Context cx) throws AuthenticationException {
        this.lex = TYPE.getModule().getLexicon();
        this.daemonSession = session;
        this.wifiSettings = new BWifiSettings();
        this.networkManager = new BWifiNetworksManager(session);
        this.accessPointManager = new BWifiAccessPointManager(session);
        BGridPane generalPane = new BGridPane(2);
        generalPane.setRowAlign(BValign.top);
        generalPane.setHalign(BHalign.left);
        generalPane.setColumnAlign(BHalign.left);
        generalPane.setRowGap(5.0);
        generalPane.setColumnGap(10.0);
        generalPane.setStretchColumn(1);
        if (this.get("networkManagerModified") != null) {
            this.remove("networkManagerModified");
        }
        this.linkTo("networkManagerModified", (BComponent)this.networkManager, (Slot)BWifiNetworksManager.pluginModified, (Slot)setModified);
        if (this.get("accessPointManagerModified") != null) {
            this.remove("accessPointManagerModified");
        }
        this.linkTo("accessPointManagerModified", (BComponent)this.accessPointManager, (Slot)BWifiAccessPointManager.pluginModified, (Slot)setModified);
        try {
            this.wifiEnabledField = new BBooleanFE();
            LabelUtil.addLabelWidgetPair((BPane)generalPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiConfiguration.state.wifiEnabled.label"), (BWidget)this.wifiEnabledField);
            this.linkTo(null, (BComponent)this.wifiEnabledField, (Slot)BWbFieldEditor.pluginModified, (Slot)wifiEnabledModified);
            this.wifiSwitchField = new BLabel("");
            LabelUtil.addLabelWidgetPair((BPane)generalPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiConfiguration.state.wifiSwitch.label"), (BWidget)this.wifiSwitchField);
            this.wifiMonitorStateField = new BLabel("");
            LabelUtil.addLabelWidgetPair((BPane)generalPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiConfiguration.state.monitorState.label"), (BWidget)this.wifiMonitorStateField);
            this.ccFE = new BListDropDown();
            LabelUtil.addLabelWidgetPair((BPane)generalPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiConfiguration.state.countryCode.label"), (BWidget)this.ccFE);
            BBorderPane generalBorder = new BBorderPane((BWidget)generalPane);
            generalBorder.setBorder(BBorder.groove);
            generalBorder.setLabel((BWidget)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platWifi", (String)"WifiConfiguration.state.label"), (boolean)true));
            generalBorder.setMargin(BInsets.make((double)6.0, (double)0.0, (double)6.0, (double)0.0));
            this.tabbedPane = new BTabbedPane();
            this.tabbedPane.addPane(new BLabel(BImage.make((BIcon)BIcon.std((String)"wireless.png")), LexiconText.make((Type)TYPE, (String)"WifiNetworksManager.label").getText(cx), Theme.widget().getBoldText()), (BWidget)this.networkManager);
            this.tabbedPane.addPane(new BLabel(BImage.make((BIcon)BIcon.std((String)"remoteMgmt.png")), LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.label").getText(cx), Theme.widget().getBoldText()), (BWidget)this.accessPointManager);
            BBorderPane tabbedPaneBorder = new BBorderPane((BWidget)this.tabbedPane, BBorder.solid);
            tabbedPaneBorder.setMargin(BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0));
            BEdgePane allPanes = new BEdgePane((BWidget)generalBorder, (BWidget)tabbedPaneBorder, null, null, null);
            this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(cx), (BWidget)allPanes));
            Object object = settingsMonitor;
            synchronized (object) {
                this.wifiSku = WifiUtil.wifiSkuFromSession((BDaemonSession)session);
                if (this.wifiSku.equals("XX")) {
                    this.stopRefreshTimer();
                    this.wifiEnabledField.loadValue((BObject)BBoolean.FALSE);
                    this.wifiEnabledField.setEnabled(false);
                    this.ccFE.getList().addItem((Object)BString.make((String)"NONE"));
                    this.ccFE.setEnabled(false);
                    return;
                }
                WifiUtil.monitorDataFromSession((BWifiMonitorData)this.wifiSettings.getMonitorData(), (BDaemonSession)session);
                this.wifiSwitchField.setText(this.wifiSettings.getMonitorData().getWifiSwitchPosition().getDisplayTag(null));
                String wifiMonState = this.wifiSettings.getMonitorData().getWifimonState();
                this.wifiMonitorStateField.setText(this.lex.get("WifiConfiguration.state.monitorState." + wifiMonState));
                this.wifiEnabledField.loadValue((BObject)BBoolean.make((boolean)this.wifiSettings.getMonitorData().getWifiEnabled()), cx);
                String cc = WifiUtil.countryCodeFromSession((BDaemonSession)session);
                BString ccStr = BString.make((String)cc);
                if (!cc.equals("US")) {
                    ArrayList countries = new ArrayList();
                    WifiUtil.countryListFromSession(countries, (BDaemonSession)session);
                    for (int i = 0; i < countries.size(); ++i) {
                        BString item = (BString)countries.get(i);
                        this.ccFE.getList().addItem((Object)item);
                        if (!item.getString().startsWith(cc)) continue;
                        this.ccFE.setSelectedIndex(i);
                    }
                    this.ccFE.setEnabled(true);
                } else {
                    this.ccFE.getList().addItem((Object)ccStr);
                    this.ccFE.setEnabled(false);
                    this.ccFE.setSelectedItem((Object)ccStr);
                }
                this.linkTo(null, (BComponent)this.ccFE, (Slot)BListDropDown.valueModified, (Slot)ccModified);
                WifiUtil.loadFromSession((BWifiSettings)this.wifiSettings, (BDaemonSession)session);
                WifiUtil.netCfgFromSession((BWifiSettings)this.wifiSettings, (BDaemonSession)session);
                this.networkManager.loadValue((BObject)this.wifiSettings, cx);
                this.accessPointManager.loadValue((BObject)this.wifiSettings, cx);
                this.setReadonly(!session.getHostProperties().hasFullAccess());
                this.doWifiEnabledModified(false);
                this.startRefreshTimer();
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LocalizableRuntimeException("platWifi", "WifiConfiguration.parseError", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final BObject doSaveValue(BObject value, Context cx) throws Exception {
        Object object = settingsMonitor;
        synchronized (object) {
            this.wifiSettings.setWifiEnabled(((BBoolean)this.wifiEnabledField.saveValue(cx)).getBoolean());
            this.wifiSettings = (BWifiSettings)this.accessPointManager.saveValue((BObject)this.wifiSettings, cx);
            this.wifiSettings = (BWifiSettings)this.networkManager.saveValue((BObject)this.wifiSettings, cx);
            BSupplicantNetBlockVector newblocks = this.wifiSettings.getSupplicantNetworkBlocks();
            SlotCursor c = newblocks.loadSlots().getProperties();
            while (c.next(BSupplicantNetBlock.class)) {
                BSupplicantNetBlock bSupplicantNetBlock = (BSupplicantNetBlock)c.get();
            }
            BWifiSettings copy = (BWifiSettings)this.wifiSettings.newCopy(true);
            WifiUtil.saveToSession((BWifiSettings)copy, (BDaemonSession)this.getDaemonSession(), (Context)cx);
        }
        return value;
    }

    public BDaemonSession getDaemonSession() {
        return this.daemonSession;
    }

    protected void doSetReadonly(boolean readonly) {
        this.wifiEnabledField.setReadonly(readonly);
        this.accessPointManager.setReadonly(readonly);
        this.networkManager.setReadonly(readonly);
    }

    public void activated() {
        super.activated();
        this.startRefreshTimer();
    }

    public void deactivated() {
        super.deactivated();
        this.stopRefreshTimer();
    }

    public void doWifiEnabledModified() {
        this.doWifiEnabledModified(true);
    }

    public void doWifiEnabledModified(boolean sendDaemonMessage) {
        if (!this.isReadonly()) {
            boolean wifiEnabled = false;
            try {
                wifiEnabled = ((BBoolean)this.wifiEnabledField.saveValue()).getBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.accessPointManager.setReadonly(!wifiEnabled);
            this.networkManager.setReadonly(!wifiEnabled);
            if (sendDaemonMessage) {
                try {
                    this.daemonSession.sendMessage((DaemonMessage)new ChangeWiFiEnabledMessage(wifiEnabled));
                }
                catch (Exception e) {
                    String message = this.getLexicon().getText("WifiConfiguration.state.wifiEnabled.error", new Object[]{wifiEnabled});
                    BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)message, (Throwable)e);
                }
                this.doRefresh();
            }
        }
    }

    public void doCcModified() throws Exception {
        if (this.daemonSession == null) {
            return;
        }
        BString ccStr = (BString)this.ccFE.getSelectedItem();
        System.out.println("changed country code to " + ccStr.getString());
        StringTokenizer stringTokenizer = new StringTokenizer(ccStr.getString(), "-");
        WifiUtil.sessionToCountryCode((String)stringTokenizer.nextToken(), (BDaemonSession)this.daemonSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRefresh() {
        if (this.daemonSession == null) {
            return;
        }
        try {
            Object object = settingsMonitor;
            synchronized (object) {
                BWifiMonitorData data = this.wifiSettings.getMonitorData();
                WifiUtil.monitorDataFromSession((BWifiMonitorData)data, (BDaemonSession)this.daemonSession);
                this.wifiSwitchField.setText(data.getWifiSwitchPosition().getDisplayTag(null));
                String wifiMonState = this.wifiSettings.getMonitorData().getWifimonState();
                this.wifiMonitorStateField.setText(this.lex.get("WifiConfiguration.state.monitorState." + wifiMonState));
                this.wifiEnabledField.loadValue((BObject)BBoolean.make((boolean)this.wifiSettings.getMonitorData().getWifiEnabled()));
                this.newMonState = data.getWifimonState();
                if (!this.newMonState.equals(this.oldMonState)) {
                    WifiUtil.loadFromSession((BWifiSettings)this.wifiSettings, (BDaemonSession)this.daemonSession);
                    if (data.getWifiSwitchPosition().getOrdinal() == 1 && this.newMonState.startsWith("sta_")) {
                        this.networkManager.refreshSettings(this.wifiSettings, (Context)new BasicContext((Context)this.pollFacets));
                    }
                    this.doWifiEnabledModified(false);
                    this.oldMonState = this.newMonState;
                }
            }
        }
        catch (AuthenticationException ae) {
            this.reauthenticate(ae);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

