/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platwifi.BWifiMacAddress;
import com.tridium.platwifi.BWifiMacAddressVector;
import com.tridium.platwifi.BWifiPlatformService;
import com.tridium.platwifi.WifiUtil;
import com.tridium.platwifi.ui.BWifiAccessPointManager;
import com.tridium.platwifi.ui.BWifiMacAddressVectorEditor;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.workbench.CannotSaveException;

public class BWifiWhiteListEditorDialog
extends BDialog {
    public static final Action enableOkCommand = BWifiWhiteListEditorDialog.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BWifiWhiteListEditorDialog.class);
    BWifiMacAddressVectorEditor whitelistEditor = null;
    Command okCommand;
    Command cancelCommand;
    int dialogResult;
    BDaemonSession sessionToUse = null;
    BWifiPlatformService serviceToUse = null;
    BWifiMacAddressVector whitelist;

    public void enableOkCommand() {
        this.invoke(enableOkCommand, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BWifiWhiteListEditorDialog(BWidget owner, String title, BWifiMacAddressVector whitelist) throws Exception {
        super(owner, title, true);
        this.whitelist = whitelist;
        this.okCommand = new Ok((BWidget)this);
        this.cancelCommand = new Cancel((BWidget)this);
        this.okCommand.setEnabled(false);
        this.cancelCommand.setEnabled(true);
        BGridPane actions = new BGridPane(2);
        actions.setColumnAlign(BHalign.fill);
        actions.setUniformColumnWidth(true);
        actions.add(null, (BValue)new BButton(this.okCommand));
        actions.add(null, (BValue)new BButton(this.cancelCommand));
        this.whitelistEditor = new BWifiMacAddressVectorEditor(this);
        this.linkTo(null, (BComponent)this.whitelistEditor, (Slot)BWifiMacAddressVectorEditor.pluginModified, (Slot)enableOkCommand);
        BEdgePane edgePane = new BEdgePane((BWidget)this.whitelistEditor, (BWidget)new BBorderPane((BWidget)actions, 10.0, 10.0, 10.0, 10.0), null, null, null);
        edgePane.getTop().setLayout(BLayout.FILL);
        this.setContent((BWidget)new BScrollPane((BWidget)edgePane));
        this.refreshSettings();
    }

    private void refreshSettings() throws Exception {
        BWifiAccessPointManager manager = (BWifiAccessPointManager)this.getOwner();
        BWifiMacAddressVector macs = new BWifiMacAddressVector();
        if (manager.getWifiDaemonSession() != null) {
            this.sessionToUse = manager.getWifiDaemonSession();
            this.serviceToUse = null;
            WifiUtil.whitelistFromSession((BWifiMacAddressVector)macs, (BDaemonSession)manager.wifiDaemonSession);
            this.whitelistEditor.loadValue((BObject)macs, null);
        } else if (manager.getWifiPlatformService() != null) {
            this.serviceToUse = manager.getWifiPlatformService();
            this.sessionToUse = null;
        } else {
            throw new IllegalStateException("Could not find Wifi station platform service or daemon session");
        }
    }

    public void doEnableOkCommand() {
        this.okCommand.setEnabled(true);
    }

    public int getResult() {
        return this.dialogResult;
    }

    public void windowClosing(BWindowEvent event) {
        super.windowClosing(event);
        this.cancelCommand.invoke();
    }

    class Cancel
    extends Command {
        Cancel(BWidget owner) {
            super(owner, BWifiWhiteListEditorDialog.this.getLexicon().getText("whitelist.dialog.cancel"));
        }

        public CommandArtifact doInvoke() {
            BWifiWhiteListEditorDialog.this.dialogResult = 2;
            BWifiWhiteListEditorDialog.this.close();
            return null;
        }
    }

    class Ok
    extends Command {
        BWifiMacAddressVector newWhitelist;

        Ok(BWidget owner) {
            super(owner, BWifiWhiteListEditorDialog.this.getLexicon().getText("whitelist.dialog.ok"));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public CommandArtifact doInvoke() {
            try {
                BWifiWhiteListEditorDialog.this.whitelistEditor.setModified();
                this.newWhitelist = (BWifiMacAddressVector)BWifiWhiteListEditorDialog.this.whitelistEditor.saveValue();
                if (BWifiWhiteListEditorDialog.this.sessionToUse != null) {
                    WifiUtil.sessionToWhitelist((BWifiMacAddressVector)this.newWhitelist, (BDaemonSession)BWifiWhiteListEditorDialog.this.sessionToUse);
                } else if (BWifiWhiteListEditorDialog.this.serviceToUse == null) {
                    // empty if block
                }
            }
            catch (Exception e) {
                CannotSaveException cse;
                boolean show = true;
                if (e instanceof CannotSaveException && (cse = (CannotSaveException)e).isSilent()) {
                    return null;
                }
                if (!show) return null;
                BDialog.error((BWidget)this.getOwner(), (String)BWifiWhiteListEditorDialog.this.getLexicon().getText("whitelist.dialog.cannotSave.label"), (Object)BWifiWhiteListEditorDialog.this.getLexicon().getText(e.getMessage()));
                return null;
            }
            BWifiMacAddress[] addresses = (BWifiMacAddress[])this.newWhitelist.getChildren(BWifiMacAddress.class);
            int i = 0;
            while (true) {
                if (i >= addresses.length) {
                    BWifiWhiteListEditorDialog.this.dialogResult = 1;
                    BWifiWhiteListEditorDialog.this.close();
                    return null;
                }
                BWifiWhiteListEditorDialog.this.whitelist.add("mac" + i, (BValue)new BWifiMacAddress(addresses[i].getMac()));
                ++i;
            }
        }
    }
}

