/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platwifi.BWifiNetwork;
import com.tridium.platwifi.ui.BWifiNetworkEditor;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.CannotSaveException;

public class BWifiNetworkEditorDialog
extends BDialog {
    public static final Action enableOkCommand = BWifiNetworkEditorDialog.newAction((int)0, null);
    public static final Action disableOkCommand = BWifiNetworkEditorDialog.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BWifiNetworkEditorDialog.class);
    BWifiNetworkEditor networkEditor = null;
    BWifiNetwork content = null;
    Command okCommand = new Ok((BWidget)this);
    Command cancelCommand = new Cancel((BWidget)this);
    int dialogResult;

    public void enableOkCommand() {
        this.invoke(enableOkCommand, null, null);
    }

    public void disableOkCommand() {
        this.invoke(disableOkCommand, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BWifiNetworkEditorDialog(BWidget owner, String title, int configurationMode, BWifiNetwork network) throws Exception {
        super(owner, title, true);
        this.okCommand.setEnabled(false);
        this.cancelCommand.setEnabled(true);
        BGridPane actions = new BGridPane();
        actions.setColumnAlign(BHalign.fill);
        actions.setUniformColumnWidth(true);
        actions.add(null, (BValue)new BButton(this.okCommand));
        actions.add(null, (BValue)new BButton(this.cancelCommand));
        this.networkEditor = new BWifiNetworkEditor();
        this.networkEditor.loadValue((BObject)network, (Context)new BasicContext((Context)BFacets.make((String)"configureMode", (int)configurationMode)));
        this.linkTo(null, (BComponent)this.networkEditor, (Slot)BWifiNetworkEditor.pluginModified, (Slot)enableOkCommand);
        BEdgePane edgePane = new BEdgePane(null, (BWidget)new BBorderPane((BWidget)actions, 0.0, 10.0, 10.0, 10.0), null, null, (BWidget)new BBorderPane((BWidget)this.networkEditor));
        this.setSize(this.getPreferredWidth() + 50.0, this.getPreferredHeight() + 100.0);
        this.setContent((BWidget)edgePane);
    }

    public void doEnableOkCommand() {
        this.okCommand.setEnabled(true);
    }

    public void doDisableOkCommand() {
        this.okCommand.setEnabled(false);
    }

    public int getResult() {
        return this.dialogResult;
    }

    public BWifiNetwork getNetwork() throws Exception {
        if (this.content == null) {
            this.content = (BWifiNetwork)this.networkEditor.saveValue();
        }
        return this.content;
    }

    public void windowClosing(BWindowEvent event) {
        super.windowClosing(event);
        this.cancelCommand.invoke();
    }

    class Cancel
    extends Command {
        Cancel(BWidget owner) {
            super(owner, UiLexicon.bajaui().getText("dialog.cancel"));
        }

        public CommandArtifact doInvoke() {
            BWifiNetworkEditorDialog.this.dialogResult = 2;
            BWifiNetworkEditorDialog.this.close();
            return null;
        }
    }

    class Ok
    extends Command {
        Ok(BWidget owner) {
            super(owner, UiLexicon.bajaui().getText("dialog.ok"));
        }

        public CommandArtifact doInvoke() {
            try {
                BWifiNetworkEditorDialog.this.networkEditor.setModified();
                BWifiNetworkEditorDialog.this.content = (BWifiNetwork)BWifiNetworkEditorDialog.this.networkEditor.saveValue();
            }
            catch (Exception e) {
                CannotSaveException cse;
                boolean show = true;
                if (e instanceof CannotSaveException && (cse = (CannotSaveException)e).isSilent()) {
                    show = false;
                }
                if (show) {
                    BDialog.error((BWidget)this.getOwner(), (String)BWifiNetworkEditorDialog.this.getLexicon().getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)BWifiNetworkEditorDialog.this.getLexicon().getText(e.getMessage()));
                }
                return null;
            }
            BWifiNetworkEditorDialog.this.dialogResult = 1;
            BWifiNetworkEditorDialog.this.close();
            return null;
        }
    }
}

