/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.maxpro.nvr;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.maxpro.BMaxproNetwork;
import com.tridium.maxpro.camera.BMaxproCamera;
import com.tridium.maxpro.camera.BMaxproCameraDeviceExt;
import com.tridium.maxpro.camera.BMaxproCameraDeviceId;
import com.tridium.maxpro.datatypes.BMaxproIpAddress;
import com.tridium.maxpro.enums.BMaxproEventTypesEnum;
import com.tridium.maxpro.event.BMaxproAlarmExt;
import com.tridium.maxpro.event.BMaxproEventCameraExt;
import com.tridium.maxpro.event.BMaxproEventProxyExt;
import com.tridium.maxpro.nvr.BMaxproMultistreamPreferences;
import com.tridium.maxpro.nvr.BMaxproNvrId;
import com.tridium.maxpro.util.MaxproHttpUtil;
import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.poll.BINPollable;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.nvideo.display.BDisplayDeviceExt;
import com.tridium.nvideo.dvr.BVideoDvr;
import com.tridium.nvideo.event.BVideoEventStatus;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.event.BVideoEvent;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="address", type="BAddress", defaultValue="new BMaxproIpAddress()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}, override=true), @NiagaraProperty(name="videoDeviceId", type="BVideoDeviceId", defaultValue="new BMaxproNvrId()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}, override=true), @NiagaraProperty(name="displays", type="BDisplayDeviceExt", defaultValue="new BDisplayDeviceExt()", flags=4, override=true), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.slow"), @NiagaraProperty(name="pollEventsEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="eventStreamId", type="String", defaultValue="", flags=5), @NiagaraProperty(name="readEventsFrom", type="BAbsTime", defaultValue="BAbsTime.now()"), @NiagaraProperty(name="eventReadCount", type="int", defaultValue="10", facets={@Facet(name="BFacets.MIN", value="BInteger.make(1)"), @Facet(name="BFacets.MAX", value="BInteger.make(100)")}), @NiagaraProperty(name="multistreamPreferences", type="BVideoSourcePreferences", defaultValue="new BMaxproMultistreamPreferences()", override=true), @NiagaraProperty(name="cameras", type="BCameraDeviceExt", defaultValue="new BMaxproCameraDeviceExt()", override=true), @NiagaraProperty(name="credentials", type="BUsernameAndPassword", defaultValue="new BUsernameAndPassword()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_UNSEEN)")})})
@NiagaraAction(name="activateUnsolicitedEvents", flags=4)
public class BMaxproNvr
extends BVideoDvr
implements BINPollable {
    public static final Property address = BMaxproNvr.newProperty((int)0, (BValue)new BMaxproIpAddress(), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property videoDeviceId = BMaxproNvr.newProperty((int)0, (BValue)new BMaxproNvrId(), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property displays = BMaxproNvr.newProperty((int)4, (BValue)new BDisplayDeviceExt(), null);
    public static final Property pollFrequency = BMaxproNvr.newProperty((int)0, (BValue)BPollFrequency.slow, null);
    public static final Property pollEventsEnabled = BMaxproNvr.newProperty((int)0, (boolean)false, null);
    public static final Property eventStreamId = BMaxproNvr.newProperty((int)5, (String)"", null);
    public static final Property readEventsFrom = BMaxproNvr.newProperty((int)0, (BValue)BAbsTime.now(), null);
    public static final Property eventReadCount = BMaxproNvr.newProperty((int)0, (int)10, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)100))));
    public static final Property multistreamPreferences = BMaxproNvr.newProperty((int)0, (BValue)new BMaxproMultistreamPreferences(), null);
    public static final Property cameras = BMaxproNvr.newProperty((int)0, (BValue)new BMaxproCameraDeviceExt(), null);
    public static final Property credentials = BMaxproNvr.newProperty((int)0, (BValue)new BUsernameAndPassword(), (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Action activateUnsolicitedEvents = BMaxproNvr.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BMaxproNvr.class);
    Array<BMaxproEventProxyExt> motion = new Array(BMaxproEventProxyExt.class);
    Array<BMaxproEventProxyExt> camFail = new Array(BMaxproEventProxyExt.class);
    public static final Logger maxpro_events_log = Logger.getLogger("Maxpro_Events");

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public boolean getPollEventsEnabled() {
        return this.getBoolean(pollEventsEnabled);
    }

    public void setPollEventsEnabled(boolean v) {
        this.setBoolean(pollEventsEnabled, v, null);
    }

    public String getEventStreamId() {
        return this.getString(eventStreamId);
    }

    public void setEventStreamId(String v) {
        this.setString(eventStreamId, v, null);
    }

    public BAbsTime getReadEventsFrom() {
        return (BAbsTime)this.get(readEventsFrom);
    }

    public void setReadEventsFrom(BAbsTime v) {
        this.set(readEventsFrom, (BValue)v, null);
    }

    public int getEventReadCount() {
        return this.getInt(eventReadCount);
    }

    public void setEventReadCount(int v) {
        this.setInt(eventReadCount, v, null);
    }

    public BUsernameAndPassword getCredentials() {
        return (BUsernameAndPassword)this.get(credentials);
    }

    public void setCredentials(BUsernameAndPassword v) {
        this.set(credentials, (BValue)v, null);
    }

    public void activateUnsolicitedEvents() {
        this.invoke(activateUnsolicitedEvents, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="R", transports={@Transport(type=TransportType.fox)})
    public String getPasswordRpc(Context cx) throws Exception {
        BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        if (!((BMaxproNetwork)this.getNetwork()).getHttpConfig().getUseTls() && webService.getRequireHttpsForPasswords()) {
            if (maxpro_events_log.isLoggable(Level.FINE)) {
                maxpro_events_log.fine("HTTPS connection required for sending password over HTTP");
            }
            throw new Exception("HTTPS connection required for sending password over HTTP");
        }
        return AccessController.doPrivileged(() -> ((BPassword)this.getCredentials().getPassword()).getValue());
    }

    public void descendantsStarted() throws Exception {
        ((BMaxproNetwork)this.getNetwork()).getPoll().subscribe((BIPollable)this);
        super.started();
    }

    public void stopped() throws Exception {
        ((BMaxproNetwork)this.getNetwork()).getPoll().unsubscribe((BIPollable)this);
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
    }

    public void doPing() {
        try {
            JSONObject identifier = MaxproHttpUtil.getAllRecordersConfiguration(this.hcomm(), this);
            ((BMaxproNvrId)this.getVideoDeviceId()).setId(JSONUtil.getString((JSONObject)identifier, (String)"id"));
            this.pingOk();
        }
        catch (Exception e) {
            this.pingFail(e.getLocalizedMessage());
        }
    }

    public Type getVideoCameraType() {
        return BMaxproCamera.TYPE;
    }

    public Type getNetworkType() {
        return BMaxproNetwork.TYPE;
    }

    public BIpAddress httpAddress() {
        return ((BMaxproIpAddress)this.getAddress()).httpAddress();
    }

    public HttpComm hcomm() throws Exception {
        return ((BMaxproNetwork)this.getNetwork()).hcomm();
    }

    public void streamToDestination(BPlaybackParams playbackParams, IVideoDestination videoDestination) {
    }

    public void doPoll() {
        if (!this.getPollEventsEnabled()) {
            return;
        }
        if (!this.isRunning()) {
            if (maxpro_events_log.isLoggable(Level.FINE)) {
                maxpro_events_log.fine("Maxpro NVR is not RUNNING.");
            }
            return;
        }
        try {
            if (this.getEventStreamId().equalsIgnoreCase("")) {
                String strStreamId;
                if (maxpro_events_log.isLoggable(Level.FINE)) {
                    maxpro_events_log.fine("Event StreamID is NULL. Reading the Event Stream ID");
                }
                if ((strStreamId = this.createEventStream()) == null || strStreamId.equalsIgnoreCase("")) {
                    maxpro_events_log.severe("Invalid Event Stream ID");
                    return;
                }
            }
            String params = "";
            if (this.getReadEventsFrom() == BAbsTime.NULL) {
                params = "count=" + this.getEventReadCount();
            } else {
                BAbsTime startTime = this.getReadEventsFrom();
                String strStartTime = startTime.encodeToString();
                strStartTime = startTime.toUtcTime().encodeToString();
                strStartTime = strStartTime.substring(0, 19) + "Z";
                params = "lastTime=\"" + strStartTime + "\"&count=" + this.getEventReadCount();
            }
            if (maxpro_events_log.isLoggable(Level.FINE)) {
                maxpro_events_log.fine("Reading Events with params : " + params);
            }
            JSONArray eventList = MaxproHttpUtil.readEvents(this.hcomm(), this, params);
            if (maxpro_events_log.isLoggable(Level.FINE)) {
                maxpro_events_log.fine("Received Events List from NVR : " + eventList.toString());
            }
            BIVideoCamera[] cameras = this.getCameras().getAllCameras();
            for (int i = 0; i < cameras.length; ++i) {
                BMaxproCamera maxproCamera = (BMaxproCamera)cameras[i];
                int cameraID = ((BMaxproCameraDeviceId)maxproCamera.getVideoDeviceId()).getCameraId();
                BVideoEvent[] ves = MaxproHttpUtil.parseEventsResponse(eventList, cameraID);
                if (maxpro_events_log.isLoggable(Level.FINE)) {
                    maxpro_events_log.fine("Events Received for Camera ID:" + cameraID + " are " + ves.length);
                }
                BMaxproEventCameraExt eventExt = (BMaxproEventCameraExt)maxproCamera.getEvents();
                BControlPoint[] eventPoints = eventExt.getPoints();
                for (int cameraPointIndex = 0; cameraPointIndex < eventPoints.length; ++cameraPointIndex) {
                    BMaxproEventProxyExt eventProxy = (BMaxproEventProxyExt)eventPoints[cameraPointIndex].getProxyExt();
                    if (eventProxy.getMaxproEventTypeEnum() != BMaxproEventTypesEnum.motionDetected) continue;
                    for (int k = 0; k < ves.length; ++k) {
                        BVideoEvent videoEvent;
                        String strDescription = ves[k].getDescription();
                        BAbsTime eventTime = ves[k].getTimestamp();
                        BMaxproAlarmExt alarmExt = ((BMaxproAlarmExt[])eventPoints[cameraPointIndex].getChildren(BMaxproAlarmExt.class))[0];
                        if (strDescription.equalsIgnoreCase("Camera Motion Started")) {
                            videoEvent = BVideoEvent.makeMotionStarted();
                            videoEvent.setTimestamp(eventTime);
                            eventProxy.readOk((BStatusValue)new BVideoEventStatus(videoEvent));
                            if (alarmExt != null) {
                                if (maxpro_events_log.isLoggable(Level.FINE)) {
                                    maxpro_events_log.fine("Creating Alarm for " + strDescription + " with timestamp:" + eventTime.toString());
                                }
                                alarmExt.setAlarmTime(eventTime);
                                alarmExt.invoke(BMaxproAlarmExt.triggerAlarm, null, null);
                            }
                        } else if (strDescription.equalsIgnoreCase("Camera Motion Stopped")) {
                            videoEvent = BVideoEvent.makeMotionStopped();
                            videoEvent.setTimestamp(eventTime);
                            eventProxy.readOk((BStatusValue)new BVideoEventStatus(videoEvent));
                            if (alarmExt != null) {
                                if (maxpro_events_log.isLoggable(Level.FINE)) {
                                    maxpro_events_log.fine("Creating Alarm for " + strDescription + " with timestamp:" + eventTime.toString());
                                }
                                alarmExt.setAlarmTime(eventTime);
                                alarmExt.invoke(BMaxproAlarmExt.triggerAlarm, null, null);
                            }
                        }
                        if (!this.getReadEventsFrom().isBefore(eventTime)) continue;
                        this.setReadEventsFrom(eventTime);
                    }
                }
            }
        }
        catch (Exception e) {
            maxpro_events_log.log(Level.SEVERE, "Read Events Failed", e);
        }
    }

    public String createEventStream() throws Exception {
        JSONObject configStream = MaxproHttpUtil.createEventStream(this.hcomm(), this.httpAddress(), this);
        String strStreamId = JSONUtil.getString((JSONObject)configStream, (String)"id");
        this.setEventStreamId(strStreamId);
        return strStreamId;
    }

    public void registerEventProxy(BMaxproEventProxyExt ext, BMaxproEventTypesEnum e) {
        if (e == BMaxproEventTypesEnum.motionDetected) {
            this.motion.add((Object)ext);
        }
        if (e == BMaxproEventTypesEnum.cameraFail) {
            this.camFail.add((Object)ext);
        }
    }

    public void unregisterEventProxy(BMaxproEventProxyExt ext, BMaxproEventTypesEnum e) {
        if (e == BMaxproEventTypesEnum.motionDetected) {
            this.motion.remove((Object)ext);
        }
        if (e == BMaxproEventTypesEnum.cameraFail) {
            this.camFail.remove((Object)ext);
        }
    }

    public void doActivateUnsolicitedEvents() {
    }

    public void initPlaybackParams(BPlaybackParams playbackParams, IVideoSession videoSession) {
    }

    public IVideoDecoder makeVideoDecoder(BPlaybackParams playbackParams) {
        return null;
    }

    public boolean supportsMultistream() {
        return false;
    }
}

