/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.maxpro.event;

import com.tridium.driver.util.DrUtil;
import com.tridium.json.JSONArray;
import com.tridium.maxpro.camera.BMaxproCamera;
import com.tridium.maxpro.camera.BMaxproCameraDeviceId;
import com.tridium.maxpro.nvr.BMaxproNvr;
import com.tridium.maxpro.util.MaxproHttpUtil;
import com.tridium.videoDriver.event.BRetrieveActionParam;
import com.tridium.videoDriver.event.BVideoEvent;
import com.tridium.videoDriver.event.BVideoEventRecall;
import java.util.logging.Level;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BMaxproVideoEventRecall
extends BVideoEventRecall {
    public static final Type TYPE = Sys.loadType(BMaxproVideoEventRecall.class);

    public Type getType() {
        return TYPE;
    }

    public void doRetrieveEvents(BRetrieveActionParam param) {
        BMaxproCamera camera = (BMaxproCamera)DrUtil.getParent((BComplex)this, (Type)BMaxproCamera.TYPE);
        int cameraID = ((BMaxproCameraDeviceId)camera.getVideoDeviceId()).getCameraId();
        BMaxproNvr nvr = camera.getMaxproDvr();
        try {
            if (nvr.getEventStreamId().equalsIgnoreCase("")) {
                String strStreamId;
                if (BMaxproNvr.maxpro_events_log.isLoggable(Level.FINE)) {
                    BMaxproNvr.maxpro_events_log.fine("Event StreamID is NULL. Reading the Event Stream ID");
                }
                if ((strStreamId = nvr.createEventStream()) == null || strStreamId.equalsIgnoreCase("")) {
                    BMaxproNvr.maxpro_events_log.severe("Invalid Event Stream ID");
                    return;
                }
            }
            String params = "";
            params = "q=(entityType=\"DeviceMgmt/Cameras\"&entityId=\"" + cameraID + "\")&count=" + nvr.getEventReadCount();
            JSONArray eventList = MaxproHttpUtil.readEvents(nvr.hcomm(), nvr, params);
            if (BMaxproNvr.maxpro_events_log.isLoggable(Level.FINE)) {
                BMaxproNvr.maxpro_events_log.fine("Received Events List from NVR : " + eventList.toString());
            }
            BVideoEvent[] ves = MaxproHttpUtil.parseEventsResponse(eventList, cameraID);
            if (BMaxproNvr.maxpro_events_log.isLoggable(Level.FINE)) {
                BMaxproNvr.maxpro_events_log.fine("Events Received for Camera ID:" + cameraID + " are " + ves.length);
            }
            this.eventListRetrieved(ves, param);
        }
        catch (Exception e) {
            BMaxproNvr.maxpro_events_log.log(Level.SEVERE, "Read Events Failed", e);
        }
    }
}

