/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.maxpro.camera;

import com.tridium.driver.util.DrUtil;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.maxpro.BMaxproNetwork;
import com.tridium.maxpro.camera.BMaxproCameraDiscoveryLeaf;
import com.tridium.maxpro.camera.BMaxproCameraDiscoveryPreferences;
import com.tridium.maxpro.nvr.BMaxproNvr;
import com.tridium.maxpro.util.MaxproHttpUtil;
import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.nvideo.camera.BCameraDeviceExt;
import java.util.logging.Level;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="discoveryPreferences", type="BMaxproCameraDiscoveryPreferences", defaultValue="new BMaxproCameraDiscoveryPreferences()", override=true)
public class BMaxproCameraDeviceExt
extends BCameraDeviceExt {
    public static final Property discoveryPreferences = BMaxproCameraDeviceExt.newProperty((int)0, (BValue)new BMaxproCameraDiscoveryPreferences(), null);
    public static final Type TYPE = Sys.loadType(BMaxproCameraDeviceExt.class);

    public Type getType() {
        return TYPE;
    }

    public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) throws Exception {
        Array discoveredCameras = new Array(BMaxproCameraDiscoveryLeaf.class);
        BMaxproNvr dvr = (BMaxproNvr)this.getParent();
        BMaxproNetwork net = (BMaxproNetwork)DrUtil.getParent((BComplex)this, (Type)BMaxproNetwork.TYPE);
        try {
            HttpComm hcom = net.hcomm();
            if (MaxproHttpUtil.maxpro_log.isLoggable(Level.FINE)) {
                MaxproHttpUtil.maxpro_log.fine("Get All Cameras Configuration Request");
            }
            JSONArray cameraConfig = MaxproHttpUtil.getAllCamerasConfiguration(hcom, dvr);
            if (MaxproHttpUtil.maxpro_log.isLoggable(Level.FINE)) {
                MaxproHttpUtil.maxpro_log.fine("Get All Cameras Configuration Response : " + cameraConfig.toString());
            }
            for (int i = 0; i < cameraConfig.length(); ++i) {
                BMaxproCameraDiscoveryLeaf newLeaf = new BMaxproCameraDiscoveryLeaf();
                newLeaf.getId().setCameraId(Integer.parseInt(JSONUtil.getString((JSONObject)cameraConfig.getJSONObject(i).getJSONObject("identifiers"), (String)"id")));
                newLeaf.getId().setDescription(JSONUtil.getString((JSONObject)cameraConfig.getJSONObject(i).getJSONObject("identifiers"), (String)"name"));
                discoveredCameras.add((Object)newLeaf);
            }
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Unable to discover cameras in " + dvr.getDisplayName(null), (Throwable)e);
        }
        return (BINDiscoveryObject[])discoveredCameras.trim();
    }
}

