/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platBacnet;

import com.tridium.platBacnet.BBacnetEthernetPlatformService;
import com.tridium.platBacnet.BacnetEthernetAdapter;
import com.tridium.platBacnet.BacnetEthernetAdapterNpsdk;
import com.tridium.platBacnet.EthernetFilter;
import java.io.File;
import java.security.AccessController;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetEthernetPlatformServiceNpsdk
extends BBacnetEthernetPlatformService {
    public static final Type TYPE = Sys.loadType(BBacnetEthernetPlatformServiceNpsdk.class);
    private static final String PCAP_IS_MISSING = lex.getText("npsdkpcap.is.missing");
    private static final String PCAP_ADAPTER_PREFIX = "rpcap://";

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        String ethernetlibPath = Sys.getNiagaraHome() + File.separator + "bin" + File.separator + "libplatethernet.so";
        return AccessController.doPrivileged(() -> new File(ethernetlibPath).exists());
    }

    @Override
    protected boolean loadLibraries() {
        if (this.nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                log.fine("Loading ether native library");
                System.loadLibrary("platethernet");
                log.fine("Loaded ether native library");
                this.nativesLoaded = true;
            }
            catch (UnsatisfiedLinkError ule) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Failed to load ether native library", ule);
                }
                throw new BajaRuntimeException(PCAP_IS_MISSING);
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Cannot load ether native library", e);
            }
            return this.nativesLoaded;
        });
    }

    @Override
    public BacnetEthernetAdapter openAdapter(String adapterName, EthernetFilter etherType) {
        return new BacnetEthernetAdapterNpsdk(adapterName, etherType);
    }

    @Override
    protected void queryForAdapters(Vector<String> adapterTitles, Vector<String> adapterDescriptions, Vector<String> adapterNames) throws Exception {
        BacnetEthernetAdapterNpsdk.queryForAdapters(adapterTitles, adapterDescriptions, adapterNames);
        for (int i = 0; i < adapterNames.size(); ++i) {
            String adapterName = adapterNames.get(i);
            if (adapterName == null || !adapterName.startsWith(PCAP_ADAPTER_PREFIX)) continue;
            String newAdapterName = adapterName.substring(PCAP_ADAPTER_PREFIX.length());
            adapterNames.setElementAt(newAdapterName, i);
        }
    }
}

