/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.message.roomguest;

import com.tridiumemea.micros.datatype.BMicrosGuestData;
import com.tridiumemea.micros.datatype.BMicrosRoomRights;
import com.tridiumemea.micros.enums.BMicrosRoomEquipmentServiceEnum;
import com.tridiumemea.micros.message.roomguest.MicrosGuestEventNotification;
import com.tridiumemea.micros.point.BMicrosProxyExt;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BatchSetException;

public interface MicrosGuest {

    public static interface Departure {
        default public void preArrivalDepartureLogic(BMicrosProxyExt proxyExt, boolean isDeparturePolicyReset) {
            if (isDeparturePolicyReset) {
                Departure.resetRoomEquipment(proxyExt);
            } else {
                proxyExt.updateRoomEquipmentStatus();
            }
        }

        default public void resetRoomRights(BMicrosProxyExt proxyExt) {
            proxyExt.updateData(new BMicrosRoomRights());
        }

        public static void resetRoomEquipment(BMicrosProxyExt proxyExt) {
            BStatusEnum newValue = new BStatusEnum((BEnum)BMicrosRoomEquipmentServiceEnum.DEFAULT, BStatus.stale);
            proxyExt.setPreArrival(newValue);
        }
    }

    public static interface Data {
        default public void handleGuestData(MicrosGuestEventNotification msg) {
            if (msg.net.getLinkConfig().getEnableGuestData()) {
                msg.getProxy().updateData(SUPPORT.extractGuestData(msg));
            }
        }

        public static final class SUPPORT {
            static final String[] guestFields = new String[]{"GT", "GF", "GN", "GL", "GV"};
            private static final String guestLicenseFeature = "guest.data";
            private static Boolean licensed;
            private static final String FAILED_SETTING_GUEST_DATA_PROPERTY = "Failed setting guest data property ";

            private static synchronized BMicrosGuestData extractGuestData(MicrosGuestEventNotification msg) {
                Logger logger = msg.net.log();
                if (licensed == null) {
                    licensed = msg.net.getDevice().getPoints().isGuestDataLicensed();
                }
                BMicrosGuestData guestData = new BMicrosGuestData();
                if (licensed.booleanValue()) {
                    BSimple[] values = new BSimple[guestFields.length + 1];
                    values[0] = BStatus.ok;
                    for (int y = 1; y < guestFields.length + 1; ++y) {
                        BString newValue = BString.DEFAULT;
                        try {
                            newValue = BString.make((String)msg.get(guestFields[y - 1]).getData().toString());
                        }
                        catch (IllegalArgumentException e) {
                            String err = "Error extracting guest data getRecord " + guestFields[y - 1] + " : " + msg + '.';
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, err, e);
                            }
                            logger.log(Level.INFO, err);
                        }
                        values[y] = newValue;
                    }
                    try {
                        guestData.set(guestData.getFrozenPropertiesArray(), (BValue[])values, null);
                    }
                    catch (BatchSetException be) {
                        logger.log(Level.WARNING, "Batch set of guest data failed ", be);
                        boolean faultEncountered = false;
                        for (int x = 0; x < guestData.getFrozenPropertiesArray().length; ++x) {
                            try {
                                guestData.set(guestData.getFrozenPropertiesArray()[x], (BValue)values[x]);
                                continue;
                            }
                            catch (RuntimeException e) {
                                String currentProp = guestData.getFrozenPropertiesArray()[x].getName();
                                faultEncountered = true;
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, FAILED_SETTING_GUEST_DATA_PROPERTY + currentProp, e);
                                    continue;
                                }
                                logger.log(Level.INFO, FAILED_SETTING_GUEST_DATA_PROPERTY + currentProp);
                            }
                        }
                        guestData.setStatus(faultEncountered ? BStatus.fault : BStatus.ok);
                    }
                } else {
                    logger.log(Level.WARNING, "Received guest data whilst not licensed, \"microsFidelio\" : \"guest.data\".");
                    guestData.setStatus(BStatus.fault);
                }
                return guestData;
            }
        }
    }
}

