/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.datatype;

import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridiumemea.micros.comm.exception.MicrosInvalidIpAddressException;
import com.tridiumemea.micros.comm.exception.MicrosInvalidPortException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BMicrosIpAddress
extends BIpAddress {
    public static final Type TYPE = Sys.loadType(BMicrosIpAddress.class);
    private static final BIcon ICON = BIcon.std((String)"gears.png");
    protected static final BMicrosIpAddress DEFAULT = new BMicrosIpAddress("127.0.0.1", 5001);

    public Type getType() {
        return TYPE;
    }

    public BMicrosIpAddress() {
    }

    public BMicrosIpAddress(String s, int i) {
        super(s, i);
    }

    public boolean isEqualAddress(BMicrosIpAddress compareTo) {
        boolean ipEqual = this.getIpAddress().equalsIgnoreCase(compareTo.getIpAddress());
        boolean portEqual = this.getPort() == compareTo.getPort();
        return ipEqual & portEqual;
    }

    public void verify(Logger log) throws UnknownHostException {
        try {
            this.checkPort();
            this.checkIpAddress();
            this.checkHost();
        }
        catch (MicrosInvalidIpAddressException | MicrosInvalidPortException | UnknownHostException e) {
            if (log != null) {
                log.log(Level.WARNING, "Not attempting connection to host: " + this.toString(), (Throwable)e);
                if (log.isLoggable(Level.FINE)) {
                    ((Throwable)e).printStackTrace();
                }
            }
            throw e;
        }
    }

    private void checkPort() {
        if (this.getPort() < 1) {
            throw new MicrosInvalidPortException(Integer.toString(this.getPort()));
        }
    }

    private void checkIpAddress() {
        if (this.getIpAddress().isEmpty()) {
            throw new MicrosInvalidIpAddressException("Empty Address Field");
        }
    }

    private void checkHost() throws UnknownHostException {
        InetAddress.getByName(this.getIpAddress());
    }

    public BIcon getIcon() {
        return ICON;
    }
}

