/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.comm.protocol;

import com.tridium.ndriver.comm.NMessage;
import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.comm.BMicrosListener;
import com.tridiumemea.micros.comm.exception.MicrosLinkNegotiationException;
import com.tridiumemea.micros.comm.flag.MicrosMessageFlag;
import com.tridiumemea.micros.comm.protocol.SocketHandshakeUtil;
import com.tridiumemea.micros.enums.BMicrosLinkStatusEnum;
import com.tridiumemea.micros.message.MicrosMessage;
import com.tridiumemea.micros.message.linkup.MicrosLinkStartRequest;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.sys.Clock;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public class LinkPingUtil {
    private final BMicrosNetwork net;
    private Logger log;
    private SocketHandshakeUtil sockUtil;
    private boolean readFailure;
    private boolean readOk;
    private final Object pingLock = new Object();
    private static final Lexicon lex = Lexicon.make(BMicrosNetwork.class);
    private static final String LS_NO_RESPONSE = lex.getText("microsNetwork.commErrLsNoResponse");
    private static final String COULD_NOT_SEND_PING_LS = "Error sending ping LS: ";
    private static final String RECEIVED_EXPECTED = "Received expected Link Alive [LA] response from Micros.";

    public LinkPingUtil(BMicrosNetwork network) {
        Objects.requireNonNull(network);
        this.net = network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ping() {
        if (!this.net.isRunning()) {
            throw new NotRunningException("Network is not running, cannot ping");
        }
        if (this.sockUtil == null) {
            this.sockUtil = this.net.getSockUtil();
        }
        if (this.log == null) {
            this.log = this.net.log();
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(() -> "Ping called. (commInhibit: " + this.sockUtil.isCommInhibitFlag() + ", socketHandshakeRequired: " + this.sockUtil.isSocketHandshakeRequired() + ')');
            this.log.log(Level.FINEST, "Debug Only", new Exception("Ping Call Stack"));
        }
        try {
            this.net.getLicenseFeature().check();
        }
        catch (FeatureNotLicensedException | LicenseDatabaseException lic) {
            this.log.log(Level.WARNING, lic.getLocalizedMessage(), lic);
            this.net.getDevice().pingFail(lic.getLocalizedMessage());
            throw lic;
        }
        if (this.net.isDisabled() || this.net.isFatalFault() || this.net.getLinkStatus().isLinkActivating()) {
            String abortReason = "LinkPingUtil: Cannot proceed with ping whilst disabled, fatal fault, or activating";
            this.log.info(abortReason);
            this.net.getDevice().pingFail(abortReason);
            return;
        }
        if (this.net.getDsUtil().isCachedJobAlive()) {
            this.net.getDevice().pingOk();
            return;
        }
        this.log.finer("Ping allowed to proceed");
        if (this.sockUtil.isSocketHandshakeRequired()) {
            Object abortReason = this.getPingLock();
            synchronized (abortReason) {
                this.setReadOk(false);
                this.readFailure = false;
                try {
                    this.sockUtil.socketHandshake();
                }
                catch (Exception e) {
                    this.readFailure = true;
                }
                long timeoutTicks = Clock.ticks() + this.net.getLinkConfig().getMsgResponseTimeout().getMillis();
                while (!this.isReadOk() && !this.isReadFailure() && Clock.ticks() < timeoutTicks) {
                    try {
                        this.getPingLock().wait(500L);
                    }
                    catch (InterruptedException ie) {
                        if (Sys.getStation().isRunning()) continue;
                        return;
                    }
                }
                if (this.isReadFailure()) {
                    this.log.finest("LinkPingUtil:Detected Read Failure");
                    this.net.getShutdownUtil().commonLinkDownSteps("Connectivity Issue: Socket Connection Failed");
                }
            }
        }
        if (!this.sockUtil.isCommInhibitFlag()) {
            MicrosMessage response = this.sendLinkStartRequest();
            this.examineResponseToLS(response);
        } else {
            this.log.info("doPing: commInhibit Flag Prevents Outward Communication");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MicrosMessage sendLinkStartRequest() {
        MicrosLinkStartRequest msg = new MicrosLinkStartRequest(this.net.getDevice().getAddress());
        BMicrosListener listener = this.net.getEventListener();
        this.log.fine("Sending LS");
        listener.factoryFlags.raise(MicrosMessageFlag.Flag.LINK_MSG);
        try {
            this.net.getTcpConfig().checkAndFormatMsg(msg);
            MicrosMessage microsMessage = (MicrosMessage)this.net.getTcpConfig().tcomm().sendRequest((NMessage)msg);
            return microsMessage;
        }
        catch (Exception sendFail) {
            this.log.log(Level.WARNING, COULD_NOT_SEND_PING_LS, sendFail);
        }
        finally {
            listener.factoryFlags.lower(MicrosMessageFlag.Flag.LINK_MSG);
        }
        return null;
    }

    private void examineResponseToLS(MicrosMessage serverResponse) {
        String response;
        String string = response = serverResponse != null ? serverResponse.getRecordID() : "null";
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("doPing: Server replied with: " + response);
        }
        switch (response) {
            case "LA": {
                this.reportLinkActiveSuccess();
                break;
            }
            case "LS": {
                this.net.getActivationUtil().sendSequence();
                break;
            }
            default: {
                this.net.getShutdownUtil().commonLinkDownSteps(LS_NO_RESPONSE + response);
                throw new MicrosLinkNegotiationException(LS_NO_RESPONSE + response);
            }
        }
    }

    void reportLinkActiveSuccess() {
        this.net.log().fine(RECEIVED_EXPECTED);
        this.net.setLinkStatus(BMicrosLinkStatusEnum.active);
        this.net.getDevice().pingOk();
    }

    public Object getPingLock() {
        return this.pingLock;
    }

    private boolean isReadFailure() {
        return this.readFailure;
    }

    private boolean isReadOk() {
        return this.readOk;
    }

    public void setReadOk(boolean readOk) {
        this.readOk = readOk;
    }
}

