/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.driver;

import java.util.ArrayList;
import java.util.Set;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.BForEachDeviceStage;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.JobCancelException;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BDeviceJobStep
extends BJobStep {
    public static final Type TYPE = Sys.loadType(BDeviceJobStep.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public void prepareStep(BObject target) throws Exception {
    }

    protected BDeviceStepDetails makeDetails(BDevice device) {
        BDeviceStepDetails result = new BDeviceStepDetails(device, this);
        this.add(SlotPath.escape((String)device.getName()), (BValue)result, 4);
        return result;
    }

    @Override
    public BJobStepDetails[] getJobStepDetails() {
        ArrayList<BJobStepDetails> result = new ArrayList<BJobStepDetails>();
        SlotCursor cr = this.getProperties();
        while (cr.next(BJobStepDetails.class)) {
            result.add((BJobStepDetails)cr.get());
        }
        return result.toArray(new BJobStepDetails[result.size()]);
    }

    public final BDeviceStepDetails run(BBatchJobService svc, BDevice device, DeviceNetworkJobOp op) {
        BDeviceStepDetails stepDetails = null;
        try {
            stepDetails = this.makeDetails(device);
            this.checkCanceled(device);
            this.doRun(svc, stepDetails, device, op);
            this.checkCanceled(device);
            if (stepDetails.getState().isRunning()) {
                stepDetails.success();
            }
            return stepDetails;
        }
        catch (JobCancelException jce) {
            if (stepDetails != null) {
                stepDetails.canceled();
            }
            return stepDetails;
        }
        catch (Throwable e) {
            if (stepDetails != null) {
                stepDetails.failed(e);
            }
            return stepDetails;
        }
    }

    protected void doInit(BBatchJobService svc, DeviceNetworkJobOp op) throws Exception {
    }

    protected abstract void doRun(BBatchJobService var1, BDeviceStepDetails var2, BDevice var3, DeviceNetworkJobOp var4) throws Exception;

    public boolean canCombine(BDeviceJobStep step) {
        return false;
    }

    public void combine(BDeviceJobStep step) {
        throw new IllegalStateException();
    }

    public boolean isCanceled() {
        return this.getJob().isCanceled();
    }

    public void deviceJobStepComplete(BDeviceStepDetails details, DeviceNetworkJobOp op) {
        this.stepComplete(details, op);
    }

    public void deviceNetworkJobComplete(DeviceNetworkJobOp op) {
        this.jobComplete(op);
    }

    @Override
    public BBatchJob getJob() {
        return this.getStage().getJob();
    }

    @Override
    public BJobStage getStage() {
        BComplex p;
        for (p = this.getParent(); p != null && !(p instanceof BJobStage); p = p.getParent()) {
        }
        return (BJobStage)p;
    }

    public BForEachDeviceStage getForEachDeviceStage() {
        return (BForEachDeviceStage)this.getStage();
    }

    protected void checkCanceled(BDevice device) {
        BSimple deviceId = BNetworkBatchAgent.get(this.getForEachDeviceStage().getNetwork(), null).getBatchDeviceId(device);
        this.getForEachDeviceStage().checkCanceled(deviceId);
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return allDevices;
    }
}

