/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob;

import com.tridium.batchJob.BLocalTimeUtil;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.BJobStep;
import javax.baja.file.BIFile;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;

public abstract class BJobStepDetails
extends BComponent {
    public static final Property stageName = BJobStepDetails.newProperty((int)1, (String)"", null);
    public static final Property stepType = BJobStepDetails.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    public static final Property stepDescription = BJobStepDetails.newProperty((int)1, (String)"", null);
    public static final Property state = BJobStepDetails.newProperty((int)1, (BValue)BJobState.running, null);
    public static final Property startTime = BJobStepDetails.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property endTime = BJobStepDetails.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Action readLog = BJobStepDetails.newAction((int)0, null);
    public static final Action cancel = BJobStepDetails.newAction((int)4, null);
    public static final Action dispose = BJobStepDetails.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BJobStepDetails.class);
    protected BJobStep step = null;
    protected JobLog log = null;
    protected BTimeZone startTimeLocalTz = BTimeZone.NULL;

    public String getStageName() {
        return this.getString(stageName);
    }

    public void setStageName(String v) {
        this.setString(stageName, v, null);
    }

    public BTypeSpec getStepType() {
        return (BTypeSpec)this.get(stepType);
    }

    public void setStepType(BTypeSpec v) {
        this.set(stepType, (BValue)v, null);
    }

    public String getStepDescription() {
        return this.getString(stepDescription);
    }

    public void setStepDescription(String v) {
        this.setString(stepDescription, v, null);
    }

    public BJobState getState() {
        return (BJobState)this.get(state);
    }

    public void setState(BJobState v) {
        this.set(state, (BValue)v, null);
    }

    public BAbsTime getStartTime() {
        return (BAbsTime)this.get(startTime);
    }

    public void setStartTime(BAbsTime v) {
        this.set(startTime, (BValue)v, null);
    }

    public BAbsTime getEndTime() {
        return (BAbsTime)this.get(endTime);
    }

    public void setEndTime(BAbsTime v) {
        this.set(endTime, (BValue)v, null);
    }

    public BString readLog() {
        return (BString)this.invoke(readLog, null, null);
    }

    public void cancel() {
        this.invoke(cancel, null, null);
    }

    public void dispose() {
        this.invoke(dispose, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BJobStepDetails() {
    }

    public BJobStepDetails(BJobStep jobStep) {
        this.setStepType(jobStep.getType().getTypeSpec());
        this.setStartTime(BAbsTime.now());
        this.setStepDescription(jobStep.toString(null));
        this.setStageName(jobStep.getStage().getStageName());
        this.step = jobStep;
        this.log = new JobLog();
    }

    public BJobStep getStep() {
        return this.step;
    }

    public BBatchJob getJob() {
        return this.step == null ? null : this.step.getJob();
    }

    public BJobStage getStage(BBatchJob job) {
        return this.step == null ? job.getStage(this.getStageName()) : this.step.getStage();
    }

    public BJobStage getStage() {
        return this.step == null ? null : this.step.getStage();
    }

    public abstract BString doReadLog() throws Exception;

    public abstract void doCancel() throws Exception;

    public void doDispose() throws Exception {
        BBatchJobService svc = (BBatchJobService)Sys.getService((Type)BBatchJobService.TYPE);
        svc.getJobSummaryManager().disposeStepSummary(this.getStepType().getResolvedType(), this.getStartTime());
    }

    public void success() {
        this.success("batchJob", "JobStepDetails.success");
        this.complete(BJobState.success);
    }

    public void failed(Throwable cause) {
        this.failed("batchJob", "JobStepDetails.failed", this.getStepDescription(), cause);
        this.complete(BJobState.failed);
    }

    public void canceled() {
        this.log.add(new JobLogItem(2, "batchJob", "JobStepDetails.canceled", new String[]{this.getStepDescription()}));
        this.getJob().log().add(new JobLogItem(2, "batchJob", "JobStepDetails.canceled", new String[]{this.getStepDescription()}));
        this.complete(BJobState.canceled);
    }

    public void complete(BJobState state) {
        if (!state.isComplete()) {
            throw new IllegalArgumentException("Cannot complete as " + state);
        }
        this.setState(state);
        this.setEndTime(Clock.time());
        try {
            BBatchJobService svc = (BBatchJobService)Sys.getService((Type)BBatchJobService.TYPE);
            svc.getJobSummaryManager().write(svc.getJobSummaryManager().makeStepSummary(this, this.getJob().getStartTime()));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public abstract void setLogFile(BIFile var1);

    public abstract BIFile getLogFile();

    public abstract BIFile findLogFile(BObject var1) throws Exception;

    public void start(String appendLexModule, String appendLexKey, String[] appendLexArgPatterns) {
        this.log.start(appendLexModule, appendLexKey, appendLexArgPatterns);
        this.getJob().log().start(appendLexModule, appendLexKey, appendLexArgPatterns);
    }

    public void start(String appendLexModule, String appendLexKey, String appendLexArgPattern) {
        this.log.start(appendLexModule, appendLexKey, new String[]{appendLexArgPattern});
        this.getJob().log().start(appendLexModule, appendLexKey, new String[]{appendLexArgPattern});
    }

    public void start(String appendLexModule, String appendLexKey) {
        this.log.start(appendLexModule, appendLexKey, null);
        this.getJob().log().start(appendLexModule, appendLexKey, null);
    }

    public void endSuccess(String appendLexModule, String appendLexKey, String[] appendLexArgPatterns) {
        this.log.endSuccess(appendLexModule, appendLexKey, appendLexArgPatterns);
        this.getJob().log().endSuccess(appendLexModule, appendLexKey, appendLexArgPatterns);
    }

    public void endSuccess() {
        this.log.endSuccess();
        this.getJob().log().endSuccess();
    }

    public void endFailed(String appendLexModule, String appendLexKey, String[] appendLexArgPatterns, Throwable exception) {
        this.log.endFailed(appendLexModule, appendLexKey, appendLexArgPatterns, exception);
        this.getJob().log().endFailed(appendLexModule, appendLexKey, appendLexArgPatterns, exception);
    }

    public void endFailed(Throwable exception) {
        this.log.endFailed(exception);
        this.getJob().log().endFailed(exception);
    }

    public void endFailed(String appendLexModule, String appendLexKey, String[] appendLexArgPatterns) {
        this.log.endFailed(appendLexModule, appendLexKey, appendLexArgPatterns);
        this.getJob().log().endFailed(appendLexModule, appendLexKey, appendLexArgPatterns);
    }

    public void end(int id, String appendLexModule, String appendLexKey, String[] appendLexArgPatterns, Throwable exception) {
        this.log.end(id, appendLexModule, appendLexKey, appendLexArgPatterns, exception);
        this.getJob().log().end(id, appendLexModule, appendLexKey, appendLexArgPatterns, exception);
    }

    public void message(String msg) {
        this.log.message(msg);
        this.getJob().log().message(msg);
    }

    public void message(String lexModule, String lexKey, String[] lexArgPatterns) {
        this.log.message(lexModule, lexKey, lexArgPatterns);
        this.getJob().log().message(lexModule, lexKey, lexArgPatterns);
    }

    public void message(String lexModule, String lexKey, String lexArgPattern) {
        this.log.message(lexModule, lexKey, lexArgPattern);
        this.getJob().log().message(lexModule, lexKey, lexArgPattern);
    }

    public void message(String lexModule, String lexKey) {
        this.log.message(lexModule, lexKey);
        this.getJob().log().message(lexModule, lexKey);
    }

    public void vaMessage(String lexKey, String ... messageArgs) {
        this.message(this.getStepType().getModuleName(), lexKey, messageArgs);
    }

    public void success(String lexModule, String lexKey, String[] lexArgPatterns) {
        this.log.success(lexModule, lexKey, lexArgPatterns);
        this.getJob().log().success(lexModule, lexKey, lexArgPatterns);
    }

    public void success(String lexModule, String lexKey, String lexArgPattern) {
        this.log.success(lexModule, lexKey, lexArgPattern);
        this.getJob().log().success(lexModule, lexKey, lexArgPattern);
    }

    public void success(String lexModule, String lexKey) {
        this.log.success(lexModule, lexKey);
        this.getJob().log().success(lexModule, lexKey);
    }

    public void vaSuccess(String lexKey, String ... messageArgs) {
        this.success(this.getStepType().getModuleName(), lexKey, messageArgs);
    }

    public void failed(String lexModule, String lexKey, String[] lexArgPatterns, Throwable exception) {
        this.log.failed(lexModule, lexKey, lexArgPatterns, exception);
        this.getJob().log().failed(lexModule, lexKey, lexArgPatterns, exception);
    }

    public void failed(String lexModule, String lexKey, String lexArgPattern, Throwable exception) {
        this.log.failed(lexModule, lexKey, lexArgPattern, exception);
        this.getJob().log().failed(lexModule, lexKey, lexArgPattern, exception);
    }

    public void failed(String lexModule, String lexKey, Throwable exception) {
        this.log.failed(lexModule, lexKey, exception);
        this.getJob().log().failed(lexModule, lexKey, exception);
    }

    public void failed(String lexModule, String lexKey, String[] lexArgPatterns) {
        this.log.failed(lexModule, lexKey, lexArgPatterns);
        this.getJob().log().failed(lexModule, lexKey, lexArgPatterns);
    }

    public void failed(String lexModule, String lexKey, String lexArgPattern) {
        this.log.failed(lexModule, lexKey, lexArgPattern);
        this.getJob().log().failed(lexModule, lexKey, lexArgPattern);
    }

    public void failed(String lexModule, String lexKey) {
        this.log.failed(lexModule, lexKey);
        this.getJob().log().failed(lexModule, lexKey);
    }

    public void vaFailed(String lexKey, String ... messageArgs) {
        this.failed(this.getStepType().getModuleName(), lexKey, messageArgs);
    }

    public void add(JobLogItem item) {
        this.log.add(item);
        this.getJob().log().add(item);
    }

    public JobLog log() {
        return this.log;
    }

    public void resetLog() {
        this.log = null;
    }

    public String getFailureAlarmMessage(Context cx) {
        for (int i = this.log.size(); i > 0; --i) {
            JobLogItem item = this.log.getItem(i - 1);
            if (item.getId() != 4 && item.getId() != 2) continue;
            return item.toString(cx);
        }
        return "";
    }

    public void setDisplayTimeZone(BTimeZone displayTz) {
        if (this.isMounted()) {
            throw new IllegalStateException("cannot call setDisplayTimeZone on mounted details");
        }
        if (displayTz == null || displayTz.isNull()) {
            throw new IllegalArgumentException("displayTz cannot be null");
        }
        if (this.startTimeLocalTz.isNull()) {
            this.setStartTimeLocalZone(this.getStartTime().getTimeZone());
        }
        BLocalTimeUtil.updateAbsTimeZone(this, startTime, displayTz);
        BLocalTimeUtil.updateAbsTimeZone(this, endTime, displayTz);
    }

    public void setStartTimeLocalZone(BTimeZone localTz) {
        this.startTimeLocalTz = localTz;
    }

    public BAbsTime getLocalStartTime() {
        if (this.startTimeLocalTz.isNull() && this.getSession() != null) {
            try {
                BComponent systemPlatformService = (BComponent)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)this);
                systemPlatformService.lease();
                this.setStartTimeLocalZone((BTimeZone)systemPlatformService.get("timeZone"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.startTimeLocalTz.isNull()) {
            return this.getStartTime();
        }
        return BLocalTimeUtil.getAdjustedTimeZone(this.getStartTime(), this.startTimeLocalTz);
    }
}

