/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.history;

import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.BBatchJobStepLogFile;
import com.tridium.batchJob.TZFixedHistoryCollectionsCursor;
import com.tridium.batchJob.history.BBatchJobHistoryRecord;
import com.tridium.batchJob.history.BJobStepHistoryRecord;
import com.tridium.bql.query.BBqlEngine;
import java.security.AccessController;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BIBatchJobSummary;
import javax.baja.batchJob.BIJobStepSummary;
import javax.baja.batchJob.BIJobSummaryManager;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.collection.AbstractCursor;
import javax.baja.collection.TableCursor;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.history.BCapacity;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Cursor;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class BHistoryJobSummaryManager
extends BComponent
implements BIJobSummaryManager {
    public static final Type TYPE = Sys.loadType(BHistoryJobSummaryManager.class);
    protected Object writeLock = new Object();
    private CompletableFuture<Void> whenStarted = new CompletableFuture();
    private static final Logger logger = Logger.getLogger("batchJob");

    public Type getType() {
        return TYPE;
    }

    @Override
    public BIBatchJobSummary makeJobSummary(BBatchJob job) {
        TypeInfo historyType = BHistoryJobSummaryManager.getJobHistoryRecordType(job.getType().getTypeInfo());
        if (historyType == null) {
            return null;
        }
        BIBatchJobSummary result = (BIBatchJobSummary)historyType.getInstance();
        result.updateJob(job);
        return result;
    }

    @Override
    public BIJobStepSummary makeStepSummary(BJobStepDetails details, BAbsTime jobStartTime) {
        BJobStepHistoryRecord result = this.makeStepRecord(details);
        result.setJobStartTime(jobStartTime);
        return result;
    }

    @Override
    public IterableCursor<? extends BIBatchJobSummary> listJobSummaries(Type jobType, BObject base) throws Exception {
        return this.listJobSummaries(jobType, null, base);
    }

    @Override
    public IterableCursor<? extends BIBatchJobSummary> listJobSummaries(Type jobType, String propName, BSimple propValue, BObject base) throws Exception {
        return this.listJobSummaries(jobType, Predicates.eq((String)propName, (BSimple)propValue), base);
    }

    @Override
    public IterableCursor<? extends BIBatchJobSummary> listJobSummaries(Type jobType, BExpression predicate, BObject base) {
        BExpression notDisposed = Predicates.eq((String)"disposed", (BSimple)BBoolean.FALSE);
        predicate = predicate == null ? notDisposed : Predicates.and((BExpression)predicate, (BExpression)notDisposed);
        predicate = Predicates.and((BExpression)predicate, (BExpression)Predicates.eq((String)"jobType", (BSimple)jobType.getTypeSpec()));
        TypeInfo[] recordTypes = this.getJobHistoryRecordTypes(jobType.getTypeInfo());
        TZFixedHistoryCollectionsCursor.Entry[] entries = new TZFixedHistoryCollectionsCursor.Entry[recordTypes.length];
        BQuery q = new BQuery().where(predicate);
        BBqlEngine engine = new BBqlEngine();
        for (int i = 0; i < recordTypes.length; ++i) {
            BOrd queryBase = BOrd.make((BOrd)BOrd.toSession((BObject)base).getAbsoluteOrd(), (OrdQuery)new HistoryQuery("^" + recordTypes[i].getTypeName()));
            BTimeZone tz = ((BIHistory)queryBase.get()).getConfig().getTimeZone();
            entries[i] = new TZFixedHistoryCollectionsCursor.Entry(tz, engine.compile(q, queryBase).execute());
        }
        return new TZFixedHistoryCollectionsCursor(entries);
    }

    @Override
    public IterableCursor<? extends BIJobStepSummary> listStepSummaries(Type stepType, BObject base) throws Exception {
        return this.listStepSummaries(stepType, null, base);
    }

    @Override
    public IterableCursor<? extends BIJobStepSummary> listStepSummaries(Type stepType, String propName, BSimple propValue, BObject base) throws Exception {
        return this.listStepSummaries(stepType, Predicates.eq((String)propName, (BSimple)propValue), base);
    }

    @Override
    public IterableCursor<? extends BIJobStepSummary> listStepSummaries(Type stepType, BExpression predicate, BObject base) {
        BExpression notDisposed = Predicates.eq((String)"disposed", (BSimple)BBoolean.FALSE);
        predicate = predicate == null ? notDisposed : Predicates.and((BExpression)predicate, (BExpression)notDisposed);
        predicate = Predicates.and((BExpression)predicate, (BExpression)Predicates.eq((String)"stepType", (BSimple)stepType.getTypeSpec()));
        TypeInfo[] recordTypes = this.getStepHistoryRecordTypes(stepType.getTypeInfo());
        TZFixedHistoryCollectionsCursor.Entry[] entries = new TZFixedHistoryCollectionsCursor.Entry[recordTypes.length];
        BQuery q = new BQuery().where(predicate);
        BBqlEngine engine = new BBqlEngine();
        for (int i = 0; i < recordTypes.length; ++i) {
            BOrd queryBase = BOrd.make((BOrd)BOrd.toSession((BObject)base).getAbsoluteOrd(), (OrdQuery)new HistoryQuery("^" + recordTypes[i].getTypeName()));
            BTimeZone tz = ((BIHistory)queryBase.get()).getConfig().getTimeZone();
            entries[i] = new TZFixedHistoryCollectionsCursor.Entry(tz, engine.compile(q, queryBase).execute());
        }
        return new TZFixedHistoryCollectionsCursor(entries);
    }

    @Override
    public CompletableFuture<Void> whenManagerStarted() {
        return this.whenStarted;
    }

    @Override
    public void startAsync() {
        BHistoryService history;
        try {
            history = (BHistoryService)Sys.getService((Type)Sys.getType((String)"history:HistoryService"));
        }
        catch (ServiceNotFoundException snfe) {
            this.whenStarted.completeExceptionally(snfe);
            return;
        }
        history.whenServiceStarted().thenApplyAsync(ignoredVoid -> {
            try (HistorySpaceConnection conn = history.getDatabase().getConnection(null);){
                RecordTypeInfo[] jobInfo = this.getJobRecordTypeInfo(conn);
                RecordTypeInfo[] stepInfo = this.getStepRecordTypeInfo(conn);
                boolean mustInitialize = false;
                for (RecordTypeInfo aJobInfo : jobInfo) {
                    if (aJobInfo.history != null) continue;
                    mustInitialize = true;
                    break;
                }
                if (!mustInitialize) {
                    for (RecordTypeInfo aStepInfo : stepInfo) {
                        if (aStepInfo.history != null) continue;
                        mustInitialize = true;
                        break;
                    }
                }
                if (!mustInitialize) {
                    this.whenStarted.complete(null);
                    RecordTypeInfo[] recordTypeInfoArray = null;
                    return recordTypeInfoArray;
                }
                for (RecordTypeInfo aJobInfo : jobInfo) {
                    if (aJobInfo.history == null) {
                        this.createHistory(conn, aJobInfo.info);
                        continue;
                    }
                    conn.clearAllRecords(aJobInfo.history.getId());
                }
                for (RecordTypeInfo aStepInfo : stepInfo) {
                    if (aStepInfo.history == null) {
                        this.createHistory(conn, aStepInfo.info);
                        continue;
                    }
                    conn.clearAllRecords(aStepInfo.history.getId());
                }
                AccessController.doPrivileged(() -> {
                    BDirectory logDir = (BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("^batchJob/logs"));
                    if (logDir != null) {
                        BIFile[] subDirs;
                        for (BIFile subDir1 : subDirs = logDir.listFiles()) {
                            if (!(subDir1 instanceof BDirectory)) continue;
                            BDirectory subDir = (BDirectory)subDir1;
                            BIFile[] files = subDir.listFiles();
                            TreeMap<BAbsTime, BIFile> jobFilesByStartTime = new TreeMap<BAbsTime, BIFile>();
                            TreeMap<BAbsTime, BIFile> stepFilesByStartTime = new TreeMap<BAbsTime, BIFile>();
                            for (BIFile file : files) {
                                if (file instanceof BBatchJobLogFile) {
                                    jobFilesByStartTime.put(((BBatchJobLogFile)file).getFilenameTime(), file);
                                    continue;
                                }
                                if (!(file instanceof BBatchJobStepLogFile)) continue;
                                stepFilesByStartTime.put(((BBatchJobStepLogFile)file).getFilenameTime(), file);
                            }
                            for (BIFile biFile : jobFilesByStartTime.values()) {
                                BBatchJob job = ((BBatchJobLogFile)biFile).getJob();
                                this.writeJobHistory(conn, job);
                            }
                            for (BIFile biFile : stepFilesByStartTime.values()) {
                                BJobStepDetails details = ((BBatchJobStepLogFile)biFile).getDetails();
                                this.writeStepHistory(conn, details);
                            }
                        }
                    }
                    return null;
                });
                this.whenStarted.complete(null);
                return null;
            }
            catch (Throwable e) {
                this.whenStarted.completeExceptionally(e);
            }
            return null;
        });
    }

    @Override
    public void importSummaries(BIJobSummaryManager fromManager) throws Exception {
        IterableCursor<? extends BIBatchJobSummary> c = fromManager.getAllJobSummaries();
        while (c.next()) {
            BIBatchJobSummary summary = (BIBatchJobSummary)c.get();
            BBatchJob job = summary.getJob((BObject)this);
            this.write(this.makeJobSummary(job));
            for (BJobStepDetails detail : job.getJobStepDetails()) {
                this.write(this.makeStepSummary(detail, job.getStartTime()));
            }
        }
    }

    @Override
    public void performHousekeeping() throws Exception {
        BHistoryService svc = (BHistoryService)BOrd.make((String)"service:history:HistoryService").get();
        TypeInfo[] types = Sys.getRegistry().getConcreteTypes(BBatchJob.TYPE.getTypeInfo());
        HashSet<String> purgedIds = new HashSet<String>();
        try (HistorySpaceConnection conn = svc.getDatabase().getConnection(null);){
            Throwable throwable;
            Cursor c;
            BIHistory history;
            TypeInfo recordType;
            block31: for (TypeInfo type : types) {
                try {
                    recordType = BHistoryJobSummaryManager.getJobHistoryRecordType(type);
                    if (recordType == null || (history = this.getHistory(conn, recordType)) == null || purgedIds.contains(history.getId().toString())) continue;
                    purgedIds.add(history.getId().toString());
                    c = conn.scan(history);
                    throwable = null;
                    try {
                        boolean shouldClear = false;
                        while (c.next()) {
                            if (!(c.get() instanceof BJobStepHistoryRecord)) continue;
                            BJobStepHistoryRecord historyRecord = (BJobStepHistoryRecord)c.get();
                            if (!historyRecord.getDisposed()) {
                                if (!shouldClear) continue;
                                conn.clearOldRecords(history.getId(), historyRecord.getStartTime());
                                continue block31;
                            }
                            shouldClear = true;
                        }
                    }
                    catch (Throwable shouldClear) {
                        throwable = shouldClear;
                        throw shouldClear;
                    }
                    finally {
                        if (c != null) {
                            if (throwable != null) {
                                try {
                                    c.close();
                                }
                                catch (Throwable shouldClear) {
                                    throwable.addSuppressed(shouldClear);
                                }
                            } else {
                                c.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.WARNING, "Exception occurred during performHouseKeeping job ", e);
                        continue;
                    }
                    logger.log(Level.WARNING, "Exception occurred during performHouseKeeping job: " + e);
                }
            }
            types = Sys.getRegistry().getConcreteTypes(BJobStep.TYPE.getTypeInfo());
            purgedIds = new HashSet();
            block33: for (TypeInfo type : types) {
                try {
                    recordType = BHistoryJobSummaryManager.getStepHistoryRecordType(type);
                    if (recordType == null || (history = this.getHistory(conn, recordType)) == null || purgedIds.contains(history.getId().toString())) continue;
                    purgedIds.add(history.getId().toString());
                    c = conn.scan(history);
                    throwable = null;
                    try {
                        boolean shouldClear = false;
                        while (c.next()) {
                            if (!(c.get() instanceof BJobStepHistoryRecord)) continue;
                            BJobStepHistoryRecord record = (BJobStepHistoryRecord)c.get();
                            if (!record.getDisposed()) {
                                if (!shouldClear) continue;
                                conn.clearOldRecords(history.getId(), record.getStartTime());
                                continue block33;
                            }
                            shouldClear = true;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (c != null) {
                            if (throwable != null) {
                                try {
                                    c.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                c.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.WARNING, "Exception occurred during performHouseKeeping job ", e);
                        continue;
                    }
                    logger.log(Level.WARNING, "Exception occurred during performHouseKeeping job: " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(BIBatchJobSummary jobSummary) throws Exception {
        BHistoryService svc = (BHistoryService)BOrd.make((String)"service:history:HistoryService").get();
        try (HistorySpaceConnection conn = svc.getDatabase().getConnection(null);){
            Object object = this.writeLock;
            synchronized (object) {
                conn.append(this.getHistory(conn, jobSummary.getType().getTypeInfo()), (BIHistoryRecordSet)((BBatchJobHistoryRecord)jobSummary));
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(BIJobStepSummary stepSummary) throws Exception {
        BHistoryService svc = (BHistoryService)BOrd.make((String)"service:history:HistoryService").get();
        try (HistorySpaceConnection conn = svc.getDatabase().getConnection(null);){
            Object object = this.writeLock;
            synchronized (object) {
                ((BJobStepHistoryRecord)stepSummary).setTimestamp(BAbsTime.now());
                conn.append(this.getHistory(conn, stepSummary.getType().getTypeInfo()), (BIHistoryRecordSet)((BJobStepHistoryRecord)stepSummary));
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public void disposeJobSummary(Type jobType, BAbsTime jobStartTime) throws Exception {
        TypeInfo[] recordTypes = this.getJobHistoryRecordTypes(jobType.getTypeInfo());
        BHistoryService svc = (BHistoryService)BOrd.make((String)"service:history:HistoryService").get();
        try (HistorySpaceConnection conn = svc.getDatabase().getConnection(null);){
            for (TypeInfo recordType : recordTypes) {
                try {
                    BBatchJobHistoryRecord record = null;
                    BIHistory history = this.getHistory(conn, recordType);
                    try (TableCursor c = conn.timeQuery(history, jobStartTime, jobStartTime).cursor();){
                        while (c.next()) {
                            BBatchJobHistoryRecord r;
                            if (!(c.get() instanceof BBatchJobHistoryRecord) || (r = (BBatchJobHistoryRecord)((BHistoryRecord)c.get()).newCopy()).getTimestamp().getMillis() != jobStartTime.getMillis()) continue;
                            if (record == null) {
                                record = r;
                                continue;
                            }
                            throw new BajaRuntimeException("Multiple records exist for start time");
                        }
                    }
                    if (record != null) {
                        if (!record.getDisposed()) {
                            record.setDisposed(true);
                            conn.update(history, (BHistoryRecord)record);
                        }
                        return;
                    }
                    System.out.println("history not found! " + jobStartTime.getMillis());
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
        }
    }

    @Override
    public void disposeStepSummary(Type stepType, BAbsTime stepStartTime) throws Exception {
        TypeInfo[] recordTypes = this.getStepHistoryRecordTypes(stepType.getTypeInfo());
        BHistoryService svc = (BHistoryService)BOrd.make((String)"service:history:HistoryService").get();
        try (HistorySpaceConnection conn = svc.getDatabase().getConnection(null);){
            for (TypeInfo recordType : recordTypes) {
                try {
                    BJobStepHistoryRecord historyRecord = null;
                    BIHistory history = this.getHistory(conn, recordType);
                    try (TableCursor c = conn.timeQuery(history, stepStartTime, stepStartTime).cursor();){
                        while (c.next()) {
                            if (!(c.get() instanceof BJobStepHistoryRecord)) continue;
                            if (historyRecord == null) {
                                historyRecord = (BJobStepHistoryRecord)((BHistoryRecord)c.get()).newCopy();
                                continue;
                            }
                            throw new BajaRuntimeException("Multiple records exist for start time");
                        }
                    }
                    if (historyRecord == null) continue;
                    historyRecord.setDisposed(true);
                    conn.update(history, (BHistoryRecord)historyRecord);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
        }
    }

    @Override
    public void removeSummaryManager() throws Exception {
        BHistoryService svc = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        try (HistorySpaceConnection conn = svc.getDatabase().getConnection(null);){
            for (TypeInfo type : Sys.getRegistry().getConcreteTypes(BBatchJobHistoryRecord.TYPE.getTypeInfo())) {
                conn.deleteHistory(this.getHistory(conn, type).getId());
            }
            for (TypeInfo type : Sys.getRegistry().getConcreteTypes(BJobStepHistoryRecord.TYPE.getTypeInfo())) {
                conn.deleteHistory(this.getHistory(conn, type).getId());
            }
        }
    }

    @Override
    public IterableCursor<? extends BIBatchJobSummary> getAllJobSummaries() throws Exception {
        BHistoryService svc = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        try (HistorySpaceConnection conn = svc.getDatabase().getConnection(null);){
            IterableCursor<? extends BIBatchJobSummary> iterableCursor = this.getAllJobSummaries(conn);
            return iterableCursor;
        }
    }

    public IterableCursor<? extends BIBatchJobSummary> getAllJobSummaries(HistorySpaceConnection conn) throws Exception {
        return new AllJobSummaries(conn);
    }

    public static TypeInfo getJobHistoryRecordType(TypeInfo batchJobType) {
        if (!batchJobType.is(BBatchJob.TYPE.getTypeInfo())) {
            throw new IllegalArgumentException("Not a BBatchJob subtype: " + batchJobType);
        }
        AgentList agents = Sys.getRegistry().getAgents(batchJobType).filter(AgentFilter.is((Type)BBatchJobHistoryRecord.TYPE));
        return agents.size() == 0 ? null : agents.getDefault().getAgentType();
    }

    public static TypeInfo getStepHistoryRecordType(TypeInfo jobStepType) {
        if (!jobStepType.is(BJobStep.TYPE.getTypeInfo())) {
            throw new IllegalArgumentException("Not a BJobStep subtype");
        }
        AgentList agents = Sys.getRegistry().getAgents(jobStepType).filter(AgentFilter.is((Type)BJobStepHistoryRecord.TYPE));
        return agents.size() == 0 ? null : agents.getDefault().getAgentType();
    }

    protected BJobStepHistoryRecord makeStepRecord(BJobStepDetails details) {
        BJobStepHistoryRecord result = (BJobStepHistoryRecord)BHistoryJobSummaryManager.getStepHistoryRecordType(details.getStepType().getTypeInfo()).getInstance();
        result.update(details);
        return result;
    }

    protected TypeInfo[] getJobHistoryRecordTypes(TypeInfo batchJobType) {
        if (!batchJobType.is(BBatchJob.TYPE.getTypeInfo())) {
            throw new IllegalArgumentException("Not a BBatchJob subtype: " + batchJobType);
        }
        AgentInfo[] agents = Sys.getRegistry().getAgents(batchJobType).filter(AgentFilter.is((Type)BBatchJobHistoryRecord.TYPE)).list();
        TypeInfo[] result = new TypeInfo[agents.length];
        for (int i = 0; i < agents.length; ++i) {
            result[i] = agents[i].getAgentType();
        }
        return result;
    }

    protected TypeInfo[] getStepHistoryRecordTypes(TypeInfo jobStepType) {
        if (!jobStepType.is(BJobStep.TYPE.getTypeInfo())) {
            throw new IllegalArgumentException("Not a BJobStep subtype");
        }
        AgentInfo[] agents = Sys.getRegistry().getAgents(jobStepType).filter(AgentFilter.is((Type)BJobStepHistoryRecord.TYPE)).list();
        TypeInfo[] result = new TypeInfo[agents.length];
        for (int i = 0; i < agents.length; ++i) {
            result[i] = agents[i].getAgentType();
        }
        return result;
    }

    protected RecordTypeInfo[] getJobRecordTypeInfo(HistorySpaceConnection conn) throws Exception {
        HashSet<RecordTypeInfo> resultSet = new HashSet<RecordTypeInfo>();
        for (TypeInfo type : Sys.getRegistry().getConcreteTypes(BBatchJob.TYPE.getTypeInfo())) {
            TypeInfo recordType = BHistoryJobSummaryManager.getJobHistoryRecordType(type);
            if (recordType == null) continue;
            resultSet.add(new RecordTypeInfo(recordType, this.getHistory(conn, recordType)));
        }
        RecordTypeInfo[] result = new RecordTypeInfo[resultSet.size()];
        resultSet.toArray(result);
        return result;
    }

    protected RecordTypeInfo[] getStepRecordTypeInfo(HistorySpaceConnection conn) throws Exception {
        HashSet<RecordTypeInfo> resultSet = new HashSet<RecordTypeInfo>();
        for (TypeInfo type : Sys.getRegistry().getConcreteTypes(BJobStep.TYPE.getTypeInfo())) {
            TypeInfo recordType = BHistoryJobSummaryManager.getStepHistoryRecordType(type);
            if (recordType == null) continue;
            resultSet.add(new RecordTypeInfo(recordType, this.getHistory(conn, recordType)));
        }
        RecordTypeInfo[] result = new RecordTypeInfo[resultSet.size()];
        resultSet.toArray(result);
        return result;
    }

    protected void createHistory(HistorySpaceConnection conn, TypeInfo recordType) throws Exception {
        BHistoryId id = BHistoryId.make((String)("/" + Sys.getStation().getStationName() + "/" + recordType.getTypeName()));
        BHistoryConfig config = new BHistoryConfig(id, recordType.getTypeSpec(), BCapacity.UNLIMITED);
        config.setTimeZone(BTimeZone.getLocal());
        conn.createHistory(config);
    }

    protected void writeJobHistory(HistorySpaceConnection conn, BBatchJob job) {
        try {
            TypeInfo recordType = BHistoryJobSummaryManager.getJobHistoryRecordType(job.getType().getTypeInfo());
            if (recordType != null) {
                conn.append(this.getHistory(conn, recordType), (BIHistoryRecordSet)((BHistoryRecord)this.makeJobSummary(job)));
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected void writeStepHistory(HistorySpaceConnection conn, BJobStepDetails details) {
        try {
            TypeInfo recordType = BHistoryJobSummaryManager.getStepHistoryRecordType(details.getStepType().getTypeInfo());
            if (recordType != null) {
                conn.append(this.getHistory(conn, recordType), (BIHistoryRecordSet)this.makeStepRecord(details));
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected BIHistory getHistory(HistorySpaceConnection conn, TypeInfo recordType) throws Exception {
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Not in a running station");
        }
        String stationName = Sys.getStation().getStationName();
        BHistoryId id = BHistoryId.make((String)("/" + stationName + "/" + recordType.getTypeName()));
        if (conn.exists(id)) {
            return conn.getHistory(id);
        }
        return null;
    }

    protected class AllJobSummaries
    extends AbstractCursor<BBatchJobHistoryRecord> {
        private TypeInfo[] types = Sys.getRegistry().getConcreteTypes(BBatchJobHistoryRecord.TYPE.getTypeInfo());
        private int typeIdx = -1;
        private Cursor<BHistoryRecord> innerCursor;
        private HistorySpaceConnection conn;

        public AllJobSummaries(HistorySpaceConnection conn) {
            this.conn = conn;
        }

        protected boolean advanceCursor() {
            try {
                while (true) {
                    if (this.innerCursor == null) {
                        if (this.typeIdx >= this.types.length - 1) {
                            return false;
                        }
                        ++this.typeIdx;
                        this.innerCursor = this.conn.scan(BHistoryJobSummaryManager.this.getHistory(this.conn, this.types[this.typeIdx++]));
                        continue;
                    }
                    if (this.innerCursor.next()) {
                        return true;
                    }
                    this.innerCursor = null;
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        protected BBatchJobHistoryRecord doGet() {
            if (this.innerCursor == null) {
                throw new IllegalStateException("Attempt to read cursor before beginning or after end");
            }
            return (BBatchJobHistoryRecord)this.innerCursor.get();
        }
    }

    protected static class RecordTypeInfo {
        public TypeInfo info;
        public BIHistory history;

        public RecordTypeInfo(TypeInfo info, BIHistory history) {
            this.info = info;
            this.history = history;
        }

        public boolean equals(Object o) {
            if (o instanceof RecordTypeInfo) {
                RecordTypeInfo rti = (RecordTypeInfo)o;
                return rti.info.getModuleName().equals(this.info.getModuleName()) && rti.info.getTypeName().equals(this.info.getTypeName());
            }
            return false;
        }

        public int hashCode() {
            return this.info.hashCode();
        }
    }
}

