/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.GregorianCalendar;
import javax.baja.file.BIFile;
import javax.baja.io.ValueDocDecoder;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public final class BLocalTimeUtil
extends BSimple {
    public static final BLocalTimeUtil DEFAULT = new BLocalTimeUtil();
    public static final Type TYPE = Sys.loadType(BLocalTimeUtil.class);
    public static final ValueDocDecoder.BogTypeResolver TYPE_RESOLVER = new ValueDocDecoder.BogTypeResolver(){

        public BValue newInstance(ValueDocDecoder decoder, BComplex parent, String propName, Property prop, String typeStr) {
            BValue result = super.newInstance(decoder, parent, propName, prop, typeStr);
            if (result instanceof BAbsTime && decoder.getPlugin().getClass() == ValueDocDecoder.BogDecoderPlugin.class) {
                return DEFAULT;
            }
            return result;
        }
    };

    public Type getType() {
        return TYPE;
    }

    private BLocalTimeUtil() {
    }

    public static void updateAbsTimeZone(BComponent parent, Property prop, BTimeZone newZone) {
        if (newZone == null || newZone.isNull()) {
            return;
        }
        BAbsTime newValue = BLocalTimeUtil.getAdjustedTimeZone((BAbsTime)parent.get(prop), newZone);
        parent.set(prop, (BValue)BAbsTime.NULL);
        if (parent.getSpace() != null && parent.getSpace() instanceof BComponentSpace) {
            try {
                ((BComponentSpace)parent.getSpace()).sync();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        parent.set(prop, (BValue)newValue);
    }

    public static BValue decodeBogFile(BIFile file) throws Exception {
        ValueDocDecoder.BogDecoderPlugin bogPlugin = new ValueDocDecoder.BogDecoderPlugin(file);
        bogPlugin.setTypeResolver((ValueDocDecoder.ITypeResolver)TYPE_RESOLVER);
        ValueDocDecoder decoder = new ValueDocDecoder((ValueDocDecoder.IDecoderPlugin)bogPlugin);
        return decoder.decodeDocument();
    }

    public static BAbsTime getAdjustedTimeZone(BAbsTime rawTime, BTimeZone tz) {
        if (tz == null || tz.isNull() || BLocalTimeUtil.hasEquivalentUtcOffset(rawTime, tz)) {
            return rawTime;
        }
        return BAbsTime.make((long)rawTime.getMillis(), (BTimeZone)tz);
    }

    public static int getUtcOffset(BAbsTime timestamp) {
        return timestamp.getTimeZone().getUtcOffset();
    }

    public static boolean hasEquivalentUtcOffset(BAbsTime timestamp, BTimeZone tz) {
        return BLocalTimeUtil.getUtcOffset(timestamp) == tz.getUtcOffset();
    }

    public BObject decode(DataInput decoder) throws IOException {
        throw new UnsupportedOperationException();
    }

    public BObject decodeFromString(String s) throws IOException {
        char[] c = s.toCharArray();
        try {
            int i = 0;
            int year = (c[i++] - 48) * 1000 + (c[i++] - 48) * 100 + (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != '-') {
                throw new Exception();
            }
            int mon = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != '-') {
                throw new Exception();
            }
            int day = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != 'T') {
                throw new Exception();
            }
            int hour = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != ':') {
                throw new Exception();
            }
            int min = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != ':') {
                throw new Exception();
            }
            int sec = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            int ms = 0;
            if (c[i] == '.') {
                int n = ++i;
                ms = (c[n] - 48) * 100;
                if ('0' <= c[++i] && c[i] <= '9') {
                    ms += (c[i++] - 48) * 10;
                }
                if ('0' <= c[i] && c[i] <= '9') {
                    ms += (c[i++] - 48) * 1;
                }
                while (i < c.length && '0' <= c[i] && c[i] <= '9') {
                    ++i;
                }
            }
            int tzOff = 0;
            char sign = c[i++];
            StringBuffer tzId = new StringBuffer("UTC");
            if (sign != 'Z') {
                if (sign != '+' && sign != '-') {
                    throw new Exception();
                }
                tzId.append(sign);
                tzId.append(c[i]);
                int hrOff = c[i++] - 48;
                if (i < c.length && c[i] != ':') {
                    tzId.append(c[i]);
                    hrOff = hrOff * 10 + c[i++] - 48;
                }
                int minOff = 0;
                if (i < c.length) {
                    if (c[i++] != ':') {
                        throw new Exception();
                    }
                    tzId.append(':');
                    tzId.append(c[i]);
                    tzId.append(c[i + 1]);
                    minOff = 10 * (c[i++] - 48) + c[i++] - 48;
                }
                tzOff = hrOff * 3600000 + minOff * 60000;
                if (sign == '-') {
                    tzOff *= -1;
                }
            }
            BTimeZone tz = tzOff == 0 ? BTimeZone.UTC : BTimeZone.make((String)tzId.toString(), (int)tzOff);
            GregorianCalendar cal = new GregorianCalendar(tz.getJavaTimeZone());
            cal.set(year, mon - 1, day, hour, min, sec);
            cal.set(14, ms);
            return BAbsTime.make((long)cal.getTime().getTime(), (BTimeZone)tz);
        }
        catch (Exception e) {
            throw new IOException("Invalid BAbsTime: " + s);
        }
    }

    public void encode(DataOutput encoder) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String encodeToString() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

