/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob;

import com.tridium.batchJob.BLocalTimeUtil;
import com.tridium.batchJob.history.BHistoryJobSummaryManager;
import com.tridium.util.TimeFormat;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.baja.batchJob.BBatchJob;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDataFile;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.types.log.BILogFile;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;

public class BBatchJobLogFile
extends BDataFile
implements BILogFile {
    public static final Type TYPE = Sys.loadType(BBatchJobLogFile.class);
    private BBatchJob job = null;
    private BString logContents = null;
    public static final String JOB_FILENAME_FORMAT = "yyyyMMdd_HHmmss.SSS.'bjl'";
    public static final BFacets TIMESTAMP_FORMAT = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"YYYYMMDD_HHmmss"), BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE});

    public Type getType() {
        return TYPE;
    }

    public BBatchJobLogFile(BIFileStore store) {
        super(store);
    }

    public BBatchJobLogFile() {
    }

    public static BBatchJobLogFile find(BAbsTime startTime, BObject base) {
        return BBatchJobLogFile.find(null, startTime, base);
    }

    public static BBatchJobLogFile find(Type jobType, BAbsTime startTime, BObject base) {
        if (startTime.isNull()) {
            throw new UnresolvedException();
        }
        try {
            return AccessController.doPrivileged(() -> {
                BFileSpace space = (BFileSpace)BOrd.make((String)"file:").get(base);
                if (jobType == null) {
                    for (TypeInfo type : Sys.getRegistry().getTypes(BBatchJob.TYPE.getTypeInfo())) {
                        BBatchJobLogFile result;
                        FilePath path = BBatchJobLogFile.pathFor(type, startTime, base);
                        if (path == null || (result = (BBatchJobLogFile)space.findFile(path)) == null) continue;
                        return result;
                    }
                    throw new UnresolvedException();
                }
                BBatchJobLogFile result = (BBatchJobLogFile)space.findFile(BBatchJobLogFile.pathFor(jobType.getTypeInfo(), startTime, base));
                if (result == null) {
                    throw new UnresolvedException();
                }
                return result;
            });
        }
        catch (PrivilegedActionException e) {
            throw new BajaRuntimeException("Error finding log file", (Throwable)e);
        }
    }

    public static BBatchJobLogFile findLocal(BAbsTime startTime) {
        return BBatchJobLogFile.findLocal(null, startTime);
    }

    public static BBatchJobLogFile findLocal(Type jobType, BAbsTime startTime) {
        if (startTime.isNull()) {
            throw new UnresolvedException();
        }
        try {
            return AccessController.doPrivileged(() -> {
                if (jobType == null) {
                    for (TypeInfo type : Sys.getRegistry().getConcreteTypes(BBatchJob.TYPE.getTypeInfo())) {
                        BBatchJobLogFile result;
                        FilePath path = BBatchJobLogFile.pathFor(type, startTime, null);
                        if (path == null || (result = (BBatchJobLogFile)BFileSystem.INSTANCE.findFile(path)) == null) continue;
                        return result;
                    }
                    throw new UnresolvedException();
                }
                BBatchJobLogFile result = (BBatchJobLogFile)BFileSystem.INSTANCE.findFile(BBatchJobLogFile.pathFor(jobType.getTypeInfo(), startTime, null));
                if (result == null) {
                    throw new UnresolvedException();
                }
                return result;
            });
        }
        catch (PrivilegedActionException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public static BBatchJobLogFile find(BBatchJob job, BObject base) throws UnresolvedException {
        if (job.getStartTime().isNull()) {
            throw new UnresolvedException();
        }
        return BBatchJobLogFile.find(job.getType(), job.getLocalStartTime(), base);
    }

    public static BBatchJobLogFile create(BBatchJob job) throws Exception {
        return AccessController.doPrivileged(() -> {
            BBatchJobLogFile result = (BBatchJobLogFile)BFileSystem.INSTANCE.makeFile(BBatchJobLogFile.pathFor(job.getType().getTypeInfo(), job.getLocalStartTime(), null));
            OutputStream out = result.getOutputStream();
            ValueDocEncoder enc = new ValueDocEncoder(out, null);
            enc.setEncodeTransients(true);
            enc.setZipped(true);
            BComplex jobCopy = (BComplex)job.newCopy();
            BBatchJobLogFile.removePasswords(jobCopy);
            BComponent doc = new BComponent();
            doc.add("job", (BValue)jobCopy);
            try {
                doc.add("logContents", (BValue)BString.make((String)job.log().encode()));
            }
            catch (Exception e) {
                doc.add("logContents", (BValue)BString.make((String)Lexicon.make((String)"batchJob").getText("BatchJob.logContentEncodingFail")));
            }
            enc.encodeDocument((BValue)doc);
            enc.close();
            out.close();
            return result;
        });
    }

    private static void removePasswords(BComplex complex) {
        Property[] propertiesArray;
        for (Property property : propertiesArray = complex.getPropertiesArray()) {
            BValue value = complex.get(property);
            if (value instanceof BPassword) {
                complex.set(property, (BValue)BPassword.DEFAULT);
                continue;
            }
            if (!(value instanceof BComplex)) continue;
            BBatchJobLogFile.removePasswords((BComplex)value);
        }
    }

    public BBatchJob getJob() throws Exception {
        this.parse();
        return this.job;
    }

    public BString getLogContents() throws Exception {
        this.parse();
        return this.logContents;
    }

    private void parse() throws Exception {
        if (this.job == null) {
            AccessController.doPrivileged(() -> {
                try {
                    BComponent decoded = (BComponent)BLocalTimeUtil.decodeBogFile((BIFile)this);
                    this.job = (BBatchJob)decoded.get("job");
                    this.job.setLogFile((BIFile)this);
                    this.logContents = (BString)decoded.get("logContents");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (this.logContents == null) {
                    this.logContents = BString.DEFAULT;
                }
                return null;
            });
        }
    }

    public BAbsTime getFilenameTime() {
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(JOB_FILENAME_FORMAT);
            fmt.setTimeZone(BTimeZone.getLocal().getJavaTimeZone());
            return BAbsTime.make((long)fmt.parse(this.getFileName()).getTime());
        }
        catch (ParseException pe) {
            throw new BajaRuntimeException("Invalid log file name");
        }
    }

    public void setStore(BIFileStore store) {
        super.setStore(store);
        this.job = null;
    }

    public String getMimeType() {
        return "application/niagara-batch-job-log";
    }

    public String getNavDescription(Context cx) {
        return null;
    }

    public boolean hasNavChildren() {
        return false;
    }

    public BINavNode[] getNavChildren() {
        return new BINavNode[0];
    }

    public BINavNode getNavChild(String navName) {
        return null;
    }

    private static FilePath pathFor(TypeInfo jobType, BAbsTime startTime, BObject base) {
        TypeInfo historyType = BHistoryJobSummaryManager.getJobHistoryRecordType(jobType);
        if (historyType == null) {
            return null;
        }
        FilePath result = new FilePath("^batchJob/logs");
        result = result.merge(historyType.getModuleName() + "_" + historyType.getTypeName());
        result = result.merge(TimeFormat.format((BAbsTime)startTime, (Context)TIMESTAMP_FORMAT) + ".bjl");
        return result;
    }
}

