/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gauth.ui;

import com.tridium.gauth.BGoogleAuthAuthenticator;
import com.tridium.gauth.ui.BGoogleSecretKeyFE;
import com.tridium.user.BUserPasswordConfiguration;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import com.tridium.workbench.user.BExpirationFE;
import com.tridium.workbench.user.BUserPasswordFE;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPermissions;
import javax.baja.security.MissingEncodingKeyException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"gauth:GoogleAuthAuthenticator"})})
public class BGoogleAuthAuthenticatorFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BGoogleAuthAuthenticatorFE.class);
    static final Lexicon lex = UiLexicon.bajaui();
    BUserPasswordFE prompt1 = new BUserPasswordFE();
    BExpirationFE prompt3;
    BLabel resetLabel = new BLabel(BUserPasswordConfiguration.forceResetAtNextLogin.getDefaultDisplayName(null));
    BLabel secretKeyLabel = new BLabel(BGoogleAuthAuthenticator.secretKey.getDefaultDisplayName(null));
    BBooleanFE resetFE = new BBooleanFE();
    BGoogleSecretKeyFE secretKeyFE = new BGoogleSecretKeyFE();

    public Type getType() {
        return TYPE;
    }

    public BGoogleAuthAuthenticatorFE() {
        BGridPane pane = new BGridPane(1);
        pane.add(null, (BValue)this.prompt1);
        BGridPane resetPane = new BGridPane(2);
        resetPane.add(null, (BValue)this.resetLabel);
        resetPane.add(null, (BValue)this.resetFE);
        pane.add(null, (BValue)resetPane);
        this.prompt3 = new BExpirationFE();
        pane.add(null, (BValue)this.prompt3);
        BGridPane secretKeyPane = new BGridPane(2);
        secretKeyPane.add(null, (BValue)this.secretKeyLabel);
        secretKeyPane.add(null, (BValue)this.secretKeyFE);
        pane.add(null, (BValue)secretKeyPane);
        this.setContent((BWidget)pane);
        this.linkTo(null, (BComponent)this.prompt1, (Slot)BPasswordFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.prompt1, (Slot)BPasswordFE.actionPerformed, (Slot)actionPerformed);
        this.linkTo(null, (BComponent)this.resetFE, (Slot)BBooleanFE.setModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.resetFE, (Slot)BBooleanFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.resetFE, (Slot)BBooleanFE.actionPerformed, (Slot)actionPerformed);
        this.linkTo(null, (BComponent)this.prompt3, (Slot)BExpirationFE.setModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.prompt3, (Slot)BExpirationFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.prompt3, (Slot)BExpirationFE.actionPerformed, (Slot)actionPerformed);
        this.linkTo(null, (BComponent)this.secretKeyFE, (Slot)BGoogleSecretKeyFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.secretKeyFE, (Slot)BGoogleSecretKeyFE.actionPerformed, (Slot)actionPerformed);
    }

    protected void doSetReadonly(boolean readonly) {
        this.prompt1.setReadonly(readonly);
        this.resetFE.setReadonly(readonly);
        this.prompt3.setReadonly(readonly);
        this.secretKeyFE.setReadonly(readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        BGoogleAuthAuthenticator auth = (BGoogleAuthAuthenticator)value;
        auth.lease(1);
        if (auth.getParent() != null) {
            this.setReadonly(Flags.isReadonly((BComplex)auth.getParent(), (Slot)auth.getPropertyInParent()));
        }
        if (!auth.isMounted() && auth.getPassword().validate("")) {
            this.prompt1.loadValue((BObject)BPassword.DEFAULT, cx);
        } else {
            this.prompt1.loadValue((BObject)auth.getPassword(), cx);
        }
        this.secretKeyFE.loadValue((BObject)auth.getSecretKey());
        BPermissions perm = auth.getPermissions(cx);
        if (perm.hasAdminRead()) {
            this.resetFE.loadValue((BObject)BBoolean.make((boolean)auth.getPasswordConfig().getForceResetAtNextLogin()), cx);
            this.prompt3.loadValue((BObject)auth.getPasswordConfig().getExpiration(), cx);
        } else {
            this.resetLabel.setVisible(false);
            this.resetFE.setReadonly(true);
            this.resetFE.setVisible(false);
            this.prompt3.setReadonly(true);
            this.prompt3.setVisible(false);
        }
        if (!auth.isMounted() && auth.getPassword() == BPassword.DEFAULT) {
            ((BPasswordAuthenticator)value).setPassword(BPassword.make((String)"", (Context)cx));
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        boolean setExpr;
        BGoogleAuthAuthenticator auth = (BGoogleAuthAuthenticator)value;
        auth.lease(1);
        BPassword p1 = (BPassword)this.prompt1.saveValue(cx);
        BPassword secretKey = (BPassword)this.secretKeyFE.saveValue(cx);
        if (secretKey.validate("")) {
            secretKey = BPassword.DEFAULT;
        }
        BAbsTime expr = (setExpr = this.prompt3.isVisible()) ? (BAbsTime)this.prompt3.saveValue(cx) : BAbsTime.DEFAULT;
        boolean setReset = this.resetFE.isVisible();
        BBoolean isReset = setReset ? (BBoolean)this.resetFE.saveValue(cx) : BBoolean.DEFAULT;
        try {
            auth.setPassword(p1);
            auth.setSecretKey(secretKey);
            if (setExpr || setReset) {
                auth.getPasswordConfig().lease();
            }
            if (setExpr) {
                auth.getPasswordConfig().setExpiration(expr);
            }
            if (setReset) {
                auth.getPasswordConfig().setForceResetAtNextLogin(isReset.getBoolean());
            }
        }
        catch (BajaRuntimeException bre) {
            for (Throwable rootCause = bre.getCause(); rootCause != null; rootCause = rootCause.getCause()) {
                if (!(rootCause instanceof MissingEncodingKeyException)) continue;
                throw new CannotSaveException(rootCause.getLocalizedMessage(), rootCause);
            }
            throw bre;
        }
        return auth;
    }
}

