/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth.web;

import com.tridium.authn.LoginFailureCause;
import com.tridium.clientCertAuth.BClientCertAuthScheme;
import com.tridium.clientCertAuth.BClientCertAuthenticator;
import com.tridium.clientCertAuth.ClientCertAuthException;
import com.tridium.clientCertAuth.ClientCertAuthUtils;
import com.tridium.clientCertAuth.ClientCertAuthenticationInfo;
import com.tridium.clientCertAuth.web.ClientCertAuthInfoHandler;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.web.CookieUtil;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.web.servlets.UnauthenticatedServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public class ClientCertAuthServlet
extends UnauthenticatedServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        NiagaraWebSession session = null;
        try {
            Locale locale = request.getLocale();
            BasicContext context = new BasicContext(null, locale != null ? locale.toLanguageTag() : Sys.getLanguage());
            if (!request.isSecure()) {
                throw new ClientCertAuthException(Lexicon.make((String)"clientCertAuth", (Context)context).get("clientCertAuth.exception.noTLS"));
            }
            X509Certificate[] certChain = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            if (certChain == null) {
                throw new ClientCertAuthException(Lexicon.make((String)"clientCertAuth", (Context)context).get("clientCertAuth.exception.noCert"));
            }
            X509Certificate clientCertificate = certChain[0];
            String username = ClientCertAuthServlet.findUserFromCertificate(clientCertificate, (Context)context);
            session = WebSessionUtil.getSession((HttpServletRequest)request, (boolean)true);
            ClientCertAuthenticationInfo authenticationInfo = AccessController.doPrivileged(() -> ClientCertAuthenticationInfo.make(username, clientCertificate));
            ClientCertAuthInfoHandler.addAuthenticationInfo(session, authenticationInfo);
            session.setAttribute("username", (Object)authenticationInfo.getUsername());
            response.sendRedirect("/j_security_check");
        }
        catch (ClientCertAuthException e) {
            ClientCertAuthUtils.log(Level.WARNING, e.getDetailedErrorMessage(), (Throwable)e);
            response.addCookie(CookieUtil.createCookie((String)"niagara_failure_cause", (String)LoginFailureCause.CLIENT_CERT_FAILURE.name(), (int)-1));
            response.addCookie(CookieUtil.createCookie((String)"niagara_failure_info", (String)Base64.getEncoder().encodeToString(e.getUserErrorMessage().getBytes(StandardCharsets.UTF_8)), (int)-1));
            response.sendRedirect("/login?auth=fail");
        }
        catch (Exception e) {
            ClientCertAuthUtils.log(Level.WARNING, e.getMessage(), (Throwable)e);
            response.addCookie(CookieUtil.createCookie((String)"niagara_failure_cause", (String)LoginFailureCause.CLIENT_CERT_FAILURE.name(), (int)-1));
            response.sendRedirect("/login?auth=fail");
        }
    }

    private static String findUserFromCertificate(X509Certificate clientCertificate, Context context) throws ClientCertAuthException {
        RDN[] rdns;
        HashSet<String> usernames = new HashSet<String>();
        for (RDN rdn : rdns = NX509Certificate.make((X509Certificate)clientCertificate).getSubjectDN().getRDNs(BCStyle.CN)) {
            usernames.add(IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue()));
        }
        try {
            Collection<List<?>> sans = clientCertificate.getSubjectAlternativeNames();
            if (sans != null) {
                for (List<?> san : sans) {
                    int generalNameType = (Integer)san.get(0);
                    if (generalNameType != 1) continue;
                    usernames.add((String)san.get(1));
                }
            }
        }
        catch (CertificateParsingException e) {
            ClientCertAuthUtils.log(Level.WARNING, () -> Lexicon.make((String)"clientCertAuth", (Context)context).getText("clientCertAuth.exception.parsingSAN"), (Throwable)e);
        }
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        for (String username : usernames) {
            BUser user = userService.getUser(username);
            if (user == null || !(user.getAuthenticationScheme() instanceof BClientCertAuthScheme) || !clientCertificate.equals(((BClientCertAuthenticator)user.getAuthenticator()).getCertificate().getX509Certificate())) continue;
            return username;
        }
        for (BUser user : userService.getUsers()) {
            if (!(user.getAuthenticationScheme() instanceof BClientCertAuthScheme) || !clientCertificate.equals(((BClientCertAuthenticator)user.getAuthenticator()).getCertificate().getX509Certificate())) continue;
            return user.getUsername();
        }
        Lexicon lex = Lexicon.make((String)"clientCertAuth", (Context)context);
        String userMessage = lex.getText("clientCertAuth.exception.invalidCert");
        String detailedMessage = lex.getText("clientCertAuth.servlet.exception.noUserFound");
        ClientCertAuthUtils.log(Level.FINE, () -> lex.getText("clientCertAuth.servlet.noUserFoundForCert", new Object[]{clientCertificate.toString()}));
        throw new ClientCertAuthException(detailedMessage, userMessage);
    }
}

