/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetOws.job;

import com.tridium.bacnet.asn.NAlarmSummary;
import com.tridium.bacnet.asn.NEventSummary;
import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnetOws.datatypes.BGetEventInfoConfig;
import java.text.MessageFormat;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BGetEventInformationJob
extends BDeviceManagerJob {
    public static final Property serviceChoice = BGetEventInformationJob.newProperty((int)0, (int)-1, null);
    public static final Type TYPE = Sys.loadType(BGetEventInformationJob.class);
    private BGetEventInfoConfig params;
    static Lexicon lex = Lexicon.make((String)"bacnetOws");

    public int getServiceChoice() {
        return this.getInt(serviceChoice);
    }

    public void setServiceChoice(int v) {
        this.setInt(serviceChoice, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BGetEventInformationJob() {
    }

    public BGetEventInformationJob(BBacnetNetwork bacnet, BGetEventInfoConfig params) {
        super(bacnet);
        this.params = params;
    }

    public void run(Context cx) throws Exception {
        if (this.bacnet == null) {
            throw new IllegalStateException("Must submit thru BacnetNetwork.submitDeviceManagerJob()");
        }
        if (this.params == null) {
            return;
        }
        try {
            BBacnetDevice device = this.bacnet.lookupDeviceById(this.params.getObjectId());
            if (device == null) {
                throw new IllegalArgumentException("No BacnetDevice found for objectId " + this.params.getObjectId());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Getting event information from " + device.getObjectId() + " at " + device.getAddress() + "...");
            }
            if (device.isServiceSupported(BacnetBitStringUtil.getBitIndex((String)"BacnetServicesSupported", (String)"getEventInformation"))) {
                Vector v = this.client().getEventInformation(device.getAddress(), null);
                this.setServiceChoice(29);
                ListIterator i = v.listIterator();
                while (i.hasNext()) {
                    NEventSummary esum = (NEventSummary)i.next();
                    this.add(null, (BValue)esum.toJob());
                    this.server().getEventHandler().processEventSummary(esum, device.getObjectId());
                }
            } else if (device.isServiceSupported(BacnetBitStringUtil.getBitIndex((String)"BacnetServicesSupported", (String)"getAlarmSummary"))) {
                String msg1 = lex.getText("getEventInfo.unsupported");
                this.log().message(msg1);
                String warn = lex.getText("getASumm.warning");
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(msg1 + "\n  Trying GetAlarmSummary - " + warn);
                }
                Vector v = this.client().getAlarmSummary(device.getAddress());
                this.setServiceChoice(3);
                ListIterator i = v.listIterator();
                while (i.hasNext()) {
                    NAlarmSummary asum = (NAlarmSummary)i.next();
                    this.add(null, (BValue)asum.toJob());
                }
            } else {
                String msg = lex.getText("getASumm.unsupported");
                this.log().message(msg);
                logger.info(msg);
                this.add("failureCause", (BValue)BString.make((String)msg));
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception sending GetEventInformation: " + e, e);
            String msg = MessageFormat.format(lex.getText("getEventInfo.fail"), e);
            this.add("failureCause", (BValue)BString.make((String)e.toString()));
            this.log().failed(msg);
            throw e;
        }
    }
}

