/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetOws;

import com.tridium.bacnet.stack.BBacnetMultiPoll;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.bacnetOws.BBacnetOwsDeviceFolder;
import com.tridium.bacnetOws.BBacnetThreadPoolWorker;
import com.tridium.bacnetOws.BLocalBacnetOwsDevice;
import com.tridium.bacnetOws.datatypes.BGetESummConfig;
import com.tridium.bacnetOws.datatypes.BGetEventInfoConfig;
import com.tridium.bacnetOws.job.BGetEnrollmentSummaryJob;
import com.tridium.bacnetOws.job.BGetEventInformationJob;
import java.util.logging.Level;
import javax.baja.agent.AgentList;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetOwsNetwork
extends BBacnetNetwork {
    public static final Property localDevice = BBacnetOwsNetwork.newProperty((int)0, (BValue)new BLocalBacnetOwsDevice(), null);
    public static final Property writeWorker = BBacnetOwsNetwork.newProperty((int)4, (BValue)new BBacnetThreadPoolWorker("BnWWkr"), null);
    public static final Type TYPE = Sys.loadType(BBacnetOwsNetwork.class);
    public static final Context jobContext = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public String toString() {
            return "BacnetOws:jobContext";
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }
    };
    private boolean licenseChecked = false;

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        BNetworkPort[] ports = (BNetworkPort[])((BBacnetStack)this.getBacnetComm()).getNetwork().getChildren(BNetworkPort.class);
        for (int i = 0; i < ports.length; ++i) {
            ports[i].getPollService().setFlags((Slot)BBacnetMultiPoll.numberOfThreads, 0);
        }
        this.checkLicense();
    }

    public void registerDevice(BBacnetDevice device) {
        super.registerDevice(device);
        this.setDeviceExt(device);
    }

    protected void setDeviceExt(BBacnetDevice device) {
    }

    public BOrd doSubmitDeviceManagerJob(BValue arg, Context cx) {
        this.checkLicense();
        if (this.isFatalFault()) {
            return null;
        }
        Type t = arg.getType();
        if (t.is(BGetEventInfoConfig.TYPE)) {
            return new BGetEventInformationJob(this, (BGetEventInfoConfig)arg).submit(cx);
        }
        if (t.is(BGetESummConfig.TYPE)) {
            return new BGetEnrollmentSummaryJob(this, (BGetESummConfig)arg).submit(cx);
        }
        return super.doSubmitDeviceManagerJob(arg, cx);
    }

    public Type getDeviceFolderType() {
        return BBacnetOwsDeviceFolder.TYPE;
    }

    protected Feature getOwsLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "bacnetOws");
    }

    private void checkLicense() {
        if (this.licenseChecked) {
            return;
        }
        try {
            Feature feature = this.getOwsLicenseFeature();
            if (feature == null) {
                return;
            }
            feature.check();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Unlicensed: " + this.toPathString(), e);
            this.configFatal("Unlicensed: " + e);
        }
        finally {
            this.licenseChecked = true;
        }
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.remove("bacnet:BacnetDeviceManager");
        agents.remove("bacnet:BacnetDeviceUxManager");
        return agents;
    }
}

