/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platSerial;

import com.tridium.platSerial.BSerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialFlowControlMode;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.serial.PortClosedException;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSerialPortHandle
extends BObject
implements BISerialPort {
    public static final Type TYPE = Sys.loadType(BSerialPortHandle.class);
    private BSerialPort port = null;

    public Type getType() {
        return TYPE;
    }

    public BSerialPortHandle() {
    }

    public BSerialPortHandle(BSerialPort port) {
        this.port = port;
    }

    private void validatePort() {
        if (this.port == null) {
            throw new PortClosedException();
        }
    }

    public void close() {
        this.validatePort();
        this.port.close();
        this.port = null;
    }

    public String getOsPortName() {
        this.validatePort();
        return this.port.getOsPortName();
    }

    public String getOwner() {
        this.validatePort();
        return this.port.getOwner();
    }

    public void sendBreak(int millis) {
        this.validatePort();
        this.port.sendBreak(millis);
    }

    public void setFlowControlMode(BSerialFlowControlMode flowcontrol) throws UnsupportedOperationException {
        this.validatePort();
        this.port.setFlowControlMode(flowcontrol);
    }

    public BSerialFlowControlMode getFlowControlMode() {
        this.validatePort();
        return this.port.getFlowControlMode();
    }

    public BBaudRate getBaudRate() {
        this.validatePort();
        return this.port.getBaudRate();
    }

    public BSerialDataBits getDataBits() {
        this.validatePort();
        return this.port.getDataBits();
    }

    public BSerialStopBits getStopBits() {
        this.validatePort();
        return this.port.getStopBits();
    }

    public BSerialParity getParity() {
        this.validatePort();
        return this.port.getParity();
    }

    public void setSerialPortParams(BBaudRate baudrate, BSerialDataBits dataBits, BSerialStopBits stopBits, BSerialParity parity) throws UnsupportedOperationException {
        this.validatePort();
        this.port.setSerialPortParams(baudrate, dataBits, stopBits, parity);
    }

    public void setDTR(boolean dtr) {
        this.validatePort();
        this.port.setDTR(dtr);
    }

    public boolean isDTR() {
        this.validatePort();
        return this.port.isDTR();
    }

    public void setRTS(boolean rts) {
        this.validatePort();
        this.port.setRTS(rts);
    }

    public boolean isRTS() {
        this.validatePort();
        return this.port.isRTS();
    }

    public boolean isCTS() {
        this.validatePort();
        return this.port.isCTS();
    }

    public boolean isDSR() {
        this.validatePort();
        return this.port.isDSR();
    }

    public boolean isRI() {
        this.validatePort();
        return this.port.isRI();
    }

    public boolean isCD() {
        this.validatePort();
        return this.port.isCD();
    }

    public void enableReceiveThreshold(int threshold) throws UnsupportedOperationException {
        this.validatePort();
        this.port.enableReceiveThreshold(threshold);
    }

    public void disableReceiveThreshold() {
        this.validatePort();
        this.port.disableReceiveThreshold();
    }

    public boolean isReceiveThresholdEnabled() {
        this.validatePort();
        return this.port.isReceiveThresholdEnabled();
    }

    public int getReceiveThreshold() throws UnsupportedOperationException {
        this.validatePort();
        return this.port.getReceiveThreshold();
    }

    public void enableReceiveTimeout(int timeout) throws UnsupportedOperationException {
        this.validatePort();
        this.port.enableReceiveTimeout(timeout);
    }

    public void disableReceiveTimeout() {
        this.validatePort();
        this.port.disableReceiveTimeout();
    }

    public boolean isReceiveTimeoutEnabled() {
        this.validatePort();
        return this.port.isReceiveTimeoutEnabled();
    }

    public int getReceiveTimeout() throws UnsupportedOperationException {
        this.validatePort();
        return this.port.getReceiveTimeout();
    }

    public InputStream getInputStream() throws IOException {
        this.validatePort();
        return this.port.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        this.validatePort();
        return this.port.getOutputStream();
    }
}

