/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email.converters;

import javax.baja.agent.BIAgent;
import javax.baja.data.BIDataValue;
import javax.baja.email.BEmailAddress;
import javax.baja.email.BEmailAddressList;
import javax.baja.email.converters.BAbstractStringToEmailAddressConverter;
import javax.baja.email.converters.BStringToEmailAddressList;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatusString;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BStatusStringToEmailAddressList
extends BAbstractStringToEmailAddressConverter
implements BIAgent {
    public static final Property delimiter = BStatusStringToEmailAddressList.newProperty((int)0, (String)",", (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1), (String)"max", (BIDataValue)BInteger.make((int)1), (String)"fieldWidth", (BIDataValue)BInteger.make((int)1)));
    public static final Type TYPE = Sys.loadType(BStatusStringToEmailAddressList.class);

    public final String getDelimiter() {
        return this.getString(delimiter);
    }

    public final void setDelimiter(String delimiter) {
        this.setString(BStringToEmailAddressList.delimiter, delimiter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        BStatusString emailStatusString = (BStatusString)from;
        if (emailStatusString.getStatus().isNull()) {
            return BEmailAddress.NULL;
        }
        Array list = new Array(BEmailAddress.class);
        String[] addresses = TextUtil.split((String)emailStatusString.getValue(), (char)this.getDelimiter().toString().charAt(0));
        for (int i = 0; i < addresses.length; ++i) {
            BEmailAddress address = this.getEmailAddress(addresses[i].trim());
            if (address == null) continue;
            list.add((Object)address);
        }
        return BEmailAddressList.make((BEmailAddress[])list.trim());
    }
}

