/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email.converters;

import javax.baja.agent.BIAgent;
import javax.baja.data.BIDataValue;
import javax.baja.email.BEmailAddress;
import javax.baja.email.BEmailAddressList;
import javax.baja.email.converters.BEmailAddressToStatusString;
import javax.baja.email.converters.BStringToEmailAddressList;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;
import javax.baja.util.BFormat;

public final class BEmailAddressListToString
extends BConverter
implements BIAgent {
    public static final Property format = BEmailAddressListToString.newProperty((int)0, (BValue)BFormat.make((String)"\"%personal%\" <%address%>"), (BFacets)BFacets.NULL);
    public static final Property delimiter = BEmailAddressListToString.newProperty((int)0, (String)",", (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1), (String)"max", (BIDataValue)BInteger.make((int)1), (String)"fieldWidth", (BIDataValue)BInteger.make((int)1)));
    public static final Type TYPE = Sys.loadType(BEmailAddressListToString.class);

    public final BFormat getFormat() {
        return (BFormat)this.get(format);
    }

    public final void setFormat(BFormat format) {
        this.set(BEmailAddressToStatusString.format, (BValue)format, null);
    }

    public final String getDelimiter() {
        return this.getString(delimiter);
    }

    public final void setDelimiter(String delimiter) {
        this.setString(BStringToEmailAddressList.delimiter, delimiter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        BEmailAddressList emailAddressList = (BEmailAddressList)from;
        if (emailAddressList.isNull()) {
            return BString.DEFAULT;
        }
        StringBuffer buffer = new StringBuffer();
        BEmailAddress[] addresses = emailAddressList.getAddresses();
        for (int i = 0; i < addresses.length; ++i) {
            buffer.append(this.getFormat().format((Object)addresses[i], cx));
            if (i + 1 >= addresses.length) continue;
            buffer.append(this.getDelimiter());
        }
        return BString.make((String)buffer.toString());
    }
}

