/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email.converters;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.baja.email.BEmailAddress;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

public abstract class BAbstractStringToEmailAddressConverter
extends BConverter {
    public static final Type TYPE = Sys.loadType(BAbstractStringToEmailAddressConverter.class);
    private static final Pattern EMAIL_PATTERN;

    public Type getType() {
        return TYPE;
    }

    protected BEmailAddress getEmailAddress(String nameEmailString) {
        Matcher matcher = EMAIL_PATTERN.matcher(nameEmailString);
        if (!matcher.matches()) {
            return null;
        }
        MatchResult result = matcher.toMatchResult();
        String address = result.group(6) != null ? result.group(6) : result.group(5);
        String personal = result.group(3) != null ? result.group(3) : result.group(1);
        try {
            if (address == null) {
                address = "";
            }
            if (personal == null) {
                personal = "";
            }
            return BEmailAddress.make(address, personal);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        Pattern tempEmailPattern = null;
        try {
            tempEmailPattern = Pattern.compile("([^\\s<>@,\"]+(?=(\\s+)|<)|\"([^\"]*)\")?(\\s*)([^\\s<>,]+|<([^<>,]*)>)");
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
        }
        EMAIL_PATTERN = tempEmailPattern;
    }
}

