/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email;

import com.tridium.email.MailPlatformHandler;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.email.BEmailService;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="hostname", type="String", defaultValue="new String()"), @NiagaraProperty(name="port", type="int", defaultValue="-1", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(-1))")}), @NiagaraProperty(name="account", type="String", defaultValue="new String()"), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="pollrate", type="BRelTime", defaultValue="BRelTime.makeSeconds(60)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(1))")}), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="lastPollSuccess", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="lastPollFailure", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="lastPollFailureCause", type="String", defaultValue="", flags=1), @NiagaraProperty(name="debug", type="boolean", defaultValue="false"), @NiagaraProperty(name="useSsl", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="useStartTls", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
public abstract class BEmailAccount
extends BComponent
implements BIStatus {
    public static final Property hostname = BEmailAccount.newProperty((int)0, (String)new String(), null);
    public static final Property port = BEmailAccount.newProperty((int)0, (int)-1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)-1)));
    public static final Property account = BEmailAccount.newProperty((int)0, (String)new String(), null);
    public static final Property password = BEmailAccount.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property pollrate = BEmailAccount.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)60), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property enabled = BEmailAccount.newProperty((int)0, (boolean)true, null);
    public static final Property status = BEmailAccount.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property lastPollSuccess = BEmailAccount.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastPollFailure = BEmailAccount.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastPollFailureCause = BEmailAccount.newProperty((int)1, (String)"", null);
    public static final Property debug = BEmailAccount.newProperty((int)0, (boolean)false, null);
    public static final Property useSsl = BEmailAccount.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property useStartTls = BEmailAccount.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE = Sys.loadType(BEmailAccount.class);
    private static Context doNotChange = new BasicContext();
    private Poller poller = null;
    protected MailPlatformHandler mailPlatformHandler = null;

    public String getHostname() {
        return this.getString(hostname);
    }

    public void setHostname(String v) {
        this.setString(hostname, v, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    public String getAccount() {
        return this.getString(account);
    }

    public void setAccount(String v) {
        this.setString(account, v, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    public BRelTime getPollrate() {
        return (BRelTime)this.get(pollrate);
    }

    public void setPollrate(BRelTime v) {
        this.set(pollrate, (BValue)v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public BAbsTime getLastPollSuccess() {
        return (BAbsTime)this.get(lastPollSuccess);
    }

    public void setLastPollSuccess(BAbsTime v) {
        this.set(lastPollSuccess, (BValue)v, null);
    }

    public BAbsTime getLastPollFailure() {
        return (BAbsTime)this.get(lastPollFailure);
    }

    public void setLastPollFailure(BAbsTime v) {
        this.set(lastPollFailure, (BValue)v, null);
    }

    public String getLastPollFailureCause() {
        return this.getString(lastPollFailureCause);
    }

    public void setLastPollFailureCause(String v) {
        this.setString(lastPollFailureCause, v, null);
    }

    public boolean getDebug() {
        return this.getBoolean(debug);
    }

    public void setDebug(boolean v) {
        this.setBoolean(debug, v, null);
    }

    public boolean getUseSsl() {
        return this.getBoolean(useSsl);
    }

    public void setUseSsl(boolean v) {
        this.setBoolean(useSsl, v, null);
    }

    public boolean getUseStartTls() {
        return this.getBoolean(useStartTls);
    }

    public void setUseStartTls(boolean v) {
        this.setBoolean(useStartTls, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BEmailService getService() {
        BComplex parent = this.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof BEmailService) {
            return (BEmailService)parent;
        }
        return null;
    }

    protected void addSslProvider() throws Exception {
        this.mailPlatformHandler.checkSslSupport();
    }

    public boolean isOperational() {
        BStatus status = this.getStatus();
        return !status.isDisabled() && !status.isFault();
    }

    public void updateStatus() {
        BEmailService service = this.getService();
        boolean oldOperational = this.isOperational();
        int oldStatus = this.getStatus().getBits();
        int newStatus = 0;
        newStatus = !this.getEnabled() || service.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = service.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        boolean newOperational = this.isOperational();
        if (oldOperational != newOperational) {
            if (newOperational) {
                this.enabled();
            } else {
                this.disabled();
            }
        }
    }

    protected void enabled() {
        this.beginPolling();
    }

    protected void disabled() {
        this.endPolling();
    }

    void beginPolling() {
        if (this.getService().isFatalFault()) {
            throw new IllegalStateException();
        }
        if (this.poller == null) {
            this.poller = new Poller();
            this.poller.start();
        }
    }

    void endPolling() {
        if (this.poller != null) {
            this.poller.kill();
            this.poller = null;
        }
    }

    public void started() throws Exception {
        super.started();
        this.mailPlatformHandler = MailPlatformHandler.getInstance();
        this.updateStatus();
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (!this.isRunning()) {
            return;
        }
        if (prop == enabled) {
            this.updateStatus();
        }
        if (cx != doNotChange) {
            if (prop == useSsl) {
                if (this.getUseSsl()) {
                    this.set(useStartTls, (BValue)BBoolean.FALSE, doNotChange);
                }
            } else if (prop == useStartTls && this.getUseStartTls()) {
                this.set(useSsl, (BValue)BBoolean.FALSE, doNotChange);
            }
        }
    }

    public abstract void poll() throws Exception;

    private void doPoll() {
        block2: {
            try {
                this.poll();
                this.setLastPollSuccess(BAbsTime.now());
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)false));
            }
            catch (Throwable e) {
                this.setLastPollFailure(BAbsTime.now());
                this.setLastPollFailureCause(e.toString());
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)true));
                e.printStackTrace();
                BEmailService service = this.getService();
                if (service == null) break block2;
                BEmailService.log.log(Level.SEVERE, "BEmailAccount could not poll: ", e);
            }
        }
    }

    private class Poller
    extends Thread {
        private boolean alive;

        private Poller() {
            super("EmailAccountPoller");
            this.alive = false;
            AccessController.doPrivileged(() -> {
                this.setContextClassLoader(this.getClass().getClassLoader());
                return null;
            });
        }

        private void kill() {
            this.alive = false;
            this.interrupt();
        }

        @Override
        public void run() {
            this.alive = true;
            while (this.alive) {
                try {
                    Poller.sleep(Math.max(BEmailAccount.this.getPollrate().getMillis(), 1000L));
                }
                catch (InterruptedException e) {
                    this.alive = false;
                    break;
                }
                BEmailAccount.this.doPoll();
            }
        }
    }
}

