/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email.me;

import com.tridium.email.MailPlatformHandler;
import java.security.AccessController;
import java.util.Properties;
import javax.baja.email.BDeliveryPolicy;
import javax.baja.email.BIncomingAccount;
import javax.baja.email.BOutgoingAccount;
import javax.baja.naming.BOrd;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;

public class MailPlatformHandlerMe
extends MailPlatformHandler {
    @Override
    public void checkSslSupport() throws Exception {
        super.checkSslSupport();
        BComponent c = (BComponent)BOrd.make((String)"service:crypto:CryptoService").get();
        if (c != null && ((BStatus)c.get("status")).isOk()) {
            return;
        }
        throw new Exception("Valid CryptoService not found.");
    }

    @Override
    public Session getIncomingSession(final BIncomingAccount acct, String type) throws Exception {
        Properties properties = new Properties();
        String port = String.valueOf(acct.getPort());
        properties.put("mail." + type + ".host", acct.getHostname());
        properties.put("mail." + type + ".socketFactory.fallback", "false");
        properties.put("mail." + type + ".port", port);
        properties.put("mail." + type + ".socketFactory.port", port);
        if (acct.getUseSsl() || acct.getUseStartTls()) {
            properties.put("mail." + type + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.put("mail." + type + ".ssl.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.put("mail." + type + ".ssl.socketFactory.port", port);
            if (acct.getUseSsl()) {
                properties.put("mail." + type + ".ssl", "true");
            } else if (acct.getUseStartTls()) {
                properties.put("mail." + type + ".starttls.enable", "true");
            }
        }
        if (type.equals("pop3")) {
            properties.put("mail.pop3.rsetbeforequit", "" + (acct.getDeliveryPolicy() != BDeliveryPolicy.delete));
        }
        Session session = AccessController.doPrivileged(() -> Session.getDefaultInstance((Properties)properties, null));
        properties.put("mail." + type + ".auth", "true");
        session = AccessController.doPrivileged(() -> Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(acct.getAccount(), AccessController.doPrivileged(() -> ((BPassword)acct.getPassword()).getValue()));
            }
        }));
        session.setDebug(acct.getDebug());
        session.setDebugOut(System.out);
        return session;
    }

    @Override
    public Session getOutgoingSession(final BOutgoingAccount acct) throws Exception {
        Session session = null;
        String timeout = String.valueOf(new Long(acct.getConnectionTimeout().getMillis()).intValue());
        String port = String.valueOf(acct.getPort());
        Properties props = new Properties();
        if (acct.getDebug()) {
            props.put("mail.debug", "true");
        }
        props.put("mail.smtp.localhost", AccessController.doPrivileged(() -> System.getProperty("mail.smtp.localhost", Sys.getHostName())));
        props.put("mail.smtp.connectiontimeout", timeout);
        props.put("mail.smtp.timeout", timeout);
        props.put("mail.smtp.host", acct.getHostname());
        props.put("mail.smtp.port", port);
        props.put("mail.smtp.socketFactory.port", port);
        if (acct.getUseSsl() || acct.getUseStartTls()) {
            if (acct.getUseSsl()) {
                props.put("mail.smtp.ssl.enable", "true");
                props.put("mail.transport.protocol", "smtps");
            } else if (acct.getUseStartTls()) {
                props.put("mail.smtp.starttls.enable", "true");
            }
            props.put("mail.smtp.socketFactory.fallback", "false");
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.ssl.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.ssl.socketFactory.port", port);
        } else {
            props.put("mail.smtp.socketFactory.fallback", "true");
            props.put("mail.transport.protocol", "smtp");
        }
        if (acct.getUseAuthentication()) {
            props.put("mail.smtp.auth", "true");
            session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(acct.getAccount(), AccessController.doPrivileged(() -> ((BPassword)acct.getPassword()).getValue()));
                }
            });
        } else {
            props.put("mail.smtp.auth", "false");
            session = Session.getInstance((Properties)props, null);
        }
        return session;
    }
}

