/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email;

import com.tridium.activation.DataHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.baja.email.BBlobPart;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAddress;
import javax.baja.email.BEmailAddressList;
import javax.baja.email.BEmailHeader;
import javax.baja.email.BEmailPart;
import javax.baja.email.BTextPart;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BValue;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public abstract class EmailUtil {
    private static final String CHARSET = "utf-8";

    public static BEmail fromMessage(Message msg) throws Exception {
        BEmail mail = new BEmail();
        InternetAddress[] from = (InternetAddress[])msg.getFrom();
        if (from != null) {
            mail.setFrom(BEmailAddress.make(EmailUtil.str(from[0].getAddress()), EmailUtil.str(from[0].getPersonal())));
        }
        mail.setTo(EmailUtil.makeRecipients(msg.getRecipients(Message.RecipientType.TO)));
        Date date = msg.getSentDate();
        if (date != null) {
            mail.setDate(BAbsTime.make((long)date.getTime()));
        }
        mail.setSubject(EmailUtil.str(msg.getSubject()));
        ArrayList<BEmailPart> list = new ArrayList<BEmailPart>();
        EmailUtil.extractContent(list, msg.getContent(), "", msg.getContentType());
        BEmailPart[] parts = list.toArray(new BEmailPart[list.size()]);
        if (parts.length > 0) {
            mail.setBody(parts[0]);
        }
        if (parts.length > 1) {
            for (int i = 1; i < parts.length; ++i) {
                mail.getAttachments().add(null, (BValue)parts[i]);
            }
        }
        Enumeration headers = msg.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            mail.getHeaders().addHeader(header.getName(), header.getValue());
        }
        return mail;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MimeMessage toMessage(BEmail mail, Session session) throws Exception {
        CustomMimeMessage msg = new CustomMimeMessage(mail, session);
        msg.setFrom((Address)new InternetAddress(mail.getFrom().getAddress(), mail.getFrom().getPersonal()));
        msg.addRecipients(Message.RecipientType.TO, (Address[])EmailUtil.addr(mail.getTo().getAddresses()));
        msg.addRecipients(Message.RecipientType.CC, (Address[])EmailUtil.addr(mail.getCc().getAddresses()));
        msg.addRecipients(Message.RecipientType.BCC, (Address[])EmailUtil.addr(mail.getBcc().getAddresses()));
        msg.setSubject(mail.getSubject(), CHARSET);
        if (!mail.getDate().isNull()) {
            msg.setSentDate(new Date(mail.getDate().getMillis()));
        } else {
            msg.setSentDate(new Date(BAbsTime.now().getMillis()));
        }
        BEmailPart[] att = mail.getAttachments().getParts();
        if (att.length == 0) {
            DataHandler dataHandler = EmailUtil.getDataHandler(mail.getBody());
            if (dataHandler != null) {
                if (dataHandler instanceof BlobDataHandler) {
                    msg.setHeader("Content-Transfer-Encoding", "base64");
                } else {
                    msg.setHeader("Content-Transfer-Encoding", "quoted-printable");
                }
                msg.setDataHandler(dataHandler);
            } else {
                if (!mail.getBody().getMimeType().startsWith("text/")) throw new IllegalArgumentException("Unsupported mime type: " + mail.getBody().getMimeType());
                msg.setHeader("Content-Transfer-Encoding", "quoted-printable");
                msg.setText(mail.getBody().toString(), CHARSET);
            }
        } else {
            MimeMultipart multi = new MimeMultipart();
            MimeBodyPart part = new MimeBodyPart();
            DataHandler dataHandler = EmailUtil.getDataHandler(mail.getBody());
            if (dataHandler != null) {
                if (dataHandler instanceof BlobDataHandler) {
                    part.setHeader("Content-Transfer-Encoding", "base64");
                } else {
                    part.setHeader("Content-Transfer-Encoding", "quoted-printable");
                }
                part.setDataHandler(dataHandler);
            } else {
                if (!mail.getBody().getMimeType().startsWith("text/")) throw new IllegalArgumentException("Unsupported mime type: " + mail.getBody().getMimeType());
                part.setHeader("Content-Transfer-Encoding", "quoted-printable");
                part.setText(mail.getBody().toString(), CHARSET);
            }
            multi.addBodyPart((BodyPart)part);
            for (int i = 0; i < att.length; ++i) {
                part = new MimeBodyPart();
                part.setFileName(att[i].getFileName());
                String mimeType = att[i].getMimeType();
                dataHandler = EmailUtil.getDataHandler(att[i]);
                if (dataHandler != null) {
                    if (dataHandler instanceof BlobDataHandler) {
                        part.setHeader("Content-Transfer-Encoding", "base64");
                    } else {
                        part.setHeader("Content-Transfer-Encoding", "quoted-printable");
                    }
                    part.setDataHandler(dataHandler);
                } else {
                    if (!mimeType.startsWith("text/")) throw new IllegalArgumentException("Unsupported mime type: " + mimeType);
                    part.setHeader("Content-Transfer-Encoding", "quoted-printable");
                    part.setText(att[i].toString(), CHARSET);
                }
                multi.addBodyPart((BodyPart)part);
            }
            msg.setContent((Multipart)multi);
        }
        BEmailHeader[] headers = mail.getHeaders().getHeaders();
        for (int i = 0; i < headers.length; ++i) {
            msg.addHeader(headers[i].getHeaderName(), headers[i].getValue());
        }
        return msg;
    }

    private static DataHandler getDataHandler(BEmailPart part) {
        if (part instanceof BTextPart) {
            String text = ((BTextPart)part).getText();
            return new TextDataHandler(text, part.getMimeType() + ";charset=" + CHARSET);
        }
        if (part instanceof BBlobPart) {
            byte[] data = ((BBlobPart)part).getBlob().copyBytes();
            return new BlobDataHandler(data, part.getMimeType());
        }
        return null;
    }

    private static InternetAddress[] addr(BEmailAddress[] email) throws Exception {
        InternetAddress[] internet = new InternetAddress[email.length];
        for (int i = 0; i < email.length; ++i) {
            internet[i] = new InternetAddress(email[i].getAddress(), email[i].getPersonal());
        }
        return internet;
    }

    private static void extractContent(List<BEmailPart> list, Object content, String filename) throws Exception {
        EmailUtil.extractContent(list, content, filename, null);
    }

    private static void extractContent(List<BEmailPart> list, Object content, String filename, String mimeType) throws Exception {
        if (content instanceof String) {
            if (mimeType == null) {
                list.add(new BTextPart(EmailUtil.str(filename), (String)content));
            } else {
                list.add(new BTextPart(EmailUtil.str(filename), (String)content, mimeType));
            }
        } else if (content instanceof InputStream) {
            InputStream in = (InputStream)content;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            int n = in.read(b);
            while (n != -1) {
                out.write(b, 0, n);
                n = in.read(b);
            }
            list.add(new BBlobPart(EmailUtil.str(filename), BBlob.make((byte[])out.toByteArray())));
        } else if (content instanceof MimeMultipart) {
            MimeMultipart body = (MimeMultipart)content;
            for (int i = 0; i < body.getCount(); ++i) {
                MimeBodyPart part = (MimeBodyPart)body.getBodyPart(i);
                EmailUtil.extractContent(list, part.getContent(), part.getFileName());
            }
        } else {
            throw new IllegalStateException("Could not decode message content of type " + content.getClass().getName());
        }
    }

    private static BEmailAddressList makeRecipients(Address[] arr) {
        if (arr == null) {
            return BEmailAddressList.DEFAULT;
        }
        InternetAddress[] addr = (InternetAddress[])arr;
        BEmailAddress[] res = new BEmailAddress[addr.length];
        for (int i = 0; i < addr.length; ++i) {
            res[i] = BEmailAddress.make(EmailUtil.str(addr[i].getAddress()), EmailUtil.str(addr[i].getPersonal()));
        }
        return BEmailAddressList.make(res);
    }

    private static String str(String s) {
        return s == null ? "" : s;
    }

    private static class BlobDataHandler
    extends DataHandler {
        public BlobDataHandler(byte[] data, String mimeType) {
            super((Object)data, mimeType);
        }

        public void writeTo(OutputStream out) throws IOException {
            out.write((byte[])this.getContent());
        }
    }

    private static class TextDataHandler
    extends DataHandler {
        public TextDataHandler(String text, String mimeType) {
            super((Object)text, mimeType);
        }

        public void writeTo(OutputStream out) throws IOException {
            byte[] data = ((String)this.getContent()).getBytes(EmailUtil.CHARSET);
            out.write(data);
        }
    }

    private static class CustomMimeMessage
    extends MimeMessage {
        BEmail mail;

        public CustomMimeMessage(BEmail mail, Session session) {
            super(session);
            this.mail = mail;
        }

        protected void updateMessageID() throws MessagingException {
            BEmailHeader[] headers = this.mail.getHeaders().getHeader("Message-ID");
            if (headers.length > 0) {
                InternetAddress addr = InternetAddress.getLocalAddress((Session)this.session);
                String suffix = addr != null ? addr.getAddress() : "user@localhost";
                StringBuffer headerBuffer = new StringBuffer();
                headerBuffer.append("<");
                headerBuffer.append(headers[0].getValue());
                headerBuffer.append(".");
                headerBuffer.append(suffix);
                headerBuffer.append("." + System.currentTimeMillis());
                headerBuffer.append(">");
                this.setHeader("Message-ID", headerBuffer.toString());
            } else {
                super.updateMessageID();
            }
        }
    }
}

