/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.velocity;

import com.tridium.session.NiagaraSuperSession;
import com.tridium.session.SessionManager;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.velocity.BIVelocityWebProfile;
import javax.baja.velocity.VelocityContextUtil;
import javax.baja.web.BIWebProfile;
import javax.baja.web.BServletView;
import javax.baja.web.WebDev;
import javax.baja.web.WebOp;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

public abstract class BVelocityView
extends BServletView {
    public static final Type TYPE = Sys.loadType(BVelocityView.class);

    protected BVelocityView() {
    }

    public void doGet(WebOp op) throws Exception {
        this.loadPage(op);
    }

    public void doPost(WebOp op) throws Exception {
        this.loadPage(op);
    }

    private void loadPage(WebOp op) throws Exception {
        BIWebProfile profile = (BIWebProfile)op.getProfileConfig().make();
        BTypeSpec theme = (BTypeSpec)op.getProfileConfig().get("theme");
        if (this.useProfile(profile, op)) {
            BIVelocityWebProfile velocityProfile = (BIVelocityWebProfile)profile;
            VelocityContext context = velocityProfile.makeVelocityContext(this, op);
            if (theme != null) {
                context.put("themeName", theme.getTypeName());
            }
            this.initVelocityContext(context, op, velocityProfile);
            velocityProfile.write(this, context, op);
        } else {
            VelocityContext context = this.makeVelocityContext(op, profile);
            if (theme != null) {
                context.put("themeName", theme.getTypeName());
            }
            this.initVelocityContext(context, op, profile);
            op.getResponse().setStatus(200);
            op.setContentType(this.getMimeType(op));
            op.getResponse().setHeader("Cache-Control", "no-cache, no-store");
            PrintWriter out = op.getWriter();
            Template template = this.getVelocityEngine().getTemplate(this.getTemplateFileOrd(op).toString());
            template.merge(context, out);
            out.flush();
        }
    }

    public abstract BOrd getTemplateFileOrd(WebOp var1);

    public VelocityContext makeVelocityContext(WebOp op, BIWebProfile profile) throws Exception {
        VelocityContext context = BVelocityView.makeDefaultVelocityContext(op, profile);
        context.put("csrfToken", this.getCsrfToken());
        Map map = (Map)context.get("ax");
        map.put("viewTemplate", this.getTemplateFileOrd(op).toString());
        return context;
    }

    protected void initVelocityContext(VelocityContext context, WebOp op, BIWebProfile profile) throws Exception {
    }

    protected boolean useProfile(BIWebProfile profile, WebOp op) throws InvalidProfileException {
        return profile instanceof BIVelocityWebProfile;
    }

    public String getMimeType(WebOp op) {
        return "text/html";
    }

    public static VelocityContext makeDefaultVelocityContext(WebOp op, BIWebProfile profile) {
        VelocityContext context = BVelocityView.makeDefaultVelocityContext(op.get(), (Context)op);
        Map ax = (Map)context.get("ax");
        ax.put("session", op.getRequest().getSession(true));
        ax.put("target", op);
        ax.put("op", op);
        ax.put("profile", profile);
        return context;
    }

    public static VelocityContext makeDefaultVelocityContext(BObject obj, Context cx) {
        VelocityContext context = new VelocityContext();
        HashMap<String, Object> ax = new HashMap<String, Object>();
        VelocityContextUtil util = new VelocityContextUtil(cx);
        ax.put("cx", cx);
        ax.put("obj", obj);
        ax.put("Flags", Flags.class);
        ax.put("lang", cx.getLanguage());
        ax.put("user", cx.getUser());
        ax.put("util", util);
        context.put("ax", ax);
        context.put("util", util);
        return context;
    }

    protected VelocityEngine getVelocityEngine() {
        return BVelocityView.getVelocityEngineInstance();
    }

    public static VelocityEngine makeVelocityEngine() {
        VelocityEngine velocity = new VelocityEngine();
        Properties initProps = new Properties();
        initProps.setProperty("resource.loader", "niagara");
        initProps.setProperty("niagara.resource.loader.class", "com.tridium.velocity.ResourceLoader");
        initProps.setProperty("input.encoding", "UTF-8");
        String uberspect = "org.apache.velocity.util.introspection.SecureUberspector";
        initProps.setProperty("runtime.introspector.uberspect", uberspect);
        initProps.setProperty("introspector.restrict.packages", "java.lang.reflect");
        initProps.setProperty("introspector.restrict.classes", "java.lang.Class,java.lang.ClassLoader,java.lang.Compiler,java.lang.InheritableThreadLocal,java.lang.Package,java.lang.Process,java.lang.Runtime,java.lang.RuntimePermission,java.lang.SecurityManager,java.lang.System,java.lang.Thread,java.lang.ThreadGroup,java.lang.ThreadLocal,javax.baja.security.BPassword");
        if (WebDev.get((String)"velocity").isEnabled()) {
            initProps.setProperty("velocimacro.library.autoreload", "true");
            initProps.setProperty("velocimacro.permissions.allow.inline.to.replace.global", "true");
            initProps.setProperty("velocimacro.permissions.allow.inline.local.scope", "false");
            initProps.setProperty("file.resource.loader.cache", "false");
        }
        velocity.init(initProps);
        return velocity;
    }

    public static VelocityEngine getVelocityEngineInstance() {
        return VelocityEngineLoader.engine;
    }

    private String getCsrfToken() {
        NiagaraSuperSession session = SessionManager.getCurrentNiagaraSuperSession();
        return session != null ? session.getCsrfToken() : null;
    }

    public Type getType() {
        return TYPE;
    }

    private static class VelocityEngineLoader {
        private static final VelocityEngine engine = BVelocityView.makeVelocityEngine();

        private VelocityEngineLoader() {
        }
    }

    public static final class InvalidProfileException
    extends Exception {
        public InvalidProfileException(Type type) {
            super("Invalid Web Profile! Web Profile must be: " + type);
        }

        public InvalidProfileException(String error) {
            super(error);
        }
    }
}

