/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.velocity;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlEscaper {
    private static final Map<String, String> HTML_CHAR_MAP = new HashMap<String, String>(){
        {
            this.put("&", "&amp;");
            this.put("<", "&lt;");
            this.put(">", "&gt;");
            this.put("\"", "&quot;");
            this.put("'", "&#39;");
            this.put("/", "&#x2F;");
        }
    };
    private final Pattern htmlSpecialChars = HtmlEscaper.compilePattern("[&<>\"'\\/]");

    public String escapeHtml(String str) {
        if (str == null) {
            return null;
        }
        Matcher matcher = this.htmlSpecialChars.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, HTML_CHAR_MAP.get(matcher.group()));
        }
        return matcher.appendTail(sb).toString();
    }

    private static Pattern compilePattern(String str) {
        try {
            return Pattern.compile(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

