/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.backup;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.file.FoxFileException;
import com.tridium.sys.station.Station;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.backup.BBackupService;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.sys.Localizable;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BBackupChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType(BBackupChannel.class);
    private static Lexicon lex = Lexicon.make((String)"backup");

    public Type getType() {
        return TYPE;
    }

    public BBackupChannel() {
        super("backup");
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        if (command == "backup") {
            this.backup(circuit);
            return;
        }
        if (command == "restore") {
            this.restore(circuit);
            return;
        }
        throw new InvalidCommandException(command);
    }

    public InputStream backup(boolean save) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:backup save=" + save);
        }
        FoxCircuit circuit = this.openCircuit("backup");
        FoxMessage req = new FoxMessage();
        req.add("save", save);
        circuit.writeMessage(req);
        FoxMessage resp = circuit.readMessage();
        if (resp.getBoolean("failure", false)) {
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            throw new FoxFileException(lex.getText("backup.error.badFile"));
        }
        return circuit.getInputStream();
    }

    public void backup(FoxCircuit circuit) throws Exception {
        FoxMessage req = circuit.readMessage();
        boolean save = req.getBoolean("save", false);
        BBackupService service = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
        if (!service.getPermissions(this.getSessionContext()).has(48)) {
            throw new PermissionException();
        }
        if (this.isTraceOn()) {
            this.trace("s:backup save=" + save);
        }
        if (save) {
            Station.saveSync();
        }
        try {
            service.zip(null, new EmptyOutputStream(), true);
        }
        catch (Exception e) {
            FoxMessage resp = new FoxMessage();
            resp.add("failure", true);
            if (e instanceof Localizable) {
                resp.add(Fox.exceptionTranslator.exceptionToMessage((Throwable)e).get("exception"));
            }
            circuit.writeMessage(resp);
            circuit.flush();
            throw e;
        }
        FoxMessage resp = new FoxMessage();
        circuit.writeMessage(resp);
        OutputStream out = circuit.getOutputStream();
        try {
            service.zip(null, out, true);
        }
        catch (Exception e) {
            BBackupService.log.warning(lex.getText("backup.error.badFile"));
            throw e;
        }
    }

    public void restore(BOrd file, boolean ignoreDependencies, boolean deleteFile) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:rstore file=" + file + " ignoreDependencies=" + ignoreDependencies + " deleteFile=" + deleteFile);
        }
        FoxCircuit circuit = this.openCircuit("backup");
        FoxMessage req = new FoxMessage();
        req.add("file", file.encodeToString());
        req.add("ignoreDependencies", ignoreDependencies);
        req.add("deleteFile", deleteFile);
        circuit.writeMessage(req);
        circuit.readMessage();
    }

    public void restore(FoxCircuit circuit) throws Exception {
        FoxMessage req = circuit.readMessage();
        BOrd file = (BOrd)BOrd.DEFAULT.decodeFromString(req.getString("file", BOrd.NULL.encodeToString()));
        boolean ignoreDependencies = req.getBoolean("ignoreDependencies", false);
        boolean deleteFile = req.getBoolean("deleteFile", false);
        FoxMessage resp = new FoxMessage();
        circuit.writeMessage(resp);
        BBackupService service = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
        if (!service.getPermissions(this.getSessionContext()).has(48)) {
            throw new PermissionException();
        }
        if (this.isTraceOn()) {
            this.trace("s:restore file=" + file + " ignoreDependencies=" + ignoreDependencies + " deleteFile=" + deleteFile);
        }
        service.restoreFiles((BIFile)file.resolve().get(), ignoreDependencies, deleteFile);
    }

    public class EmptyOutputStream
    extends OutputStream {
        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() {
        }
    }
}

