/*
 * Decompiled with CFR 0.152.
 */
package javax.bajax.analytics.time;

import com.tridiumx.analytics.time.Duration;
import com.tridiumx.analytics.time.TimeBinding;
import com.tridiumx.analytics.util.Strings;
import com.tridiumx.analytics.util.Utils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.time.TimeRange;

@NiagaraType
public final class BAnalyticTimeRange
extends BSimple
implements TimeRange {
    private static final int TYPE_NULL = 0;
    private static final int TYPE_DATE_RANGE = 1;
    public static final int ALIGN_SECOND = 10;
    public static final int ALIGN_MINUTE = 20;
    public static final int ALIGN_HOUR = 30;
    public static final int ALIGN_DAY = 40;
    public static final int ALIGN_WEEK = 50;
    public static final int ALIGN_MONTH = 60;
    public static final int ALIGN_YEAR = 70;
    public static final int ALIGN_QUARTER = 80;
    public static final BAnalyticTimeRange NULL = new BAnalyticTimeRange("null", 0);
    public static final BAnalyticTimeRange all;
    public static final BAnalyticTimeRange DEFAULT;
    public static final BAnalyticTimeRange today;
    public static final BAnalyticTimeRange yesterday;
    public static final BAnalyticTimeRange thisWeek;
    public static final BAnalyticTimeRange lastWeek;
    public static final BAnalyticTimeRange thisMonth;
    public static final BAnalyticTimeRange lastMonth;
    public static final BAnalyticTimeRange thisYear;
    public static final BAnalyticTimeRange lastYear;
    public static final BAnalyticTimeRange weekToDate;
    public static final BAnalyticTimeRange monthToDate;
    public static final BAnalyticTimeRange yearToDate;
    public static final Type TYPE;
    private static BAbsTime nullStart;
    private String value;
    private int units;
    private Duration startOffset = null;
    private Duration endOffset = null;

    public Type getType() {
        return TYPE;
    }

    private BAnalyticTimeRange() {
        this.value = "null";
        this.units = 0;
    }

    private BAnalyticTimeRange(String value, int units) {
        this.value = value;
        this.units = units;
    }

    private BAnalyticTimeRange(String value, int units, Duration startOffset, Duration endOffset) {
        this.value = value;
        this.units = units;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public final int compareTo(Object obj) {
        if (obj instanceof BObject) {
            return this.value.compareTo(((BObject)obj).toString(null));
        }
        return this.value.compareTo(obj.toString());
    }

    public BObject decode(DataInput in) throws IOException {
        return BAnalyticTimeRange.make(in.readUTF());
    }

    public BObject decodeFromString(String s) {
        BAnalyticTimeRange obj = null;
        try {
            obj = Strings.isDecodingRequired(s) ? BAnalyticTimeRange.make(URLDecoder.decode(s, "UTF-8")) : BAnalyticTimeRange.make(s);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.value);
    }

    public String encodeToString() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BAnalyticTimeRange) {
            BAnalyticTimeRange str = (BAnalyticTimeRange)obj;
            return this.value.equals(str.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean isNull() {
        return this == NULL;
    }

    @Override
    public long getEnd() {
        return this.getEnd(System.currentTimeMillis());
    }

    @Override
    public long getEnd(long from) {
        if (this.units == 0) {
            return -1L;
        }
        if (this.units == 1) {
            try {
                return TimeBinding.make(this.value.substring(this.value.indexOf(59) + 1)).getTimeInMillis();
            }
            catch (Exception x) {
                throw new IllegalArgumentException(Utils.lex("invalidTime") + ": " + this.value.substring(this.value.indexOf(59) + 1));
            }
        }
        if (this.endOffset == null) {
            return from;
        }
        return this.endOffset.addTo(this.getStart(from));
    }

    @Override
    public long getStart() {
        return this.getStart(System.currentTimeMillis());
    }

    @Override
    public long getStart(long from) {
        if (this.units == 0) {
            return nullStart.getMillis();
        }
        if (this.units == 1) {
            try {
                return TimeBinding.make(this.value.substring(0, this.value.indexOf(59))).getTimeInMillis();
            }
            catch (Exception x) {
                throw new IllegalArgumentException(Utils.lex("invalidTime") + ": " + this.value.substring(0, this.value.indexOf(59)));
            }
        }
        long start = this.align(from, this.units);
        if (this.startOffset != null) {
            start = this.startOffset.addTo(start);
        }
        return start;
    }

    public long alignStart(long from, long interval) {
        if (interval == 31104000000L) {
            from = this.align(from, 70);
        } else if (interval == 7776000000L) {
            from = this.align(from, 80);
        } else if (interval == 2592000000L) {
            from = this.align(from, 60);
        } else if (interval == 604800000L) {
            from = this.align(from, 50);
        } else {
            long f1 = this.align(from, 70);
            from = f1 + (from - f1) / interval * interval;
        }
        return from;
    }

    public static BAnalyticTimeRange make(BAbsTime start, BAbsTime end) {
        return new BAnalyticTimeRange(start.encodeToString() + ";" + end.encodeToString(), 1);
    }

    public static BAnalyticTimeRange make(String s) {
        if (s == null) {
            return NULL;
        }
        if (s.length() == 0) {
            return NULL;
        }
        switch (s.charAt(0)) {
            case 'a': 
            case 'l': 
            case 'm': 
            case 't': 
            case 'w': 
            case 'y': {
                return BAnalyticTimeRange.parseConstant(s);
            }
            case 'c': {
                return BAnalyticTimeRange.parseCurrent(s);
            }
            case 'p': {
                return BAnalyticTimeRange.parsePrevious(s);
            }
            case 'n': {
                if (s.startsWith("null")) {
                    return NULL;
                }
                return BAnalyticTimeRange.parseNext(s);
            }
            case 'f': {
                return BAnalyticTimeRange.parseFrom(s);
            }
        }
        if (s.indexOf(59) > 0) {
            return new BAnalyticTimeRange(s, 1);
        }
        if (s.startsWith("NULL")) {
            return NULL;
        }
        throw new IllegalArgumentException(Utils.lex("invalidTime") + ": " + s);
    }

    public static String[] parseParts(String s) {
        if (s == null) {
            return new String[]{"null"};
        }
        if (s.length() == 0) {
            return new String[]{"null"};
        }
        switch (s.charAt(0)) {
            case 'a': 
            case 'l': 
            case 'm': 
            case 't': 
            case 'w': 
            case 'y': {
                return new String[]{s};
            }
            case 'c': 
            case 'n': 
            case 'p': {
                if (s.equals("null")) {
                    return new String[]{s};
                }
                return BAnalyticTimeRange.parsePcnParts(s);
            }
            case 'f': {
                return BAnalyticTimeRange.parseFromParts(s);
            }
        }
        if (s.indexOf(59) > 0) {
            return new String[]{s};
        }
        throw new IllegalArgumentException(Utils.lex("invalidTime") + ": " + s);
    }

    public String toString(Context cx) {
        return this.value;
    }

    private long align(long base, int unit) {
        switch (unit) {
            case 10: {
                return TimeBinding.alignSecond(base);
            }
            case 20: {
                return TimeBinding.alignMinute(base);
            }
            case 30: {
                return TimeBinding.alignHour(base);
            }
            case 40: {
                return TimeBinding.alignDay(base);
            }
            case 50: {
                return TimeBinding.alignWeek(base);
            }
            case 60: {
                return TimeBinding.alignMonth(base);
            }
            case 70: {
                return TimeBinding.alignYear(base);
            }
            case 80: {
                return TimeBinding.alignQuarter(base);
            }
        }
        throw new IllegalStateException(Utils.lex("invalidTime") + ": " + this.value);
    }

    private static BAnalyticTimeRange parseConstant(String str) {
        switch (str.charAt(0)) {
            case 'y': {
                if (str.equals("yesterday")) {
                    return yesterday;
                }
                if (!str.equals("yearToDate")) break;
                return yearToDate;
            }
            case 'm': {
                if (!str.equals("monthToDate")) break;
                return monthToDate;
            }
            case 'w': {
                if (!str.equals("weekToDate")) break;
                return weekToDate;
            }
            case 't': {
                if (str.equals("today")) {
                    return today;
                }
                if (str.equals("thisWeek")) {
                    return thisWeek;
                }
                if (str.equals("thisMonth")) {
                    return thisMonth;
                }
                if (!str.equals("thisYear")) break;
                return thisYear;
            }
            case 'l': {
                if (str.equals("lastWeek")) {
                    return lastWeek;
                }
                if (str.equals("lastMonth")) {
                    return lastMonth;
                }
                if (!str.equals("lastYear")) break;
                return lastYear;
            }
            case 'a': {
                if (!str.equals("all")) break;
                return all;
            }
        }
        throw new IllegalStateException(Utils.lex("invalidTime") + ": " + str);
    }

    private static BAnalyticTimeRange parseCurrent(String s) {
        int i;
        int j;
        int len = s.length();
        for (j = i = 7; j < len && Character.isDigit(s.charAt(j)); ++j) {
        }
        int num = Integer.parseInt(s.substring(i, j));
        int units = BAnalyticTimeRange.toUnit(s, s.charAt(j), s.charAt(j + 1));
        Duration sdur = new Duration();
        sdur.negative = true;
        Duration edur = new Duration();
        switch (units) {
            case 10: {
                sdur.seconds = num - 1;
                edur.seconds = num;
                break;
            }
            case 20: {
                sdur.minutes = num - 1;
                edur.minutes = num;
                break;
            }
            case 30: {
                sdur.hours = num - 1;
                edur.hours = num;
                break;
            }
            case 40: {
                sdur.days = num - 1;
                edur.days = num;
                break;
            }
            case 50: {
                sdur.days = (num - 1) * 7;
                edur.days = num * 7;
                break;
            }
            case 60: {
                sdur.months = num - 1;
                edur.months = num;
                break;
            }
            case 70: {
                sdur.years = num - 1;
                edur.years = num;
            }
        }
        if (num == 1) {
            sdur = null;
        }
        return new BAnalyticTimeRange(s, units, sdur, edur);
    }

    private static BAnalyticTimeRange parseFrom(String str) {
        int units = BAnalyticTimeRange.toUnit(str, str.charAt(4), str.charAt(5));
        Duration startOff = null;
        Duration endOff = null;
        int to = str.indexOf("To");
        if (to < 0) {
            throw new IllegalStateException(Utils.lex("invalidTime") + ": " + str);
        }
        int i = str.indexOf("P", 6);
        if (i > 0 && i < to) {
            char ch = str.charAt(i - 1);
            if (ch == '+' || ch == '-') {
                --i;
            }
            startOff = Duration.make(str.substring(i, to));
        }
        if (str.indexOf("Now", to) < 0) {
            endOff = Duration.make(str.substring(to + 2));
        }
        return new BAnalyticTimeRange(str, units, startOff, endOff);
    }

    private static String[] parseFromParts(String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (!str.startsWith("from")) {
            throw new IllegalStateException(Utils.lex("invalidTime") + ": " + str);
        }
        list.add("from");
        int to = str.indexOf("To");
        if (to < 0) {
            throw new IllegalStateException(Utils.lex("invalidTime") + ": " + str);
        }
        int i = str.indexOf("P", 6);
        if (i > 0 && i < to) {
            char ch = str.charAt(i - 1);
            if (ch == '+' || ch == '-') {
                --i;
            }
            list.add(str.substring(4, i));
            list.add(str.substring(i, to));
        } else {
            list.add(str.substring(4, to));
        }
        list.add("To");
        if (str.indexOf("Now", to) < 0) {
            list.add(str.substring(to + 2));
        } else {
            list.add("Now");
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        return ret;
    }

    private static BAnalyticTimeRange parseNext(String s) {
        int i;
        int j;
        int len = s.length();
        for (j = i = 4; j < len && Character.isDigit(s.charAt(j)); ++j) {
        }
        int num = Integer.parseInt(s.substring(i, j));
        int units = BAnalyticTimeRange.toUnit(s, s.charAt(j), s.charAt(j + 1));
        Duration sdur = new Duration();
        Duration edur = new Duration();
        switch (units) {
            case 10: {
                sdur.seconds = 1;
                edur.seconds = num;
                break;
            }
            case 20: {
                sdur.minutes = 1;
                edur.minutes = num;
                break;
            }
            case 30: {
                sdur.hours = 1;
                edur.hours = num;
                break;
            }
            case 40: {
                sdur.days = 1;
                edur.days = num;
                break;
            }
            case 50: {
                sdur.days = 7;
                edur.days = num * 7;
                break;
            }
            case 60: {
                sdur.months = 1;
                edur.months = num;
                break;
            }
            case 70: {
                sdur.years = 1;
                edur.years = num;
            }
        }
        return new BAnalyticTimeRange(s, units, sdur, edur);
    }

    private static String[] parsePcnParts(String s) {
        int i;
        int j;
        String[] ret = new String[3];
        if (s.startsWith("previous")) {
            ret[0] = "previous";
        } else if (s.startsWith("current")) {
            ret[0] = "current";
        } else if (s.startsWith("next")) {
            ret[0] = "next";
        } else {
            throw new IllegalStateException(Utils.lex("invalidTime") + ": " + s);
        }
        int len = s.length();
        for (j = i = ret[0].length(); j < len && Character.isDigit(s.charAt(j)); ++j) {
        }
        ret[1] = s.substring(i, j);
        ret[2] = s.substring(j);
        return ret;
    }

    private static BAnalyticTimeRange parsePrevious(String s) {
        int i;
        int j;
        int len = s.length();
        for (j = i = 8; j < len && Character.isDigit(s.charAt(j)); ++j) {
        }
        int num = Integer.parseInt(s.substring(i, j));
        int units = BAnalyticTimeRange.toUnit(s, s.charAt(j), s.charAt(j + 1));
        Duration sdur = new Duration();
        sdur.negative = true;
        Duration edur = new Duration();
        switch (units) {
            case 10: {
                sdur.seconds = num;
                edur.seconds = num;
                break;
            }
            case 20: {
                sdur.minutes = num;
                edur.minutes = num;
                break;
            }
            case 30: {
                sdur.hours = num;
                edur.hours = num;
                break;
            }
            case 40: {
                sdur.days = num;
                edur.days = num;
                break;
            }
            case 50: {
                sdur.days = num * 7;
                edur.days = num * 7;
                break;
            }
            case 60: {
                sdur.months = num;
                edur.months = num;
                break;
            }
            case 70: {
                sdur.years = num;
                edur.years = num;
            }
        }
        return new BAnalyticTimeRange(s, units, sdur, edur);
    }

    private static int toUnit(String tr, char c1, char c2) {
        switch (c1) {
            case 'S': 
            case 's': {
                return 10;
            }
            case 'M': 
            case 'm': {
                if (c2 == 'i') {
                    return 20;
                }
                return 60;
            }
            case 'H': 
            case 'h': {
                return 30;
            }
            case 'D': 
            case 'd': {
                return 40;
            }
            case 'W': 
            case 'w': {
                return 50;
            }
            case 'Y': 
            case 'y': {
                return 70;
            }
        }
        throw new IllegalStateException(Utils.lex("invalidTime") + ": " + tr);
    }

    static {
        DEFAULT = all = new BAnalyticTimeRange("all", 0);
        today = new BAnalyticTimeRange("today", 40, null, new Duration(false, 0, 0, 1));
        yesterday = new BAnalyticTimeRange("yesterday", 40, new Duration(true, 0, 0, 1), new Duration(false, 0, 0, 1));
        thisWeek = new BAnalyticTimeRange("thisWeek", 50, null, new Duration(false, 0, 0, 7));
        lastWeek = new BAnalyticTimeRange("lastWeek", 50, new Duration(true, 0, 0, 7), new Duration(false, 0, 0, 7));
        thisMonth = new BAnalyticTimeRange("thisMonth", 60, null, new Duration(false, 0, 1, 0));
        lastMonth = new BAnalyticTimeRange("lastMonth", 60, new Duration(true, 0, 1, 0), new Duration(false, 0, 1, 0));
        thisYear = new BAnalyticTimeRange("thisYear", 70, null, new Duration(false, 1, 0, 0));
        lastYear = new BAnalyticTimeRange("lastYear", 70, new Duration(true, 1, 0, 0), new Duration(false, 1, 0, 0));
        weekToDate = new BAnalyticTimeRange("weekToDate", 50, null, null);
        monthToDate = new BAnalyticTimeRange("monthToDate", 60, null, null);
        yearToDate = new BAnalyticTimeRange("yearToDate", 70, null, null);
        TYPE = Sys.loadType(BAnalyticTimeRange.class);
        nullStart = BAbsTime.make((int)2000, (BMonth)BMonth.january, (int)1);
    }
}

