/*
 * Decompiled with CFR 0.152.
 */
package javax.bajax.analytics;

import com.tridiumx.analytics.util.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.baja.sys.BBoolean;
import javax.baja.sys.Context;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.data.Combination;

public class MultiAnalyticContext
extends AnalyticContext {
    protected List<Map<String, String>> multiParams;
    protected BBoolean aggMode;
    protected Combination agg;
    protected String toString;
    private AnalyticContext base;

    public MultiAnalyticContext(Context base) {
        super(base);
    }

    public MultiAnalyticContext setAggMode(boolean arg) {
        this.aggMode = BBoolean.make((boolean)arg);
        return this;
    }

    public boolean getAggMode() {
        return this.aggMode != null && this.aggMode.getBoolean();
    }

    public MultiAnalyticContext setAgg(Combination arg) {
        this.agg = arg;
        return this;
    }

    public Combination getAgg() {
        if (this.agg != null) {
            return this.agg;
        }
        return BCombination.first;
    }

    public Combination getAgg(boolean force) {
        if (this.agg == null && force) {
            return this.getDataPolicy().getDefaultAggregation();
        }
        return this.getAgg();
    }

    public MultiAnalyticContext setMutliParams(List<Map<String, String>> args) {
        this.multiParams = args;
        return this;
    }

    public List<Map<String, String>> getMultiParams() {
        return this.multiParams;
    }

    public static MultiAnalyticContext make(Map<String, String> args, Context base) {
        MultiAnalyticContext cx = (MultiAnalyticContext)AnalyticContext.updateAnalyticContext(args, new MultiAnalyticContext(base));
        String str = args.get("multiOrd");
        if (str != null) {
            cx.setMutliParams(Arrays.asList(str.split(",")).stream().filter(Objects::nonNull).map(s -> Strings.decodeQueryString(s)).collect(Collectors.toList()));
        }
        if ((str = args.get("aggMode")) != null) {
            cx.aggMode = BBoolean.make((String)str);
        }
        if ((str = args.get("agg")) != null) {
            cx.setAgg(BCombination.make(str));
        }
        return cx;
    }

    @Override
    public Combination getRollup(boolean force) {
        return this.rollup;
    }

    @Override
    public Combination getAggregation(boolean force) {
        return this.aggregation;
    }
}

