/*
 * Decompiled with CFR 0.152.
 */
package javax.bajax.analytics;

import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.algorithm.missingdata.BAggregationStrategy;
import com.tridiumx.analytics.algorithm.missingdata.BInterpolationAlgorithm;
import com.tridiumx.analytics.algorithm.missingdata.BMissingDataStrategy;
import com.tridiumx.analytics.algorithm.outlier.BDeltaValues;
import com.tridiumx.analytics.algorithm.outlier.BRawDataFilter;
import com.tridiumx.analytics.data.AnalyticDataPolicy;
import com.tridiumx.analytics.data.BAnalyticDataDefinition;
import com.tridiumx.analytics.util.NeqlPredicate;
import com.tridiumx.analytics.util.Strings;
import com.tridiumx.analytics.util.Utils;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.history.BRolloverValue;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.units.BUnit;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.BFormat;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.data.Combination;
import javax.bajax.analytics.time.BAnalyticTimeRange;
import javax.bajax.analytics.time.BInterval;
import javax.bajax.analytics.time.Interval;
import javax.bajax.analytics.time.TimeRange;

public class AnalyticContext
implements AnalyticConstants,
Context {
    protected Combination aggregation;
    protected Id data;
    protected Predicate<Entity> dataFilter;
    protected Context base;
    protected Interval interval;
    protected BBoolean leadingDeltas;
    protected BINavNode node;
    protected BBoolean normalizeTime;
    protected Combination rollup;
    protected TimeRange timeRange;
    protected TimeZone timeZone;
    protected BUnit unit;
    protected BBoolean useCache;
    protected BFormat seriesName;
    protected BDaysOfWeekBits dowInclusion;
    protected BBoolean history;
    protected BBoolean hisTotEnabled;
    protected BMissingDataStrategy mdhStrategy;
    protected BStatus statusFilter;
    protected BRawDataFilter rawDataFilter;
    protected BDeltaValues deltaValues;
    private AnalyticDataPolicy cachedDataPolicy;
    private Interval cachedInterval;
    private BFacets cacheFacets;
    private OrdTarget navTarget;
    private String toString;
    private static final String DEFAULT_DATA_TAG = "a:a";

    public AnalyticContext() {
    }

    public AnalyticContext(Context cx) {
        this.base = cx;
    }

    public Context getBase() {
        return this.base;
    }

    public BObject getFacet(String name) {
        return this.getFacets().getFacet(name);
    }

    public BFacets getFacets() {
        if (this.cacheFacets == null) {
            if (this.unit == null) {
                return this.getDataPolicy().getFacets();
            }
            this.cacheFacets = BFacets.make((BFacets)this.getDataPolicy().getFacets(), (String)"units", (BIDataValue)this.unit);
            this.cacheFacets = BFacets.make((BFacets)this.cacheFacets, (BFacets)BFacets.make((String)"seriesName", (BIDataValue)this.getSeriesName()));
        }
        return this.cacheFacets;
    }

    public String getLanguage() {
        if (this.base != null) {
            return this.base.getLanguage();
        }
        return Sys.getLanguage();
    }

    public BUser getUser() {
        if (this.getBase() == null) {
            return BUserService.getService().getAdmin();
        }
        BUser ret = this.getBase().getUser();
        if (ret == null) {
            ret = BUserService.getService().getAdmin();
        }
        return ret;
    }

    public Combination getAggregation(boolean force) {
        if (this.aggregation == null && force) {
            return this.getDataPolicy().getDefaultAggregation();
        }
        return this.aggregation;
    }

    public Id getData() {
        return this.data;
    }

    public Predicate<Entity> getDataFilter() {
        return this.dataFilter;
    }

    public AnalyticDataPolicy getDataPolicy() {
        if (this.cachedDataPolicy == null) {
            this.cachedDataPolicy = BAnalyticService.getInstance().getDataPolicy(this.getData(), true);
        }
        return this.cachedDataPolicy;
    }

    public String makeRequestIdentifier(String prefix) {
        StringBuffer buf = new StringBuffer(prefix);
        if (this.getData() != null) {
            buf.append(this.getData().hashCode());
        } else {
            buf.append("0");
        }
        buf.append("_");
        buf.append("_");
        if (this.getTimeRange(false) != null) {
            buf.append(this.getTimeRange(false).hashCode());
        } else {
            buf.append("0");
        }
        buf.append("_");
        if (this.getAggregation(false) != null) {
            buf.append(this.getAggregation(false).hashCode());
        } else {
            buf.append("0");
        }
        buf.append("_");
        if (this.getInterval(false) != null) {
            buf.append(this.getInterval(false).hashCode());
        } else {
            buf.append("0");
        }
        buf.append("_");
        if (this.getRollup(false) != null) {
            buf.append(this.getRollup(false).hashCode());
        } else {
            buf.append("0");
        }
        buf.append("_");
        if (this.getTimeZone() != null) {
            buf.append(this.getTimeZone().getID().hashCode());
        } else {
            buf.append("0");
        }
        return SlotPath.escape((String)buf.toString());
    }

    public long getEndTime() {
        return this.getTimeRange(true).getEnd(System.currentTimeMillis());
    }

    public Interval getInterval(boolean force) {
        if (this.interval == null && force) {
            if (this.cachedInterval == null) {
                this.cachedInterval = this.computeInterval();
            }
            return this.cachedInterval;
        }
        return this.interval;
    }

    public boolean getLeadingDeltas() {
        if (this.leadingDeltas == null) {
            return true;
        }
        return this.leadingDeltas.getBoolean();
    }

    public BINavNode getNode() {
        return this.node;
    }

    public OrdTarget getNodeTarget() {
        if (this.navTarget == null) {
            this.navTarget = this.getNode().getNavOrd().resolve((BObject)Sys.getStation(), (Context)this);
        }
        return this.navTarget;
    }

    public boolean getNormalizeTime() {
        if (this.normalizeTime == null) {
            return true;
        }
        return this.normalizeTime.getBoolean();
    }

    public Combination getRollup(boolean force) {
        if (this.rollup == null && force) {
            return this.getDataPolicy().getDefaultRollup();
        }
        return this.rollup;
    }

    public long getStartTime() {
        return this.getTimeRange(true).getStart(System.currentTimeMillis());
    }

    public TimeRange getTimeRange(boolean force) {
        if (this.timeRange == null && force) {
            return BAnalyticTimeRange.today;
        }
        return this.timeRange;
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            return TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public boolean getUseCache() {
        if (this.useCache == null) {
            return true;
        }
        return this.useCache.getBoolean();
    }

    public BUnit getUnit(boolean force) {
        if (this.unit != null) {
            return this.unit;
        }
        if (!force) {
            return null;
        }
        BUnit ret = (BUnit)this.getDataPolicy().getFacets().get("units");
        if (ret != null) {
            return ret;
        }
        return BUnit.NULL;
    }

    public BUnit getInnermostUnit() {
        return this.getUnit(true);
    }

    public AnalyticContext newCopy() {
        return new AnalyticContext((Context)new BasicContext(this.getUser())).setAggregation(this.getAggregation(true)).setData(this.getData()).setDataFilter(this.getDataFilter()).setLeadingDeltas(this.getLeadingDeltas()).setInterval(this.getInterval(true)).setNode(this.getNode()).setRollup(this.getRollup(true)).setTimeRange(this.getTimeRange(true)).setTimeZone(this.getTimeZone()).setNormalizeTime(this.getNormalizeTime()).setUnit(this.getUnit(false)).setUseCache(this.getUseCache()).setDowInclusion(this.getDowInclusion().encodeToString()).setSeriesName(this.seriesName).setHistory(this.getHistory().getBoolean()).setHisTotEnabled(this.getHisTotEnabled()).setMissingDataStrategy(this.getMissingDataStrategy(false)).setStatusFilter(this.getStatusFilter().toString()).setRawDataFilter(this.getRawDataFilter());
    }

    public AnalyticContext setAggregation(Combination arg) {
        this.toString = null;
        this.aggregation = arg;
        return this;
    }

    public AnalyticContext setData(Id arg) {
        this.toString = null;
        this.data = arg;
        this.cachedDataPolicy = null;
        return this;
    }

    public AnalyticContext setDataFilter(Predicate<Entity> arg) {
        this.toString = null;
        this.dataFilter = arg;
        return this;
    }

    public AnalyticContext setDataFilter(String arg) {
        if (arg == null || arg.length() == 0) {
            return this.setDataFilter((Predicate<Entity>)null);
        }
        return this.setDataFilter(new NeqlPredicate(arg));
    }

    public AnalyticContext setInterval(Interval arg) {
        this.toString = null;
        this.cachedInterval = null;
        this.interval = arg;
        return this;
    }

    public AnalyticContext setNode(BINavNode arg) {
        this.toString = null;
        this.node = arg;
        this.navTarget = null;
        return this;
    }

    public AnalyticContext setLeadingDeltas(boolean arg) {
        this.toString = null;
        this.leadingDeltas = BBoolean.make((boolean)arg);
        return this;
    }

    public AnalyticContext setNormalizeTime(boolean arg) {
        this.toString = null;
        this.normalizeTime = BBoolean.make((boolean)arg);
        return this;
    }

    public AnalyticContext setRollup(Combination arg) {
        this.toString = null;
        this.rollup = arg;
        return this;
    }

    public AnalyticContext setTimeRange(TimeRange arg) {
        this.toString = null;
        this.timeRange = arg;
        return this;
    }

    public AnalyticContext setTimeZone(TimeZone arg) {
        this.toString = null;
        this.timeZone = arg;
        return this;
    }

    public AnalyticContext setUnit(BUnit arg) {
        this.toString = null;
        this.unit = arg;
        this.cacheFacets = null;
        return this;
    }

    public AnalyticContext setSeriesName(BFormat seriesName) {
        this.seriesName = seriesName;
        return this;
    }

    public BString getSeriesName() {
        String formattedSeriesName = "";
        if (this.seriesName != null && (formattedSeriesName = this.seriesName.format((Object)this)).contains("%err:")) {
            formattedSeriesName = Utils.lex("problemWithBFormatUIMessage");
            Utils.log().log(Level.WARNING, Utils.lex("problemWithBFormatStationMessage"));
        }
        return BString.make((String)formattedSeriesName);
    }

    public BDaysOfWeekBits getDowInclusion() {
        return this.dowInclusion != null ? this.dowInclusion : BDaysOfWeekBits.DEFAULT;
    }

    public AnalyticContext setDowInclusion(String dowBits) {
        if (dowBits != null) {
            try {
                this.dowInclusion = (BDaysOfWeekBits)BDaysOfWeekBits.DEFAULT.decodeFromString(dowBits);
            }
            catch (IOException e) {
                this.dowInclusion = BDaysOfWeekBits.DEFAULT;
            }
        } else {
            this.dowInclusion = BDaysOfWeekBits.DEFAULT;
        }
        return this;
    }

    public AnalyticContext setDowInclusion(BDaysOfWeekBits dowBits) {
        this.dowInclusion = dowBits;
        return this;
    }

    public BBoolean getHistory() {
        return this.history != null ? this.history : BBoolean.TRUE;
    }

    public AnalyticContext setHistory(boolean history) {
        this.history = BBoolean.make((boolean)history);
        return this;
    }

    public AnalyticContext setHisTotEnabled(boolean status) {
        this.hisTotEnabled = BBoolean.make((boolean)status);
        return this;
    }

    public boolean getHisTotEnabled() {
        if (this.hisTotEnabled == null) {
            return true;
        }
        return this.hisTotEnabled.getBoolean();
    }

    public AnalyticContext setMissingDataStrategy(BMissingDataStrategy strategy) {
        this.mdhStrategy = strategy;
        return this;
    }

    public BMissingDataStrategy getMissingDataStrategy(boolean force) {
        if (this.mdhStrategy != null && this.mdhStrategy.getEnabled()) {
            return this.mdhStrategy;
        }
        if (!force) {
            return null;
        }
        BMissingDataStrategy strategy = BMissingDataStrategy.DEFAULT;
        AnalyticDataPolicy policy = this.getDataPolicy();
        if (policy != null && policy instanceof BAnalyticDataDefinition) {
            BAnalyticDataDefinition dp = (BAnalyticDataDefinition)policy;
            strategy = dp.getMissingDataStrategy();
        }
        if (strategy != null && strategy.getEnabled()) {
            return strategy;
        }
        strategy = BAnalyticService.getInstance().getMissingDataStrategy();
        if (strategy != null && strategy.getEnabled()) {
            return strategy;
        }
        return BMissingDataStrategy.DEFAULT;
    }

    public BStatus getStatusFilter() {
        AnalyticDataPolicy policy = this.getDataPolicy();
        if (policy instanceof BAnalyticDataDefinition) {
            BAnalyticDataDefinition dp = (BAnalyticDataDefinition)policy;
            this.statusFilter = dp.getOutlier().getStatus();
            return this.statusFilter;
        }
        return BStatus.ok;
    }

    public AnalyticContext setStatusFilter(String status) {
        if (status != null) {
            try {
                this.statusFilter = (BStatus)BStatus.DEFAULT.decodeFromString(status);
            }
            catch (IOException e) {
                this.statusFilter = BStatus.DEFAULT;
            }
        } else {
            this.statusFilter = BStatus.DEFAULT;
        }
        return this;
    }

    public BRawDataFilter getRawDataFilter() {
        AnalyticDataPolicy policy = this.getDataPolicy();
        if (policy instanceof BAnalyticDataDefinition) {
            BAnalyticDataDefinition dp = (BAnalyticDataDefinition)policy;
            if (!dp.getOutlier().getRawDataFilter().getHighLimit().getUnspecified() || !dp.getOutlier().getRawDataFilter().getLowLimit().getUnspecified()) {
                this.rawDataFilter = dp.getOutlier().getRawDataFilter();
                return this.rawDataFilter;
            }
            return null;
        }
        return null;
    }

    public BDeltaValues getDeltaValues() {
        AnalyticDataPolicy policy = this.getDataPolicy();
        if (policy instanceof BAnalyticDataDefinition) {
            BAnalyticDataDefinition dp = (BAnalyticDataDefinition)policy;
            if (!dp.getOutlier().getDeltaValues().getHighLimit().getUnspecified() || !dp.getOutlier().getDeltaValues().getLowLimit().getUnspecified()) {
                this.deltaValues = dp.getOutlier().getDeltaValues();
                return this.deltaValues;
            }
            return null;
        }
        return null;
    }

    public AnalyticContext setRawDataFilter(BRawDataFilter rawDataFilter) {
        this.rawDataFilter = rawDataFilter;
        return this;
    }

    public AnalyticContext setUseCache(boolean arg) {
        this.useCache = BBoolean.make((boolean)arg);
        return this;
    }

    public AnalyticContext subscribe(BINavNode comp) {
        if (comp instanceof BComponent) {
            ((BComponent)comp).lease();
        }
        return this;
    }

    public String toString() {
        BRawDataFilter rawDataFilter;
        BMissingDataStrategy strategy;
        if (this.toString != null) {
            return this.toString;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("aggregation", this.getAggregation(true).getTag());
        map.put("data", this.getData().toString());
        map.put("interval", this.getInterval(true).getTag());
        if (this.getNode() != null && this.getNode().getNavOrd() != null) {
            map.put("node", this.getNode().getNavOrd().toString(null));
        }
        map.put("rollup", this.getRollup(true).getTag());
        map.put("timeRange", this.getTimeRange(true).toString());
        map.put("timeZone", this.getTimeZone().getID());
        map.put("user", this.getUser().getUsername());
        map.put("seriesName", this.getSeriesName().toString());
        map.put("dow", this.getDowInclusion().encodeToString());
        if (this.dataFilter != null) {
            map.put("dataFilter", this.getDataFilter().toString());
        }
        if (!this.getLeadingDeltas()) {
            map.put("leadingDeltas", "false");
        }
        if (!this.getNormalizeTime()) {
            map.put("normalizeTime", "false");
        }
        if (this.getUnit(false) != null) {
            map.put("unit", this.getUnit(false).getUnitName());
        }
        if (!this.getUseCache()) {
            map.put("useCache", "false");
        }
        if (!this.getHisTotEnabled()) {
            map.put("hisTotEnabled", "false");
        }
        if ((strategy = this.getMissingDataStrategy(true)) != null && strategy.getEnabled()) {
            map.put("mdStrategy", strategy.toString());
        }
        if (this.getStatusFilter() != null) {
            map.put("statusFilter", this.getStatusFilter().toString());
        }
        if (!((rawDataFilter = this.getRawDataFilter()) == null || rawDataFilter.getHighLimit().getUnspecified() && rawDataFilter.getLowLimit().getUnspecified())) {
            map.put("rawDataFilter", this.getRawDataFilter().toString());
        }
        this.toString = Strings.encodeQueryString(map);
        return this.toString;
    }

    public static AnalyticContext make(Map<String, String> args, Context base) {
        return AnalyticContext.make(args, base, Optional.empty());
    }

    public static AnalyticContext make(Map<String, String> args, Context base, Optional<AnalyticContext> baseAnalyticContext) {
        AnalyticContext cx = baseAnalyticContext.isPresent() ? baseAnalyticContext.get().newCopy() : new AnalyticContext(base);
        return AnalyticContext.updateAnalyticContext(args, cx);
    }

    public static AnalyticContext updateAnalyticContext(Map<String, String> args, AnalyticContext cx) {
        String str = args.get("aggregation");
        if (str != null) {
            cx.setAggregation(BCombination.make(str.equalsIgnoreCase("rainge") ? "range" : str));
        }
        if ((str = args.get("data")) != null) {
            cx.setData(Id.newId((String)str));
        } else {
            str = args.get("multiOrd");
            if (str != null) {
                cx.setData(Id.newId((String)DEFAULT_DATA_TAG));
            }
        }
        str = args.get("dataFilter");
        if (str != null) {
            cx.setDataFilter(str);
        }
        if ((str = args.get("interval")) != null) {
            cx.setInterval(BInterval.make(str));
        }
        if ((str = args.get("leadingDeltas")) != null) {
            cx.leadingDeltas = BBoolean.make((String)str);
        }
        if ((str = args.get("node")) != null) {
            cx.setNode(Utils.resolveNode(str, (BObject)Sys.getStation()));
        }
        if ((str = args.get("normalizeTime")) != null) {
            cx.normalizeTime = BBoolean.make((String)str);
        }
        if ((str = args.get("rollup")) != null) {
            cx.setRollup(BCombination.make(str.equalsIgnoreCase("rainge") ? "range" : str));
        }
        if ((str = args.get("timeRange")) != null) {
            cx.setTimeRange(BAnalyticTimeRange.make(str));
        }
        if ((str = args.get("timeZone")) != null) {
            cx.setTimeZone(TimeZone.getTimeZone(str));
        }
        if ((str = args.get("unit")) != null) {
            cx.setUnit(BUnit.getUnit((String)str));
        }
        if ((str = args.get("useCache")) != null) {
            cx.useCache = BBoolean.make((String)str);
        }
        if ((str = args.get("seriesName")) != null) {
            cx.setSeriesName(BFormat.make((String)str));
        }
        if ((str = args.get("dow")) != null) {
            cx.setDowInclusion(str);
        }
        if ((str = args.get("isHistory")) != null) {
            cx.history = BBoolean.make((String)str);
        }
        if ((str = args.get("hisTotEnabled")) != null) {
            cx.hisTotEnabled = BBoolean.make((String)str);
        }
        BMissingDataStrategy strategy = cx.mdhStrategy;
        str = args.get("aggStrategy");
        if (str != null) {
            if (strategy == null) {
                strategy = new BMissingDataStrategy().enable();
            }
            strategy.setAggregationStrategy(BAggregationStrategy.make(str));
        }
        if ((str = args.get("intpAlgorithm")) != null) {
            if (strategy == null) {
                strategy = new BMissingDataStrategy().enable();
            }
            strategy.setInterpolationAlgorithm(BInterpolationAlgorithm.make(str));
        }
        if ((str = args.get("knnValue")) != null && strategy != null) {
            strategy.setKValue(Integer.parseInt(str));
        }
        cx.mdhStrategy = strategy;
        str = args.get("statusFilter");
        if (str != null) {
            cx.setStatusFilter(str);
        }
        BRawDataFilter rawDataFilter = cx.rawDataFilter;
        BRolloverValue rolloverValue = new BRolloverValue();
        str = args.get("rawFilterHighLimit");
        if (str != null) {
            rolloverValue.setValue(Double.parseDouble(str));
            rawDataFilter.setHighLimit(rolloverValue);
        }
        if ((str = args.get("rawFilterLowLimit")) != null) {
            rolloverValue.setValue(Double.parseDouble(str));
            rawDataFilter.setLowLimit(rolloverValue);
        }
        BDeltaValues deltaValues = cx.deltaValues;
        str = args.get("deltaValuesHighLimit");
        if (str != null) {
            rolloverValue.setValue(Double.parseDouble(str));
            deltaValues.setHighLimit(rolloverValue);
        }
        if ((str = args.get("deltaValuesLowLimit")) != null) {
            rolloverValue.setValue(Double.parseDouble(str));
            deltaValues.setLowLimit(rolloverValue);
        }
        return cx;
    }

    private Interval computeInterval() {
        long end = this.getEndTime();
        long start = this.getStartTime();
        if (start < 0L) {
            return BInterval.hour;
        }
        if (end < 0L) {
            end = System.currentTimeMillis();
        }
        return this.computeInterval(start, end);
    }

    private Interval computeInterval(long start, long end) {
        long duration = end - start;
        if (duration >= 31104000000L) {
            return BInterval.month;
        }
        if (duration >= 2592000000L) {
            return BInterval.day;
        }
        if (duration >= 604800000L) {
            return BInterval.sixHours;
        }
        if (duration >= 86400000L) {
            return BInterval.fifteenMinutes;
        }
        if (duration >= 43200000L) {
            return BInterval.fiveMinutes;
        }
        return BInterval.minute;
    }
}

