/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ws;

import com.tridiumx.analytics.aon.Alist;
import com.tridiumx.analytics.aon.Amap;
import com.tridiumx.analytics.ws.ApiMessage;
import com.tridiumx.analytics.ws.Encoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;

class GetChildNodesMessage
extends ApiMessage {
    public GetChildNodesMessage(Amap request, Context cx) {
        super(request, cx);
    }

    @Override
    protected Amap doGetResponse() {
        Amap ret = this.getRequest();
        Alist nodes = ret.putList("nodes");
        String path = this.getRequiredString(ret, "node");
        OrdTarget ot = this.resolveForRead(path);
        BObject node = ot.get();
        if (!(node instanceof BINavNode)) {
            return ret;
        }
        BINavNode nav = (BINavNode)node;
        BINavNode[] kids = nav.getNavChildren();
        int len = kids.length;
        OrdTarget kid = null;
        Amap kidMap = null;
        BOrd ord = null;
        String str = null;
        for (int i = 0; i < len; ++i) {
            try {
                ord = kids[i].getNavOrd();
                ord = ord.relativizeToSession();
                str = ord.toString(null);
                if (str.startsWith("station:|")) {
                    str = str.substring(9);
                    ord = BOrd.make((String)str);
                }
                if (!(kid = ord.resolve(node, (Context)ot)).canRead()) continue;
                kidMap = nodes.addMap();
                kidMap.put("node", str);
                Encoder.encodeNode(kid, kidMap);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }
}

