/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.util;

import com.tridiumx.analytics.util.Utils;
import java.util.LinkedList;
import java.util.logging.Level;

public class ThreadPool {
    private boolean alive = true;
    private int idleThreads = 0;
    private int maxQueueSize = 10;
    private int max = 5;
    private int min = 1;
    private int priority = 5;
    private String name;
    private int numThreads = 0;
    private LinkedList<Runnable> queue = new LinkedList();

    public ThreadPool(String name, int min, int max, int priority, int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        this.priority = priority;
        this.name = name;
        this.min = min;
        this.max = max;
        if (max < min) {
            max = min;
        }
        if (max < 1) {
            max = 1;
        }
    }

    public ThreadPool(String name, int min, int max, int priority) {
        this(name, min, max, priority, max * 2);
    }

    public int availableThreads() {
        return this.max - (this.numThreads - this.idleThreads);
    }

    public int getSize() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Runnable r) {
        if (!this.alive) {
            return;
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.queue.size() >= this.maxQueueSize) {
                Utils.log().log(Level.WARNING, Utils.lex("queueFull"), new Object[]{this.name, this.maxQueueSize, r});
                return;
            }
            this.queue.add(r);
            this.checkThreads();
            this.notifyAll();
        }
    }

    public void start() {
        this.alive = true;
    }

    public synchronized void stop() {
        this.alive = false;
        this.notifyAll();
    }

    protected void checkThreads() {
        if (this.idleThreads == 0 && this.numThreads < this.max) {
            ++this.numThreads;
            new MyThread(this.name, this.priority).start();
        }
    }

    protected static int getAvailableProcessors() {
        try {
            return Runtime.getRuntime().availableProcessors();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 1;
        }
    }

    protected void finalize() throws Throwable {
        this.alive = false;
    }

    private Runnable dequeue() {
        if (this.queue.size() == 0) {
            return null;
        }
        return this.queue.remove(0);
    }

    private class MyThread
    extends Thread {
        public MyThread(String name, int priority) {
            super(name);
            this.setPriority(priority);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                long start = 0L;
                Runnable r = null;
                while (ThreadPool.this.alive) {
                    start = System.currentTimeMillis();
                    ThreadPool threadPool = ThreadPool.this;
                    synchronized (threadPool) {
                        ThreadPool.this.idleThreads++;
                        while (r == null && ThreadPool.this.alive) {
                            r = ThreadPool.this.dequeue();
                            if (r != null) continue;
                            if (System.currentTimeMillis() - start > 60000L && ThreadPool.this.numThreads > ThreadPool.this.min) {
                                ThreadPool.this.idleThreads--;
                                return;
                            }
                            try {
                                ThreadPool.this.wait(5000L);
                            }
                            catch (Exception exception) {}
                        }
                        ThreadPool.this.idleThreads--;
                        ThreadPool.this.notifyAll();
                        ThreadPool.this.checkThreads();
                        if (r == null) continue;
                    }
                    try {
                        r.run();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    r = null;
                }
                return;
            }
            catch (Exception x) {
                x.printStackTrace();
                return;
            }
            finally {
                ThreadPool threadPool = ThreadPool.this;
                synchronized (threadPool) {
                    ThreadPool.this.numThreads--;
                }
            }
        }
    }
}

