/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.util;

import com.tridiumx.analytics.data.StatusValue;
import com.tridiumx.analytics.util.Utils;
import javax.baja.status.BIStatus;
import javax.baja.status.BIStatusValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;

public class StatusUtils {
    public static final int DISABLED = 1;
    public static final int FAULT = 2;
    public static final int DOWN = 4;
    public static final int ALARM = 8;
    public static final int STALE = 16;
    public static final int OVERRIDDEN = 32;
    public static final int NULL = 64;
    public static final int UNACKED_ALARM = 128;
    public static final BStatusBoolean NULL_BOOLEAN = new BStatusBoolean(false, BStatus.nullStatus);
    public static final BStatusEnum NULL_ENUM = new BStatusEnum((BEnum)BDynamicEnum.make((int)0), BStatus.nullStatus);
    public static final BStatusNumeric NULL_NUMERIC = new BStatusNumeric(0.0, BStatus.nullStatus);
    public static final BStatusString NULL_STRING = new BStatusString("", BStatus.nullStatus);

    public static int getBits(Object sts) {
        BStatus s = StatusUtils.getStatus(sts);
        return s.getBits();
    }

    public static boolean getBoolean(Object v) {
        if (v instanceof StatusValue) {
            v = ((StatusValue)v).getValue();
        }
        if (v instanceof BIBoolean) {
            return ((BIBoolean)v).getBoolean();
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof BINumeric) {
            return !Utils.isEqualTo(((BINumeric)v).getNumeric(), 0.0);
        }
        if (v instanceof Number) {
            return ((Number)v).intValue() != 0;
        }
        if (v instanceof BIEnum) {
            return ((BIEnum)v).getEnum().getOrdinal() != 0;
        }
        String str = v instanceof BObject ? ((BObject)v).toString(null) : v.toString();
        if (str.length() > 0) {
            switch (str.charAt(0)) {
                case 'A': 
                case 'a': {
                    if (!str.equalsIgnoreCase("active")) break;
                    return true;
                }
                case 'O': 
                case 'o': {
                    if (!str.equalsIgnoreCase("on")) break;
                    return true;
                }
                case 'T': 
                case 't': {
                    if (!str.equalsIgnoreCase("true")) break;
                    return true;
                }
                case '1': {
                    if (!str.equals("1")) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static BEnum getEnum(Object v) {
        if (v instanceof BIEnum) {
            return ((BIEnum)v).getEnum();
        }
        return BDynamicEnum.make((int)((int)StatusUtils.getNumeric(v)));
    }

    public static double getNumeric(Object val) {
        if (val instanceof StatusValue) {
            val = ((StatusValue)val).getValue();
        }
        if (val instanceof BINumeric) {
            return ((BINumeric)val).getNumeric();
        }
        if (val instanceof BIBoolean) {
            if (((BIBoolean)val).getBoolean()) {
                return 1.0;
            }
            return 0.0;
        }
        if (val instanceof BIEnum) {
            return ((BIEnum)val).getEnum().getOrdinal();
        }
        if (val instanceof BRelTime) {
            return ((BRelTime)val).getMillis();
        }
        if (val instanceof BAbsTime) {
            return ((BAbsTime)val).getMillis();
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        try {
            if (val instanceof BObject) {
                return Double.parseDouble(((BObject)val).toString(null));
            }
            return Double.parseDouble(val.toString());
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public static String getString(Object val) {
        if (val instanceof BStatusString) {
            return ((BStatusString)val).getValue();
        }
        if (val instanceof BString) {
            return ((BString)val).getString();
        }
        if (val instanceof BObject) {
            return ((BObject)val).toString(null);
        }
        return val.toString();
    }

    public static BStatus getStatus(Object o) {
        if (o == null) {
            return BStatus.nullStatus;
        }
        if (o instanceof BStatus) {
            return (BStatus)o;
        }
        if (o instanceof BIStatus) {
            return ((BIStatus)o).getStatus();
        }
        if (o instanceof StatusValue) {
            return BStatus.make((int)((StatusValue)o).getStatusFlags());
        }
        return BStatus.ok;
    }

    public static BStatusValue getStatusValue(Object o) {
        Object val = o;
        if (o instanceof StatusValue) {
            val = ((StatusValue)o).getValue();
        }
        if (val instanceof BIStatusValue) {
            return ((BIStatusValue)val).getStatusValue();
        }
        BStatus status = StatusUtils.getStatus(o);
        if (val instanceof BINumeric || val instanceof BRelTime || val instanceof Number) {
            return new BStatusNumeric(StatusUtils.getNumeric(val), status);
        }
        if (val instanceof BIBoolean || val instanceof Boolean) {
            return new BStatusBoolean(StatusUtils.getBoolean(val), status);
        }
        if (val instanceof BIEnum) {
            return new BStatusEnum(StatusUtils.getEnum(val), status);
        }
        try {
            if (val instanceof BSimple) {
                return new BStatusString(((BSimple)val).encodeToString(), status);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (val instanceof BObject) {
            return new BStatusString(((BObject)val).toString(null), status);
        }
        return new BStatusString(val.toString(), status);
    }

    public static BValue getValue(Object o) {
        if (o instanceof BIStatusValue) {
            return ((BIStatusValue)o).getStatusValue().getValueValue();
        }
        if (o instanceof StatusValue) {
            return (BValue)((StatusValue)o).getValue();
        }
        return (BValue)o;
    }

    public static boolean isAlarm(int bits) {
        return (bits & 8) != 0;
    }

    public static boolean isOk(int bits) {
        return bits == 0;
    }

    public static boolean isDisabled(int bits) {
        return (bits & 1) != 0;
    }

    public static boolean isDown(int bits) {
        return (bits & 4) != 0;
    }

    public static boolean isFault(int bits) {
        return (bits & 2) != 0;
    }

    public static boolean isNull(int bits) {
        return (bits & 0x40) != 0;
    }

    public static boolean isOverridden(int bits) {
        return (bits & 0x20) != 0;
    }

    public static boolean isStale(int bits) {
        return (bits & 0x10) != 0;
    }

    public static boolean isUnackedAlarm(int bits) {
        return (bits & 0x80) != 0;
    }

    public static boolean isValid(int bits) {
        return (bits & 1) == 0 && (bits & 2) == 0 && (bits & 4) == 0 && (bits & 0x10) == 0 && (bits & 0x40) == 0;
    }

    public static BStatus orStatus(Object status1, Object status2) {
        int b2;
        BStatus s1 = StatusUtils.getStatus(status1);
        BStatus s2 = StatusUtils.getStatus(status2);
        int b1 = s1.getBits();
        if (b1 == (b2 = s2.getBits())) {
            return s1;
        }
        int or = b1 | b2;
        if (or == b1) {
            return s1;
        }
        if (or == b2) {
            return s2;
        }
        return BStatus.make((int)or);
    }

    public static String toString(int sts) {
        if (StatusUtils.isDisabled(sts)) {
            return "disabled";
        }
        if (StatusUtils.isFault(sts)) {
            return "fault";
        }
        if (StatusUtils.isDown(sts)) {
            return "down";
        }
        if (StatusUtils.isAlarm(sts)) {
            return "alarm";
        }
        if (StatusUtils.isStale(sts)) {
            return "stale";
        }
        if (StatusUtils.isOverridden(sts)) {
            return "overridden";
        }
        if (StatusUtils.isNull(sts)) {
            return "null";
        }
        if (StatusUtils.isUnackedAlarm(sts)) {
            return "unackedAlarm";
        }
        return "ok";
    }

    public static String toString(Object sts) {
        return StatusUtils.toString(StatusUtils.getBits(sts));
    }

    public static String toString(StatusValue val, Context cx) {
        StringBuffer buf = new StringBuffer();
        buf.append(StatusUtils.getValue(val).toString(cx));
        if (val.getStatusFlags() != 0) {
            buf.append(" {" + StatusUtils.toString(val.getStatusFlags()) + "}");
        }
        return buf.toString();
    }
}

