/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.util;

import com.tridiumx.analytics.util.ThreadPool;
import com.tridiumx.analytics.util.Utils;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.control.BNumericPoint;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.history.BCapacity;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.history.ext.BActivePeriod;
import javax.baja.history.ext.BBasicActivePeriod;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BNumericHistorySimulator
extends BNumericPoint {
    public static final Property message = BNumericHistorySimulator.newProperty((int)3, (String)"", null);
    public static final Property enabled = BNumericHistorySimulator.newProperty((int)0, (boolean)false, null);
    public static final Property valueSchedule = BNumericHistorySimulator.newProperty((int)0x10000000, (String)"%parent.slotPathOrd%", null);
    public static final Property resolvedSchedule = BNumericHistorySimulator.newProperty((int)65, (String)"", null);
    public static final Property historyDevice = BNumericHistorySimulator.newProperty((int)0x10000000, (String)"^", null);
    public static final Property historyName = BNumericHistorySimulator.newProperty((int)0x10000000, (String)"%parent.name%", null);
    public static final Property resolvedHistory = BNumericHistorySimulator.newProperty((int)65, (BValue)BHistoryId.NULL, null);
    public static final Property trendPeriod = BNumericHistorySimulator.newProperty((int)0x10000000, (BValue)new BBasicActivePeriod(), null);
    public static final Property months = BNumericHistorySimulator.newProperty((int)0x10000000, (int)12, null);
    public static final Property janMultiplier = BNumericHistorySimulator.newProperty((int)0x10000000, (double)1.0, null);
    public static final Property febMultiplier = BNumericHistorySimulator.newProperty((int)0x10000000, (double)1.0, null);
    public static final Property marMultiplier = BNumericHistorySimulator.newProperty((int)0x10000000, (double)1.0, null);
    public static final Property aprMultiplier = BNumericHistorySimulator.newProperty((int)0x10000000, (double)1.0, null);
    public static final Property mayMultiplier = BNumericHistorySimulator.newProperty((int)0x10000000, (double)1.0, null);
    public static final Property junMultiplier = BNumericHistorySimulator.newProperty((int)0x10000000, (double)1.0, null);
    public static final Property julMultiplier = BNumericHistorySimulator.newProperty((int)0x10000000, (double)1.0, null);
    public static final Property augMultiplier = BNumericHistorySimulator.newProperty((int)0x10000000, (double)1.0, null);
    public static final Property sepMultiplier = BNumericHistorySimulator.newProperty((int)0x10000000, (double)1.0, null);
    public static final Property octMultiplier = BNumericHistorySimulator.newProperty((int)0x10000000, (double)1.0, null);
    public static final Property novMultiplier = BNumericHistorySimulator.newProperty((int)0x10000000, (double)1.0, null);
    public static final Property decMultiplier = BNumericHistorySimulator.newProperty((int)0x10000000, (double)1.0, null);
    public static final Property evenYearMultiplier = BNumericHistorySimulator.newProperty((int)0x10000000, (double)1.0, null);
    public static final Property oddYearMultiplier = BNumericHistorySimulator.newProperty((int)0x10000000, (double)1.0, null);
    public static final Property totalized = BNumericHistorySimulator.newProperty((int)0x10000000, (boolean)false, null);
    public static final Property trendInterval = BNumericHistorySimulator.newProperty((int)0x10000000, (BValue)BRelTime.make((long)900000L), null);
    public static final Property realTimeRate = BNumericHistorySimulator.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.make((long)30000L))), null);
    public static final Property executeLink = BNumericHistorySimulator.newProperty((int)4, (BValue)new BLink(BOrd.make((String)"slot:realTimeRate"), "fireTrigger", "execute", true), null);
    public static final Property randomChance = BNumericHistorySimulator.newProperty((int)0x10000000, (int)20, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"percent"), (int)0, (double)0.0, (double)100.0));
    public static final Property randomAmount = BNumericHistorySimulator.newProperty((int)0x10000000, (int)5, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"percent"), (int)0, (double)0.0, (double)100.0));
    public static final Action rebuildHistory = BNumericHistorySimulator.newAction((int)16, null);
    public static final Action execute = BNumericHistorySimulator.newAction((int)20, null);
    public static final Action update = BNumericHistorySimulator.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BNumericHistorySimulator.class);
    private static BIcon icon = BIcon.std((String)"history.png");
    private BIHistory history = null;
    private double lastRecord = 0.0;
    protected BTrendRecord record = null;
    private boolean steady = false;
    private static ThreadPool threads = null;
    private Clock.Ticket ticket;
    private volatile boolean updating = false;

    public String getMessage() {
        return this.getString(message);
    }

    public void setMessage(String v) {
        this.setString(message, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getValueSchedule() {
        return this.getString(valueSchedule);
    }

    public void setValueSchedule(String v) {
        this.setString(valueSchedule, v, null);
    }

    public String getResolvedSchedule() {
        return this.getString(resolvedSchedule);
    }

    public void setResolvedSchedule(String v) {
        this.setString(resolvedSchedule, v, null);
    }

    public String getHistoryDevice() {
        return this.getString(historyDevice);
    }

    public void setHistoryDevice(String v) {
        this.setString(historyDevice, v, null);
    }

    public String getHistoryName() {
        return this.getString(historyName);
    }

    public void setHistoryName(String v) {
        this.setString(historyName, v, null);
    }

    public BHistoryId getResolvedHistory() {
        return (BHistoryId)this.get(resolvedHistory);
    }

    public void setResolvedHistory(BHistoryId v) {
        this.set(resolvedHistory, (BValue)v, null);
    }

    public BActivePeriod getTrendPeriod() {
        return (BActivePeriod)this.get(trendPeriod);
    }

    public void setTrendPeriod(BActivePeriod v) {
        this.set(trendPeriod, (BValue)v, null);
    }

    public int getMonths() {
        return this.getInt(months);
    }

    public void setMonths(int v) {
        this.setInt(months, v, null);
    }

    public double getJanMultiplier() {
        return this.getDouble(janMultiplier);
    }

    public void setJanMultiplier(double v) {
        this.setDouble(janMultiplier, v, null);
    }

    public double getFebMultiplier() {
        return this.getDouble(febMultiplier);
    }

    public void setFebMultiplier(double v) {
        this.setDouble(febMultiplier, v, null);
    }

    public double getMarMultiplier() {
        return this.getDouble(marMultiplier);
    }

    public void setMarMultiplier(double v) {
        this.setDouble(marMultiplier, v, null);
    }

    public double getAprMultiplier() {
        return this.getDouble(aprMultiplier);
    }

    public void setAprMultiplier(double v) {
        this.setDouble(aprMultiplier, v, null);
    }

    public double getMayMultiplier() {
        return this.getDouble(mayMultiplier);
    }

    public void setMayMultiplier(double v) {
        this.setDouble(mayMultiplier, v, null);
    }

    public double getJunMultiplier() {
        return this.getDouble(junMultiplier);
    }

    public void setJunMultiplier(double v) {
        this.setDouble(junMultiplier, v, null);
    }

    public double getJulMultiplier() {
        return this.getDouble(julMultiplier);
    }

    public void setJulMultiplier(double v) {
        this.setDouble(julMultiplier, v, null);
    }

    public double getAugMultiplier() {
        return this.getDouble(augMultiplier);
    }

    public void setAugMultiplier(double v) {
        this.setDouble(augMultiplier, v, null);
    }

    public double getSepMultiplier() {
        return this.getDouble(sepMultiplier);
    }

    public void setSepMultiplier(double v) {
        this.setDouble(sepMultiplier, v, null);
    }

    public double getOctMultiplier() {
        return this.getDouble(octMultiplier);
    }

    public void setOctMultiplier(double v) {
        this.setDouble(octMultiplier, v, null);
    }

    public double getNovMultiplier() {
        return this.getDouble(novMultiplier);
    }

    public void setNovMultiplier(double v) {
        this.setDouble(novMultiplier, v, null);
    }

    public double getDecMultiplier() {
        return this.getDouble(decMultiplier);
    }

    public void setDecMultiplier(double v) {
        this.setDouble(decMultiplier, v, null);
    }

    public double getEvenYearMultiplier() {
        return this.getDouble(evenYearMultiplier);
    }

    public void setEvenYearMultiplier(double v) {
        this.setDouble(evenYearMultiplier, v, null);
    }

    public double getOddYearMultiplier() {
        return this.getDouble(oddYearMultiplier);
    }

    public void setOddYearMultiplier(double v) {
        this.setDouble(oddYearMultiplier, v, null);
    }

    public boolean getTotalized() {
        return this.getBoolean(totalized);
    }

    public void setTotalized(boolean v) {
        this.setBoolean(totalized, v, null);
    }

    public BRelTime getTrendInterval() {
        return (BRelTime)this.get(trendInterval);
    }

    public void setTrendInterval(BRelTime v) {
        this.set(trendInterval, (BValue)v, null);
    }

    public BTimeTrigger getRealTimeRate() {
        return (BTimeTrigger)this.get(realTimeRate);
    }

    public void setRealTimeRate(BTimeTrigger v) {
        this.set(realTimeRate, (BValue)v, null);
    }

    public BLink getExecuteLink() {
        return (BLink)this.get(executeLink);
    }

    public void setExecuteLink(BLink v) {
        this.set(executeLink, (BValue)v, null);
    }

    public int getRandomChance() {
        return this.getInt(randomChance);
    }

    public void setRandomChance(int v) {
        this.setInt(randomChance, v, null);
    }

    public int getRandomAmount() {
        return this.getInt(randomAmount);
    }

    public void setRandomAmount(int v) {
        this.setInt(randomAmount, v, null);
    }

    public void rebuildHistory() {
        this.invoke(rebuildHistory, null, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        try {
            BIHistory h = this.resolveHistory(null);
            try (HistoryDatabaseConnection db = this.getDbConnection(null);){
                BAbsTime last = db.getLastTimestamp(h);
                if (!last.isNull()) {
                    BITable c = db.timeQuery(h, last, null);
                    TableCursor cur = c.cursor();
                    while (cur.next()) {
                        BNumericTrendRecord rec = (BNumericTrendRecord)cur.get();
                        this.lastRecord = rec.getValue();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.steady = true;
        this.execute();
        this.update();
    }

    public void changed(Property p, Context c) {
        if (this.steady) {
            if (Flags.isUserDefined1((BComplex)this, (Slot)p)) {
                this.rebuildHistory();
            } else if (p.equals(enabled)) {
                this.update();
            }
        }
        super.changed(p, c);
    }

    public void doRebuildHistory(Context cx) throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.deleteHistory(cx);
        this.lastRecord = 0.0;
        this.doUpdate(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdate(Context cx) {
        BNumericHistorySimulator bNumericHistorySimulator = this;
        synchronized (bNumericHistorySimulator) {
            if (this.updating) {
                return;
            }
            if (!this.isValid()) {
                return;
            }
            this.updating = true;
        }
        try (Object db = this.getDbConnection(cx);){
            BAbsTime to;
            BAbstractSchedule sch = this.getSchedule();
            BIHistory h = this.resolveHistory(cx);
            BAbsTime now = Clock.time();
            BAbsTime start = to = this.align(now, this.getTrendInterval());
            int i = this.getMonths();
            while (--i >= 0) {
                start = start.prevMonth();
            }
            BAbsTime first = db.getFirstTimestamp(h);
            BAbsTime from = start;
            BRelTime ivl = this.getTrendInterval();
            if (first.isNull()) {
                from = start;
            } else if (first.isAfter(start)) {
                this.clearHistory(cx);
                from = start;
            } else {
                BAbsTime last = db.getLastTimestamp(h);
                from = this.align(last, ivl);
                while (!from.isAfter(last)) {
                    from = from.add(ivl);
                }
            }
            boolean totalized = this.getTotalized();
        }
        catch (Exception x) {
            this.setMessage(x.toString());
        }
        finally {
            BNumericHistorySimulator bNumericHistorySimulator2 = this;
            synchronized (bNumericHistorySimulator2) {
                this.updating = false;
            }
        }
    }

    public boolean isValid() {
        if (!this.steady) {
            return false;
        }
        return this.getEnabled();
    }

    public BTrendRecord getHistoryRecord() {
        return new BNumericTrendRecord();
    }

    public BTrendRecord getHistoryRecord(BAbsTime t, BStatusValue v) {
        if (this.record == null) {
            this.record = this.getHistoryRecord();
        }
        this.record.setTimestamp(t);
        this.record.setStatus(v.getStatus());
        this.record.set(this.record.getValueProperty(), v.getValueValue());
        return this.record;
    }

    public BIcon getIcon() {
        return icon;
    }

    public BAbstractSchedule getSchedule() {
        String s = this.getValueSchedule();
        if (s.equals("")) {
            throw new IllegalStateException(Utils.lex("invalidOrd"));
        }
        s = BFormat.format((String)s, (Object)((Object)this));
        BAbstractSchedule ret = (BAbstractSchedule)BOrd.make((String)s).get((BObject)this);
        if (!s.equals(this.getResolvedSchedule())) {
            this.setResolvedSchedule(s);
        }
        return ret;
    }

    public void onExecute(BStatusValue out, Context cx) {
        if (!this.isValid()) {
            return;
        }
        try {
            BAbsTime now = Clock.time();
            BStatusValue val = this.getSchedule().getOutput(now);
            out.setStatus(val.getStatus());
            double d = this.applyMultipliers(Clock.time(), val.getValueValue());
            if (this.getTotalized()) {
                d += this.lastRecord;
            }
            out.setValueValue((BValue)BDouble.make((double)d));
        }
        catch (Exception x) {
            this.setMessage(x.toString());
        }
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        if (a != update && a != rebuildHistory) {
            return super.post(a, arg, cx);
        }
        threads.enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    public BIHistory resolveHistory(Context cx) throws Exception {
        if (this.history == null) {
            try (HistoryDatabaseConnection db = this.getDbConnection(cx);){
                String dev = this.getHistoryDevice();
                dev = BFormat.format((String)dev, (Object)((Object)this));
                if (dev.equals("^")) {
                    dev = Sys.getStation().getStationName();
                }
                String name = this.getHistoryName();
                BHistoryId hid = BHistoryId.make((String)dev, (String)(name = BFormat.format((String)name, (Object)((Object)this))));
                if (!hid.equivalent((Object)this.getResolvedHistory())) {
                    if (!this.getResolvedHistory().isNull()) {
                        this.deleteHistory(cx);
                    }
                    this.setResolvedHistory(hid);
                }
                BTrendRecord rec = this.getHistoryRecord();
                BHistoryConfig config = new BHistoryConfig(hid, rec.getType().getTypeSpec(), BCapacity.UNLIMITED);
                config.setSource(BOrdList.make((BOrd)this.getSlotPathOrd()));
                config.setTimeZone(Clock.time().getTimeZone());
                config.add("valueFacets", (BValue)this.getFacets());
                config.tags().merge(this.tags().getAll());
                config.setInterval(BCollectionInterval.make((BRelTime)this.getTrendInterval()));
                if (db.exists(hid)) {
                    db.reconfigureHistory(config);
                } else {
                    this.lastRecord = 0.0;
                    db.createHistory(config);
                }
                this.history = db.getHistory(hid);
                this.tags().set(Id.newId((String)"n:history"), (BIDataValue)BString.make((String)hid.toString(null)));
            }
        }
        return this.history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started() throws Exception {
        Class<BNumericHistorySimulator> clazz = BNumericHistorySimulator.class;
        synchronized (BNumericHistorySimulator.class) {
            if (threads == null) {
                threads = new ThreadPool("NumericHistorySim", 0, 1, 4, 1000);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (Sys.atSteadyState()) {
                this.atSteadyState();
            }
            super.started();
            return;
        }
    }

    public void stopped() throws Exception {
        this.steady = false;
        if (threads != null) {
            threads.stop();
        }
        threads = null;
        super.stopped();
    }

    protected BAbsTime align(BAbsTime t, BRelTime i) {
        long aligned;
        long millis = t.getMillis();
        if (millis == (aligned = millis - millis % i.getMillis())) {
            return t;
        }
        return BAbsTime.make((long)aligned);
    }

    protected double applyMultipliers(BAbsTime date, BValue v) {
        double val = ((BDouble)v).getDouble();
        switch (date.getMonth().getOrdinal()) {
            case 0: {
                val *= this.getJanMultiplier();
                break;
            }
            case 1: {
                val *= this.getFebMultiplier();
                break;
            }
            case 2: {
                val *= this.getMarMultiplier();
                break;
            }
            case 3: {
                val *= this.getAprMultiplier();
                break;
            }
            case 4: {
                val *= this.getMayMultiplier();
                break;
            }
            case 5: {
                val *= this.getJunMultiplier();
                break;
            }
            case 6: {
                val *= this.getJulMultiplier();
                break;
            }
            case 7: {
                val *= this.getAugMultiplier();
                break;
            }
            case 8: {
                val *= this.getSepMultiplier();
                break;
            }
            case 9: {
                val *= this.getOctMultiplier();
                break;
            }
            case 10: {
                val *= this.getNovMultiplier();
                break;
            }
            default: {
                val *= this.getDecMultiplier();
            }
        }
        val = date.getYear() % 2 == 0 ? (val *= this.getEvenYearMultiplier()) : (val *= this.getOddYearMultiplier());
        return this.tryRandom(val);
    }

    protected void clearHistory(Context cx) throws Exception {
        try (HistoryDatabaseConnection db = this.getDbConnection(cx);){
            BHistoryId hid = this.getResolvedHistory();
            if (!db.exists(hid)) {
                String dev = this.getHistoryDevice();
                dev = BFormat.format((String)dev, (Object)((Object)this));
                String name = this.getHistoryName();
                name = BFormat.format((String)name, (Object)((Object)this));
                hid = BHistoryId.make((String)dev, (String)name);
            }
            if (db.exists(hid)) {
                db.clearAllRecords(hid);
            }
        }
    }

    protected void deleteHistory(Context cx) throws Exception {
        try (HistoryDatabaseConnection db = this.getDbConnection(cx);){
            BHistoryId hid = this.getResolvedHistory();
            if (!db.exists(hid)) {
                String dev = this.getHistoryDevice();
                dev = BFormat.format((String)dev, (Object)((Object)this));
                String name = this.getHistoryName();
                name = BFormat.format((String)name, (Object)((Object)this));
                hid = BHistoryId.make((String)dev, (String)name);
            }
            if (db.exists(hid)) {
                db.deleteHistory(hid);
            }
            this.history = null;
        }
    }

    protected HistoryDatabaseConnection getDbConnection(Context cx) {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        return db.getDbConnection(cx);
    }

    protected double tryRandom(double val) {
        if (Math.random() * 100.0 > (double)this.getRandomChance()) {
            return val;
        }
        double pct = (double)this.getRandomAmount() / 100.0;
        double adder = val * pct * Math.random();
        if (Math.random() < 0.55555) {
            return val + adder;
        }
        return val - adder;
    }
}

