/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.trend;

import com.tridiumx.analytics.data.AbstractAnalyticValue;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import com.tridiumx.analytics.trend.AbstractTrendWrapper;
import com.tridiumx.analytics.util.Utils;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class DeltaTrend
extends AbstractTrendWrapper {
    private NumericValue cache = new NumericValue();
    private long lastTs;
    private double lastVal;
    private int lastSts;
    private BInterpolationTrendFlags lastTrendFlags;
    private boolean leading = true;

    public DeltaTrend(AnalyticTrend trend) {
        super(trend);
        if (trend.hasNext()) {
            AnalyticValue row = trend.next();
            this.lastTs = row.getTimestamp();
            this.lastVal = row.toNumeric();
            this.lastSts = row.getStatus();
            this.lastTrendFlags = ((AbstractAnalyticValue)row).getTrendFlags();
        }
        this.leading = trend.getContext().getLeadingDeltas();
    }

    @Override
    protected AnalyticValue getNext() {
        if (!this.trend.hasNext()) {
            return null;
        }
        AnalyticValue row = this.trend.next();
        int sts = this.lastSts | row.getStatus();
        BInterpolationTrendFlags itf = ((AbstractAnalyticValue)row).getTrendFlags();
        this.lastTrendFlags = BInterpolationTrendFlags.make(this.lastTrendFlags.getBits() | itf.getBits());
        double cur = row.toNumeric();
        double delta = cur - this.lastVal;
        if (!Values.isValid(sts) || Utils.isEqualTo(cur, 0.0) || Double.isNaN(delta) || Double.isInfinite(delta)) {
            delta = 0.0;
        } else if (delta < 0.0 && cur > 0.0 && cur < Math.abs(delta)) {
            delta = cur;
        }
        if (this.leading) {
            this.cache.set(this.lastTs, delta, this.lastSts, this.lastTrendFlags);
            this.lastTs = row.getTimestamp();
        } else {
            this.lastTs = row.getTimestamp();
            this.cache.set(this.lastTs, delta, this.lastSts, this.lastTrendFlags);
        }
        this.lastSts = row.getStatus();
        this.lastVal = cur;
        this.lastTrendFlags = ((AbstractAnalyticValue)row).getTrendFlags();
        return this.cache;
    }
}

