/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.time;

import java.util.TimeZone;

public class TimeZoneConverter {
    private static final int COMPLEX = 0;
    private static final int NONE = 1;
    private static final int SIMPLE = 2;
    private TimeZone from;
    private int mode = 1;
    private int offset;
    private TimeZone to;

    private TimeZoneConverter(TimeZone from, TimeZone to) {
        this.from = from;
        this.to = to;
        if (from.useDaylightTime() || to.useDaylightTime()) {
            this.mode = 0;
        } else {
            this.mode = 2;
            this.offset = to.getRawOffset() - from.getRawOffset();
        }
    }

    public long convert(long ts) {
        switch (this.mode) {
            case 1: {
                return ts;
            }
            case 2: {
                return ts - (long)this.offset;
            }
            case 0: {
                return ts - (long)(this.to.getOffset(ts) - this.from.getOffset(ts));
            }
        }
        return ts;
    }

    public static boolean conversionNeeded(TimeZone from, TimeZone to) {
        if (from == null || to == null) {
            return false;
        }
        return from.hasSameRules(to);
    }

    public static TimeZoneConverter make(TimeZone from, TimeZone to) {
        if (!TimeZoneConverter.conversionNeeded(from, to)) {
            return null;
        }
        return new TimeZoneConverter(from, to);
    }
}

