/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.report;

import com.tridiumx.analytics.report.BAnalyticReportParam;
import com.tridiumx.analytics.report.BReportType;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="repName", type="String", defaultValue="Report"), @NiagaraProperty(name="description", type="String", defaultValue=""), @NiagaraProperty(name="reportType", type="analytics:ReportType", defaultValue="BReportType.spectrum"), @NiagaraProperty(name="filePath", type="baja:Ord", defaultValue="BOrd.DEFAULT", flags=69), @NiagaraProperty(name="location", type="baja:DynamicEnum", defaultValue="BDynamicEnum.DEFAULT"), @NiagaraProperty(name="lastUpdated", type="baja:AbsTime", defaultValue="BAbsTime.DEFAULT")})
@NiagaraActions(value={@NiagaraAction(name="getConfig", returnType="baja:String", flags=260), @NiagaraAction(name="saveConfig", parameterType="baja:String", defaultValue="BString.make(\"{}\")", flags=4), @NiagaraAction(name="updateReport", parameterType="analytics:AnalyticReportParam", defaultValue="new BAnalyticReportParam()", flags=4)})
public class BAnalyticReport
extends BComponent {
    public static final Property repName = BAnalyticReport.newProperty((int)0, (String)"Report", null);
    public static final Property description = BAnalyticReport.newProperty((int)0, (String)"", null);
    public static final Property reportType = BAnalyticReport.newProperty((int)0, (BValue)BReportType.spectrum, null);
    public static final Property filePath = BAnalyticReport.newProperty((int)69, (BValue)BOrd.DEFAULT, null);
    public static final Property location = BAnalyticReport.newProperty((int)0, (BValue)BDynamicEnum.DEFAULT, null);
    public static final Property lastUpdated = BAnalyticReport.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    public static final Action getConfig = BAnalyticReport.newAction((int)260, null);
    public static final Action saveConfig = BAnalyticReport.newAction((int)4, (BValue)BString.make((String)"{}"), null);
    public static final Action updateReport = BAnalyticReport.newAction((int)4, (BValue)new BAnalyticReportParam(), null);
    public static final Type TYPE = Sys.loadType(BAnalyticReport.class);

    public String getRepName() {
        return this.getString(repName);
    }

    public void setRepName(String v) {
        this.setString(repName, v, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public BReportType getReportType() {
        return (BReportType)this.get(reportType);
    }

    public void setReportType(BReportType v) {
        this.set(reportType, (BValue)v, null);
    }

    public BOrd getFilePath() {
        return (BOrd)this.get(filePath);
    }

    public void setFilePath(BOrd v) {
        this.set(filePath, (BValue)v, null);
    }

    public BDynamicEnum getLocation() {
        return (BDynamicEnum)this.get(location);
    }

    public void setLocation(BDynamicEnum v) {
        this.set(location, (BValue)v, null);
    }

    public BAbsTime getLastUpdated() {
        return (BAbsTime)this.get(lastUpdated);
    }

    public void setLastUpdated(BAbsTime v) {
        this.set(lastUpdated, (BValue)v, null);
    }

    public BString getConfig() {
        return (BString)this.invoke(getConfig, null, null);
    }

    public void saveConfig(BString parameter) {
        this.invoke(saveConfig, (BValue)parameter, null);
    }

    public void updateReport(BAnalyticReportParam parameter) {
        this.invoke(updateReport, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BString doGetConfig() {
        String contents = "{}";
        BOrd filePath = this.getFilePath();
        if (filePath == null || filePath.isNull()) {
            return BString.make((String)contents);
        }
        BIFile file = (BIFile)filePath.get();
        try {
            contents = FileUtil.readString((Reader)new InputStreamReader(file.getInputStream()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return BString.make((String)contents);
    }

    public void doUpdateReport(BAnalyticReportParam param) {
        this.lease();
        this.setRepName(param.getRepName());
        this.setDescription(param.getDescription());
        this.setLastUpdated(BAbsTime.now());
        BFolder parent = (BFolder)this.getParent();
        parent.rename(this.getPropertyInParent(), SlotPath.escape((String)param.getRepName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSaveConfig(BString content) {
        BIFile file = (BIFile)this.getFilePath().get();
        OutputStream stream = null;
        try {
            byte[] contentBytes = content.getString().getBytes();
            stream = file.getOutputStream();
            stream.write(contentBytes);
            this.setLastUpdated(BAbsTime.now());
        }
        catch (IOException e) {
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

