/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.poll;

import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.poll.AnalyticConfigurable;
import com.tridiumx.analytics.poll.AnalyticRunnable;
import com.tridiumx.analytics.util.Utils;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public class BAnalyticPoller
extends BComponent {
    public static final Property enabled = BAnalyticPoller.newProperty((int)0, (boolean)true, null);
    public static final Property size = BAnalyticPoller.newProperty((int)3, (int)0, null);
    public static final Property progress = BAnalyticPoller.newProperty((int)3, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Property lastCycle = BAnalyticPoller.newProperty((int)3, (BValue)BRelTime.DEFAULT, null);
    public static final Property avgCycle = BAnalyticPoller.newProperty((int)3, (BValue)BRelTime.DEFAULT, null);
    public static final Property maxCycle = BAnalyticPoller.newProperty((int)3, (BValue)BRelTime.DEFAULT, null);
    public static final Property minInterval = BAnalyticPoller.newProperty((int)0, (BValue)BRelTime.DEFAULT, null);
    public static final Action resetStatistics = BAnalyticPoller.newAction((int)0, null);
    public static final Topic cycleComplete = BAnalyticPoller.newTopic((int)8, null);
    public static final Type TYPE = Sys.loadType(BAnalyticPoller.class);
    protected IdentityHashMap<AnalyticRunnable, AnalyticRunnable> allItems = new IdentityHashMap();
    protected int cycles;
    protected long cycleSum;
    private String lastName;
    protected ArrayList<AnalyticConfigurable> queue = new ArrayList();
    protected IdentityHashMap<AnalyticRunnable, AnalyticRunnable> toRemove = new IdentityHashMap();
    private final AtomicBoolean executing = new AtomicBoolean(false);

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public int getSize() {
        return this.getInt(size);
    }

    public void setSize(int v) {
        this.setInt(size, v, null);
    }

    public int getProgress() {
        return this.getInt(progress);
    }

    public void setProgress(int v) {
        this.setInt(progress, v, null);
    }

    public BRelTime getLastCycle() {
        return (BRelTime)this.get(lastCycle);
    }

    public void setLastCycle(BRelTime v) {
        this.set(lastCycle, (BValue)v, null);
    }

    public BRelTime getAvgCycle() {
        return (BRelTime)this.get(avgCycle);
    }

    public void setAvgCycle(BRelTime v) {
        this.set(avgCycle, (BValue)v, null);
    }

    public BRelTime getMaxCycle() {
        return (BRelTime)this.get(maxCycle);
    }

    public void setMaxCycle(BRelTime v) {
        this.set(maxCycle, (BValue)v, null);
    }

    public BRelTime getMinInterval() {
        return (BRelTime)this.get(minInterval);
    }

    public void setMinInterval(BRelTime v) {
        this.set(minInterval, (BValue)v, null);
    }

    public void resetStatistics() {
        this.invoke(resetStatistics, null, null);
    }

    public void fireCycleComplete(BValue event) {
        this.fire(cycleComplete, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doExecute() {
        BAnalyticService svc = BAnalyticService.getInstance();
        if (svc == null || !svc.isSteady()) {
            this.clean();
            return;
        }
        int qsize = this.queueSize();
        if (!this.isRunning() || !this.getEnabled() || qsize <= 0) {
            this.clean();
            return;
        }
        if (!this.executing.compareAndSet(false, true)) {
            Utils.log().log(Level.WARNING, Utils.lex("trigPollerAlreadyRunning"), new Object[]{this.getNavName()});
            return;
        }
        try {
            this.setProgress(0);
            long start = System.currentTimeMillis();
            long end = start + this.getRate().getMillis();
            long sleep = 0L;
            int i = 0;
            while (this.isRunning() && this.getEnabled() && qsize > i && svc.isSteady()) {
                block26: {
                    try {
                        AnalyticRunnable task;
                        ArrayList<AnalyticConfigurable> arrayList = this.queue;
                        synchronized (arrayList) {
                            task = this.queue.get(i);
                        }
                        if (task.getEnabled() && !this.toRemove.containsKey(task)) {
                            task.run();
                            break block26;
                        }
                        Thread.yield();
                        qsize = this.queueSize();
                        ++i;
                        continue;
                    }
                    catch (Exception x) {
                        Utils.log().finer(x.getLocalizedMessage());
                    }
                }
                if (!svc.isSteady()) break;
                qsize = this.queueSize();
                if (this.isRunning() && this.getEnabled() && i < qsize) {
                    int remaining = qsize - ++i;
                    this.setProgress(this.toPercent(i, qsize));
                    if (remaining <= 0) {
                        this.clean();
                    }
                    sleep = end - System.currentTimeMillis();
                    if (remaining > 0) {
                        sleep /= (long)(remaining + 1);
                    }
                    sleep = Math.max(sleep, this.getMinInterval().getMillis());
                    if (this.getMaxInterval().getMillis() > 0L) {
                        sleep = Math.min(sleep, this.getMaxInterval().getMillis());
                    }
                    BAnalyticPoller x = this;
                    synchronized (x) {
                        if (sleep > 0L) {
                            try {
                                ((Object)((Object)this)).wait(sleep);
                            }
                            catch (Exception exception) {}
                        } else {
                            Thread.yield();
                        }
                    }
                }
                qsize = this.queueSize();
            }
            this.setProgress(100);
            if (this.isRunning() && this.getEnabled()) {
                long tmp = System.currentTimeMillis() - start;
                BRelTime cycle = BRelTime.make((long)tmp);
                this.setLastCycle(cycle);
                if (tmp > this.getMaxCycle().getMillis()) {
                    this.setMaxCycle(cycle);
                }
                this.cycleSum += tmp;
                ++this.cycles;
                tmp = this.cycleSum / (long)this.cycles;
                this.setAvgCycle(BRelTime.make((long)tmp));
            }
            this.clean();
            this.fireCycleComplete(null);
        }
        finally {
            this.executing.set(false);
        }
    }

    public void doResetStatistics() {
        this.cycles = 0;
        this.cycleSum = 0L;
        this.setAvgCycle(BRelTime.DEFAULT);
        this.setMaxCycle(BRelTime.DEFAULT);
    }

    public BIcon getIcon() {
        return Utils.iconPoller;
    }

    public void started() throws Exception {
        this.doResetStatistics();
        this.syncWithService();
        super.started();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        Object object = this.queue;
        synchronized (object) {
            this.queue.clear();
            this.toRemove.clear();
            this.allItems.clear();
        }
        object = this;
        synchronized (object) {
            ((Object)((Object)this)).notifyAll();
        }
        try {
            this.lastName = null;
            BAnalyticService.getInstance().unregisterPoller(this.lastName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AnalyticConfigurable r) {
        ArrayList<AnalyticConfigurable> arrayList = this.queue;
        synchronized (arrayList) {
            if (!this.allItems.containsKey(r)) {
                this.allItems.put(r, r);
                this.queue.add(r);
                this.setSize(this.allItems.size() - this.toRemove.size());
            } else {
                this.toRemove.remove(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(AnalyticConfigurable r) {
        ArrayList<AnalyticConfigurable> arrayList = this.queue;
        synchronized (arrayList) {
            if (this.allItems.containsKey(r)) {
                this.toRemove.put(r, r);
                this.setSize(this.allItems.size() - this.toRemove.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clean() {
        BAnalyticService service = BAnalyticService.getInstance();
        if (this.toRemove.isEmpty()) {
            return;
        }
        ArrayList<AnalyticConfigurable> arrayList = this.queue;
        synchronized (arrayList) {
            int i = this.queue.size();
            while (--i >= 0) {
                AnalyticConfigurable task = this.queue.get(i);
                if (service.getStatus().isFault()) {
                    task.updateConfig();
                }
                if (!this.toRemove.containsKey(task)) continue;
                this.queue.remove(i);
                this.allItems.remove(task);
                this.toRemove.remove(task);
            }
        }
    }

    protected BRelTime getMaxInterval() {
        return BRelTime.DEFAULT;
    }

    protected BRelTime getRate() {
        return BRelTime.DEFAULT;
    }

    protected void syncWithService() {
        BAnalyticService svc = BAnalyticService.getInstance();
        if (this.lastName != null) {
            svc.unregisterPoller(this.lastName);
        }
        if (this.isRunning()) {
            this.lastName = this.getDisplayName(null);
            svc.registerPoller(this.lastName, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int queueSize() {
        ArrayList<AnalyticConfigurable> arrayList = this.queue;
        synchronized (arrayList) {
            return this.queue.size();
        }
    }

    private int toPercent(int count, int size) {
        if (count == 0) {
            return 0;
        }
        if (count >= size) {
            return 100;
        }
        if (size <= 0) {
            return 100;
        }
        float res = (float)count / (float)size * 100.0f;
        return (int)res;
    }
}

